/*
 * Decompiled with CFR 0.152.
 */
package sbaz.util;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import sbaz.Servlet;
import sbaz.SimpleUniverse;
import sbaz.util.JettyBazaarRunner$;
import sbaz.util.RichFile$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JettyBazaarRunner
implements ScalaObject {
    public volatile int bitmap$0;
    private SimpleUniverse bazaarUniverse;
    private final String bazaarKeylessRequestsText = Predef$.MODULE$.augmentString("<keylessRequests> \n      |  <edit nameregex=\".*\"/>\n      |  <read/>\n      |</keylessRequests>\n      |").stripMargin();

    public void runServer(Function1<Server, Object> body) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("dirname", this.bazaarDir().getAbsolutePath());
        Server server = new Server(this.bazaarPort());
        Context context = new Context((HandlerContainer)server, "/", 1);
        ServletHolder servletHolder = new ServletHolder((javax.servlet.Servlet)new Servlet());
        servletHolder.setInitParameters(initParams);
        context.addServlet(servletHolder, this.bazaarRoot());
        server.start();
        Log.info((String)this.bazaarUniverse().toString());
        Log.info((String)new StringBuilder().append((Object)"Bazaar directory: ").append((Object)this.bazaarDir()).toString());
        while (server.isStarting()) {
            Thread.sleep(1000L);
        }
        if (server.isStarted()) {
            body.apply((Object)server);
            if (!server.isStopping() && !server.isStopped()) {
                server.stop();
            }
            if (!server.isStopped()) {
                server.join();
            }
            return;
        }
        throw new RuntimeException("Server failed to start");
    }

    public void setupServerDir() {
        if (!this.bazaarDir().exists()) {
            this.bazaarDir().mkdir();
            RichFile$.MODULE$.pimpFileToRichFile(new File(this.bazaarDir(), "keylessRequests")).write(new $anonfun$setupServerDir$1(this));
            RichFile$.MODULE$.pimpFileToRichFile(new File(this.bazaarDir(), "universe")).write(new $anonfun$setupServerDir$2(this));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleUniverse bazaarUniverse() {
        if ((this.bitmap$0 & 1) != 0) return this.bazaarUniverse;
        JettyBazaarRunner jettyBazaarRunner = this;
        synchronized (jettyBazaarRunner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.bazaarUniverse = new SimpleUniverse(this.bazaarUniverseName(), new URL(this.bazaarUrl()));
                this.bitmap$0 |= 1;
            }
            return this.bazaarUniverse;
        }
    }

    public String bazaarUrl() {
        return Predef$.MODULE$.augmentString("http://%s:%d%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bazaarHost(), BoxesRunTime.boxToInteger((int)this.bazaarPort()), this.bazaarRoot()}));
    }

    public String bazaarKeylessRequestsText() {
        return this.bazaarKeylessRequestsText;
    }

    public abstract String bazaarUniverseName();

    public abstract File bazaarDir();

    public abstract String bazaarRoot();

    public abstract String bazaarHost();

    public abstract int bazaarPort();
}

