/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.CustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.EventInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.PEModule;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.PropertyInfo;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.util.Signature;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.util.ArrayList;

final class PEType
extends Type
implements Signature {
    final PEFile file;
    final int definingRow;
    final int methodListBeg;
    final int methodListEnd;
    protected MethodBase[] methoddefs;

    PEType(PEModule pEModule, int n, String string, Type type, int n2, PEFile pEFile, int n3) {
        super(pEModule, n, string, null, null, type, n2);
        this.file = pEFile;
        this.definingRow = n3;
        this.methodListBeg = pEFile.TypeDef((int)n3).MethodList;
        this.methodListEnd = n3 < pEFile.TypeDef.rows ? pEFile.TypeDef((int)(n3 + 1)).MethodList : pEFile.MethodDef.rows + 1;
    }

    protected void loadBaseType() {
        Table.TypeDef typeDef = this.file.TypeDef(this.definingRow);
        this.baseType = typeDef.Extends == 0 ? null : ((PEModule)this.Module).getTypeDefOrRef(typeDef.Extends);
    }

    protected void loadFields() {
        ArrayList<PEFieldInfo> arrayList = new ArrayList<PEFieldInfo>();
        int n = this.file.TypeDef((int)this.definingRow).FieldList;
        int n2 = this.file.FieldDef.rows + 1;
        if (this.definingRow < this.file.TypeDef.rows) {
            n2 = this.file.TypeDef((int)(this.definingRow + 1)).FieldList;
        }
        for (int i = n; i < n2; ++i) {
            int n3 = this.file.FieldTrans.rows == 0 ? i : this.file.FieldTrans((int)i).Field;
            int n4 = this.file.FieldDef((int)n3).Flags;
            String string = this.file.FieldDef.getName();
            PEFile.Sig sig = this.file.FieldDef.getSignature();
            Type type = sig.decodeFieldType();
            Object object = null;
            Table.Constant constant = this.file.Constant;
            for (int j = 1; j <= constant.rows; ++j) {
                constant.readRow(j);
                int n5 = Table.getTableId(1, constant.Parent);
                int n6 = constant.Parent >> Table.NoBits[1];
                if (n5 != 4 || n6 != n3) continue;
                object = constant.getValue();
            }
            PEFieldInfo pEFieldInfo = new PEFieldInfo(i, string, n4, type, object);
            if (pEFieldInfo.Name.equals("value__") && pEFieldInfo.IsSpecialName()) {
                assert (this.underlyingType == null) : this.underlyingType.toString();
                this.underlyingType = pEFieldInfo.FieldType;
            }
            arrayList.add(pEFieldInfo);
        }
        this.fields = arrayList.toArray(FieldInfo.EMPTY_ARRAY);
        arrayList.clear();
    }

    protected MethodInfo getMethod(int n) {
        return (MethodInfo)this.methoddefs[n - this.methodListBeg];
    }

    protected void loadMethods() {
        this.methoddefs = new MethodBase[this.methodListEnd - this.methodListBeg];
        ArrayList arrayList = new ArrayList();
        ArrayList<PEMethodInfo> arrayList2 = new ArrayList<PEMethodInfo>();
        PEModule pEModule = (PEModule)this.Module;
        for (int i = this.methodListBeg; i < this.methodListEnd; ++i) {
            int n;
            int n2 = this.file.MethodTrans.rows == 0 ? i : this.file.MethodTrans((int)i).Method;
            int n3 = this.file.MethodDef((int)n2).Flags;
            String string = this.file.MethodDef.getName();
            PEFile.Sig sig = this.file.MethodDef.getSignature();
            int n4 = sig.readByte();
            int n5 = sig.decodeInt();
            sig.skipByte(16);
            Type type = sig.decodeRetType();
            Type[] typeArray = new Type[n5];
            for (int j = 0; j < n5; ++j) {
                typeArray[j] = sig.decodeParamType();
            }
            ParameterInfo[] parameterInfoArray = new ParameterInfo[n5];
            int n6 = this.file.MethodDef.ParamList;
            int n7 = this.file.ParamDef.rows + 1;
            if (this.file.MethodDef.currentRow() < this.file.MethodDef.rows) {
                n7 = this.file.MethodDef((int)(n2 + 1)).ParamList;
            }
            for (n = n6; n < n7; ++n) {
                int n8 = this.file.ParamDef((int)n).Flags;
                String string2 = this.file.ParamDef.getName();
                int n9 = this.file.ParamDef.Sequence;
                if (n9 == 0) continue;
                parameterInfoArray[n9 - 1] = new ParameterInfo(string2, typeArray[n9 - 1], n8, n9 - 1);
            }
            for (n = 0; n < parameterInfoArray.length; ++n) {
                if (parameterInfoArray[n] != null) continue;
                parameterInfoArray[n] = new ParameterInfo(null, typeArray[n], 0, 0);
            }
            MethodBase methodBase = null;
            methodBase = (n3 & 0x800) != 0 && (n3 & 0x1000) != 0 && (string.equals(".ctor") || string.equals(".cctor")) ? new PEConstructorInfo(i, n3, parameterInfoArray) : new PEMethodInfo(i, string, n3, type, parameterInfoArray);
            (((MethodBase)methodBase).IsConstructor() ? arrayList2 : arrayList).add((PEMethodInfo)methodBase);
            this.methoddefs[i - this.methodListBeg] = methodBase;
        }
        this.constructors = arrayList2.toArray(ConstructorInfo.EMPTY_ARRAY);
        this.methods = arrayList.toArray(MethodInfo.EMPTY_ARRAY);
        arrayList2.clear();
        arrayList.clear();
    }

    protected void loadProperties() {
        Table.PropertyMap propertyMap = this.file.PropertyMap;
        if (propertyMap == null) {
            this.properties = PropertyInfo.EMPTY_ARRAY;
            return;
        }
        Table.PropertyDef propertyDef = this.file.PropertyDef;
        int n = -1;
        int n2 = propertyDef.rows + 1;
        for (int i = 1; i <= propertyMap.rows; ++i) {
            propertyMap.readRow(i);
            if (propertyMap.Parent != this.definingRow) continue;
            n = propertyMap.PropertyList;
            if (i >= propertyMap.rows) break;
            propertyMap.readRow(i + 1);
            n2 = propertyMap.PropertyList;
            break;
        }
        if (n < 0) {
            this.properties = PropertyInfo.EMPTY_ARRAY;
            return;
        }
        ArrayList<PEPropertyInfo> arrayList = new ArrayList<PEPropertyInfo>();
        for (int i = n; i < n2; ++i) {
            propertyDef.readRow(i);
            PEFile.Sig sig = propertyDef.getSignature();
            int n3 = sig.readByte();
            int n4 = sig.readByte();
            assert ((n3 &= 0xFFFFFFDF) == 8);
            Type type = sig.decodeType();
            int n5 = Table.encodeIndex(i, 6, 23);
            Table.MethodSemantics methodSemantics = this.file.MethodSemantics;
            MethodInfo methodInfo = null;
            MethodInfo methodInfo2 = null;
            for (int j = 1; j <= methodSemantics.rows; ++j) {
                methodSemantics.readRow(j);
                if (methodSemantics.Association != n5) continue;
                if (methodSemantics.isGetter()) {
                    methodInfo = this.getMethod(methodSemantics.Method);
                    continue;
                }
                if (methodSemantics.isSetter()) {
                    methodInfo2 = this.getMethod(methodSemantics.Method);
                    continue;
                }
                System.err.println("PEType.loadProperties(): !?!");
            }
            arrayList.add(new PEPropertyInfo(i, propertyDef.getName(), (short)propertyDef.Flags, type, methodInfo, methodInfo2));
        }
        this.properties = arrayList.toArray(PropertyInfo.EMPTY_ARRAY);
    }

    protected void loadEvents() {
        Table.EventMap eventMap = this.file.EventMap;
        if (eventMap == null) {
            this.events = EventInfo.EMPTY_ARRAY;
            return;
        }
        Table.EventDef eventDef = this.file.EventDef;
        int n = -1;
        int n2 = eventDef.rows + 1;
        for (int i = 1; i <= eventMap.rows; ++i) {
            eventMap.readRow(i);
            if (eventMap.Parent != this.definingRow) continue;
            n = eventMap.EventList;
            if (i >= eventMap.rows) break;
            eventMap.readRow(i + 1);
            n2 = eventMap.EventList;
            break;
        }
        if (n < 0) {
            this.events = EventInfo.EMPTY_ARRAY;
            return;
        }
        ArrayList<PEEventInfo> arrayList = new ArrayList<PEEventInfo>();
        Table.MethodSemantics methodSemantics = this.file.MethodSemantics;
        for (int i = n; i < n2; ++i) {
            eventDef.readRow(i);
            Type type = ((PEModule)this.Module).getTypeDefOrRef(eventDef.EventType);
            int n3 = Table.encodeIndex(i, 6, 20);
            MethodInfo methodInfo = null;
            MethodInfo methodInfo2 = null;
            for (int j = 1; j <= methodSemantics.rows; ++j) {
                methodSemantics.readRow(j);
                if (methodSemantics.Association != n3) continue;
                if (methodSemantics.isAddOn()) {
                    methodInfo = this.getMethod(methodSemantics.Method);
                    continue;
                }
                if (!methodSemantics.isRemoveOn()) continue;
                methodInfo2 = this.getMethod(methodSemantics.Method);
            }
            arrayList.add(new PEEventInfo(i, eventDef.getName(), (short)eventDef.EventFlags, type, methodInfo, methodInfo2));
        }
        this.events = arrayList.toArray(EventInfo.EMPTY_ARRAY);
    }

    protected void loadNestedTypes() {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 1; i <= this.file.NestedClass.rows; ++i) {
            this.file.NestedClass.readRow(i);
            if (this.file.NestedClass.EnclosingClass != this.definingRow) continue;
            arrayList.add(((PEModule)this.Module).getTypeDef(this.file.NestedClass.NestedClass));
        }
        this.nestedTypes = arrayList.toArray(Type.EmptyTypes);
    }

    protected void loadInterfaces() {
        this.interfaces = Type.EmptyTypes;
        int n = this.file.InterfaceImpl.findType(this.definingRow);
        if (n > 0) {
            ArrayList<Type> arrayList = new ArrayList<Type>();
            for (int i = n; i <= this.file.InterfaceImpl.rows; ++i) {
                this.file.InterfaceImpl.readRow(i);
                if (this.file.InterfaceImpl.Class != this.definingRow) break;
                arrayList.add(((PEModule)this.Module).getTypeDefOrRef(this.file.InterfaceImpl.Interface));
            }
            this.interfaces = arrayList.toArray(new Type[arrayList.size()]);
        }
    }

    protected void loadCustomAttributes(Type type) {
        this.initAttributes(this, this.definingRow, 2, type);
    }

    private void initAttributes(CustomAttributeProvider customAttributeProvider, int n, int n2, Type type) {
        ((PEModule)this.Module).initAttributes(customAttributeProvider, n, n2, type);
    }

    private class PEEventInfo
    extends EventInfo {
        private final int definingRow;

        public PEEventInfo(int n, String string, short s, Type type, MethodInfo methodInfo, MethodInfo methodInfo2) {
            super(string, PEType.this, s, type, methodInfo, methodInfo2);
            this.definingRow = n;
        }

        protected void loadCustomAttributes(Type type) {
            PEType.this.initAttributes(this, this.definingRow, 20, type);
        }
    }

    private class PEPropertyInfo
    extends PropertyInfo {
        private final int definingRow;

        public PEPropertyInfo(int n, String string, short s, Type type, MethodInfo methodInfo, MethodInfo methodInfo2) {
            super(string, PEType.this, s, type, methodInfo, methodInfo2);
            this.definingRow = n;
        }

        protected void loadCustomAttributes(Type type) {
            PEType.this.initAttributes(this, this.definingRow, 23, type);
        }
    }

    private class PEConstructorInfo
    extends ConstructorInfo {
        private final int definingRow;

        public PEConstructorInfo(int n, int n2, ParameterInfo[] parameterInfoArray) {
            super((Type)PEType.this, n2, parameterInfoArray);
            this.definingRow = n;
        }

        protected void loadCustomAttributes(Type type) {
            PEType.this.initAttributes(this, this.definingRow, 6, type);
        }
    }

    private class PEMethodInfo
    extends MethodInfo {
        private final int definingRow;

        public PEMethodInfo(int n, String string, int n2, Type type, ParameterInfo[] parameterInfoArray) {
            super(string, (Type)PEType.this, n2, type, parameterInfoArray);
            this.definingRow = n;
        }

        protected void loadCustomAttributes(Type type) {
            PEType.this.initAttributes(this, this.definingRow, 6, type);
        }
    }

    private class PEFieldInfo
    extends FieldInfo {
        private final int definingRow;

        public PEFieldInfo(int n, String string, int n2, Type type, Object object) {
            super(string, PEType.this, n2, type, object);
            this.definingRow = n;
        }

        protected void loadCustomAttributes(Type type) {
            PEType.this.initAttributes(this, this.definingRow, 4, type);
        }
    }
}

