/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.io.Serializable;
import java.math.MathContext;
import scala.Array$;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$BigDecimal$;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericConversions;
import scala.math.ScalaNumericConversions$class;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends ScalaNumber
implements ScalaNumericConversions,
ScalaObject,
Serializable {
    private final MathContext mc;
    private final java.math.BigDecimal bigDecimal;

    public static final BigDecimal double2bigDecimal(double d) {
        return BigDecimal$.MODULE$.double2bigDecimal(d);
    }

    public static final BigDecimal long2bigDecimal(long l) {
        return BigDecimal$.MODULE$.long2bigDecimal(l);
    }

    public static final BigDecimal int2bigDecimal(int n) {
        return BigDecimal$.MODULE$.int2bigDecimal(n);
    }

    public static final BigDecimal valueOf(double d, MathContext mathContext) {
        return BigDecimal$.MODULE$.valueOf(d, mathContext);
    }

    public static final BigDecimal valueOf(double d) {
        return BigDecimal$.MODULE$.valueOf(d);
    }

    public static final MathContext defaultMathContext() {
        return BigDecimal$.MODULE$.defaultMathContext();
    }

    public BigDecimal(java.math.BigDecimal bigDecimal, MathContext mc) {
        this.bigDecimal = bigDecimal;
        this.mc = mc;
        ScalaNumericConversions$class.$init$(this);
    }

    public String toString() {
        return this.bigDecimal().toString();
    }

    /*
     * WARNING - void declaration
     */
    public Option<BigInt> toBigIntExact() {
        void var1_1;
        Option exceptionResult1;
        try {
            exceptionResult1 = new Some<BigInt>(new BigInt(this.bigDecimal().toBigIntegerExact()));
        }
        catch (ArithmeticException arithmeticException) {
            exceptionResult1 = None$.MODULE$;
        }
        return var1_1;
    }

    public BigInt toBigInt() {
        return new BigInt(this.bigDecimal().toBigInteger());
    }

    public NumericRange.Inclusive<BigDecimal> to(BigDecimal end, BigDecimal step) {
        return Range$BigDecimal$.MODULE$.inclusive(this, end, step);
    }

    public Range.Partial<BigDecimal, NumericRange.Inclusive<BigDecimal>> to(BigDecimal end$2) {
        return new Range.Partial<BigDecimal, NumericRange.Inclusive<BigDecimal>>(new $anonfun$to$1(this, end$2));
    }

    public NumericRange.Exclusive<BigDecimal> until(BigDecimal end, BigDecimal step) {
        return Range$BigDecimal$.MODULE$.apply(this, end, step);
    }

    public Range.Partial<BigDecimal, NumericRange.Exclusive<BigDecimal>> until(BigDecimal end$1) {
        return new Range.Partial<BigDecimal, NumericRange.Exclusive<BigDecimal>>(new $anonfun$until$1(this, end$1));
    }

    public long toLongExact() {
        return this.bigDecimal().longValueExact();
    }

    public int toIntExact() {
        return this.bigDecimal().intValueExact();
    }

    public short toShortExact() {
        return this.bigDecimal().shortValueExact();
    }

    public byte toByteExact() {
        return this.bigDecimal().byteValueExact();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimal().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.bigDecimal().floatValue();
    }

    @Override
    public long longValue() {
        return this.bigDecimal().longValue();
    }

    @Override
    public int intValue() {
        return this.bigDecimal().intValue();
    }

    public char charValue() {
        return (char)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    public BigDecimal setScale(int scale, Enumeration.Value mode) {
        return this.bigdec2BigDecimal(this.bigDecimal().setScale(scale, mode.id()));
    }

    public BigDecimal setScale(int scale) {
        return this.bigdec2BigDecimal(this.bigDecimal().setScale(scale));
    }

    public BigDecimal apply(MathContext mc) {
        return BigDecimal$.MODULE$.apply(this.bigDecimal().toString(), mc);
    }

    public BigDecimal ulp() {
        return this.bigdec2BigDecimal(this.bigDecimal().ulp());
    }

    public int scale() {
        return this.bigDecimal().scale();
    }

    public BigDecimal round(MathContext mc) {
        return this.bigdec2BigDecimal(this.bigDecimal().round(mc));
    }

    public int precision() {
        return this.bigDecimal().precision();
    }

    public int signum() {
        return this.bigDecimal().signum();
    }

    public BigDecimal abs() {
        return this.bigdec2BigDecimal(this.bigDecimal().abs(this.mc()));
    }

    public BigDecimal unary_$minus() {
        return this.bigdec2BigDecimal(this.bigDecimal().negate(this.mc()));
    }

    public BigDecimal pow(int n) {
        return this.bigdec2BigDecimal(this.bigDecimal().pow(n, this.mc()));
    }

    public BigDecimal remainder(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().remainder(that.bigDecimal(), this.mc()));
    }

    public BigDecimal max(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().max(that.bigDecimal()));
    }

    public BigDecimal min(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().min(that.bigDecimal()));
    }

    public BigDecimal quot(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().divideToIntegralValue(that.bigDecimal(), this.mc()));
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<BigDecimal, BigDecimal> $div$percent(BigDecimal that) {
        boolean bl;
        java.math.BigDecimal[] temp4 = this.bigDecimal().divideAndRemainder(that.bigDecimal(), this.mc());
        Option temp5 = Array$.MODULE$.unapplySeq(temp4);
        if (temp5.isEmpty()) {
            throw new MatchError(temp4.toString());
        }
        IndexedSeq temp6 = (IndexedSeq)temp5.get();
        if (temp6 == null || temp6.equals(null)) {
            bl = false;
        } else {
            void y0;
            void x0;
            int n = temp6.lengthCompare(2);
            int n2 = 0;
            Integer n3 = BoxesRunTime.boxToInteger(n2);
            Integer n4 = BoxesRunTime.boxToInteger(n);
            bl = n4 == n3 ? true : (x0 == null ? false : (x0 instanceof Number || x0 instanceof Character ? BoxesRunTime.equals2(x0, y0) : x0.equals(y0)));
        }
        if (bl) {
            java.math.BigDecimal temp7 = (java.math.BigDecimal)temp6.apply(0);
            java.math.BigDecimal temp8 = (java.math.BigDecimal)temp6.apply(1);
            return new Tuple2<BigDecimal, BigDecimal>(this.bigdec2BigDecimal(temp7), this.bigdec2BigDecimal(temp8));
        }
        throw new MatchError(temp4.toString());
    }

    public BigDecimal $div(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().divide(that.bigDecimal(), this.mc()));
    }

    public BigDecimal $times(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().multiply(that.bigDecimal(), this.mc()));
    }

    public BigDecimal $minus(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().subtract(that.bigDecimal(), this.mc()));
    }

    public BigDecimal $plus(BigDecimal that) {
        return this.bigdec2BigDecimal(this.bigDecimal().add(that.bigDecimal(), this.mc()));
    }

    public boolean $greater(BigDecimal that) {
        return this.compare(that) > 0;
    }

    public boolean $less(BigDecimal that) {
        return this.compare(that) < 0;
    }

    public boolean $greater$eq(BigDecimal that) {
        return this.compare(that) >= 0;
    }

    public boolean $less$eq(BigDecimal that) {
        return this.compare(that) <= 0;
    }

    public int compare(BigDecimal that) {
        return this.bigDecimal().compareTo(that.bigDecimal());
    }

    public boolean equals(BigDecimal that) {
        return this.compare(that) == 0;
    }

    @Override
    public java.math.BigDecimal underlying() {
        return this.bigDecimal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWhole() {
        void y0;
        void x0;
        int n = 1;
        BigDecimal$ bigDecimal$ = BigDecimal$.MODULE$;
        int n2 = 0;
        BigDecimal$ bigDecimal$2 = BigDecimal$.MODULE$;
        BigDecimal bigDecimal = bigDecimal$2.apply(n2, bigDecimal$2.defaultMathContext());
        BigDecimal bigDecimal2 = this.remainder(bigDecimal$.apply(n, bigDecimal$.defaultMathContext()));
        return bigDecimal2 == bigDecimal ? true : (x0 == null ? false : (x0 instanceof Number || x0 instanceof Character ? BoxesRunTime.equals2(x0, y0) : x0.equals(y0)));
    }

    public boolean equals(Object that) {
        boolean bl;
        if (that instanceof BigDecimal) {
            BigDecimal temp2 = (BigDecimal)that;
            bl = this.equals(temp2);
        } else if (that instanceof BigInt) {
            BigInt temp3 = (BigInt)that;
            bl = this.toBigIntExact().exists(new $anonfun$equals$1(this, temp3));
        } else {
            bl = this.unifiedPrimitiveEquals(that);
        }
        return bl;
    }

    public int hashCode() {
        int n;
        if (this.isWhole()) {
            n = this.unifiedPrimitiveHashcode();
        } else {
            double d = this.doubleValue();
            n = ((Object)BoxesRunTime.boxToDouble(d)).hashCode();
        }
        return n;
    }

    private BigDecimal bigdec2BigDecimal(java.math.BigDecimal x) {
        return new BigDecimal(x, this.mc());
    }

    public BigDecimal(java.math.BigDecimal bigDecimal) {
        this(bigDecimal, BigDecimal$.MODULE$.defaultMathContext());
    }

    public MathContext mc() {
        return this.mc;
    }

    public java.math.BigDecimal bigDecimal() {
        return this.bigDecimal;
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericConversions$class.unifiedPrimitiveEquals(this, x);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericConversions$class.unifiedPrimitiveHashcode(this);
    }

    @Override
    public boolean isValidChar() {
        return ScalaNumericConversions$class.isValidChar(this);
    }

    @Override
    public boolean isValidInt() {
        return ScalaNumericConversions$class.isValidInt(this);
    }

    @Override
    public boolean isValidShort() {
        return ScalaNumericConversions$class.isValidShort(this);
    }

    @Override
    public boolean isValidByte() {
        return ScalaNumericConversions$class.isValidByte(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericConversions$class.toDouble(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericConversions$class.toFloat(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericConversions$class.toLong(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericConversions$class.toInt(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericConversions$class.toShort(this);
    }

    @Override
    public byte toByte() {
        return ScalaNumericConversions$class.toByte(this);
    }

    @Override
    public char toChar() {
        return ScalaNumericConversions$class.toChar(this);
    }
}

