/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import sbaz.AvailablePackage;
import sbaz.Filename;
import sbaz.Filename$;
import sbaz.InstalledEntry;
import sbaz.InstalledList;
import sbaz.Package;
import sbaz.PackageSpec;
import sbaz.ProposedChanges;
import sbaz.Version;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.Nil$;

public class InstalledListTest
extends TestCase
implements ScalaObject {
    private final InstalledList list;
    private final InstalledEntry barEntry;
    private final InstalledEntry fooEntry = new InstalledEntry(new Package("foo", new Version("1.0"), (scala.collection.immutable.Set)new ListSet(), "a package for foo-ing"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filename[]{Filename$.MODULE$.reldirectory((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib"})), Filename$.MODULE$.relfile((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib", "foo.jar"}))})));

    public InstalledListTest() {
        this.barEntry = new InstalledEntry(new Package("bar", new Version("1.0"), (scala.collection.immutable.Set)new ListSet(), "a package for bar-ing"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filename[]{Filename$.MODULE$.reldirectory((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib"})), Filename$.MODULE$.relfile((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib", "bar.jar"}))})));
        this.list = new InstalledList();
        this.list().add(this.fooEntry());
        this.list().add(this.barEntry());
    }

    public void testBreakingChange() {
        ProposedChanges.Removal removeA;
        Package a = new Package("A", new Version("1.0"), (scala.collection.immutable.Set)new ListSet(), "I do not depend on anything");
        ListSet depsOnA = new ListSet().$plus((Object)"A");
        Package b = new Package("B", new Version("1.0"), (scala.collection.immutable.Set)depsOnA, "I depend on A");
        Package c = new Package("C", new Version("1.0"), (scala.collection.immutable.Set)depsOnA, "I also depend on A");
        InstalledEntry installedA = new InstalledEntry(a, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filename[]{Filename$.MODULE$.reldirectory((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib"})), Filename$.MODULE$.relfile((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib", "A.jar"}))})));
        InstalledEntry installedB = new InstalledEntry(b, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filename[]{Filename$.MODULE$.reldirectory((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib"})), Filename$.MODULE$.relfile((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib", "B.jar"}))})));
        InstalledEntry installedC = new InstalledEntry(c, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filename[]{Filename$.MODULE$.reldirectory((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib"})), Filename$.MODULE$.relfile((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib", "C.jar"}))})));
        InstalledList list = new InstalledList();
        AvailablePackage availableB = new AvailablePackage(b, new URL("http://nowhere.com/b.sbp"));
        ProposedChanges.AdditionFromNet additionB = new ProposedChanges.AdditionFromNet(availableB);
        ProposedChanges.AdditionFromNet additionFromNet = additionB;
        Set brokenB = list.identifyBreakingChanges(Nil$.MODULE$.$colon$colon((Object)additionFromNet).toSeq());
        Assert.assertTrue((brokenB.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)brokenB.contains((Object)new Tuple2((Object)b, (Object)depsOnA)));
        list.add(installedC);
        ProposedChanges.AdditionFromNet additionFromNet2 = additionB;
        Set brokenB2 = list.identifyBreakingChanges(Nil$.MODULE$.$colon$colon((Object)additionFromNet2).toSeq());
        Assert.assertTrue((brokenB2.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)brokenB2.contains((Object)new Tuple2((Object)b, (Object)depsOnA)));
        list.add(installedA);
        list.add(installedB);
        ProposedChanges.Removal removal = removeA = new ProposedChanges.Removal(a.spec());
        Set brokenRemoval = list.identifyBreakingChanges(Nil$.MODULE$.$colon$colon((Object)removal).toSeq());
        Assert.assertTrue((brokenRemoval.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)brokenRemoval.contains((Object)new Tuple2((Object)b, (Object)depsOnA)));
        Assert.assertTrue((boolean)brokenRemoval.contains((Object)new Tuple2((Object)c, (Object)depsOnA)));
    }

    public void testIncludesFile() {
        Assert.assertTrue((boolean)this.list().entriesWithFile(Filename$.MODULE$.relfile((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blahblah"}))).isEmpty());
        List fooEnts = this.list().entriesWithFile(Filename$.MODULE$.relfile((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib", "foo.jar"})));
        Assert.assertTrue((fooEnts.length() == 1 ? 1 : 0) != 0);
        PackageSpec packageSpec = ((InstalledEntry)fooEnts.apply(0)).packageSpec();
        PackageSpec packageSpec2 = this.fooEntry().packageSpec();
        Assert.assertTrue((!(packageSpec != null ? !packageSpec.equals(packageSpec2) : packageSpec2 != null) ? 1 : 0) != 0);
        List libEnts = this.list().entriesWithFile(Filename$.MODULE$.reldirectory((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lib"})));
        Assert.assertTrue((libEnts.length() == 2 ? 1 : 0) != 0);
    }

    public InstalledList list() {
        return this.list;
    }

    public InstalledEntry barEntry() {
        return this.barEntry;
    }

    public InstalledEntry fooEntry() {
        return this.fooEntry;
    }
}

