/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.util;

import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.util.Position;
import scala.tools.nsc.util.Position$;
import scala.tools.nsc.util.Position$class;
import scala.tools.nsc.util.SourceFile;

public class OffsetPosition
implements Position,
ScalaObject {
    private final int point;
    private final SourceFile source;

    public OffsetPosition(SourceFile source, int point) {
        this.source = source;
        this.point = point;
        Position$class.$init$(this);
    }

    public String show() {
        return new StringBuilder().append((Object)"[").append((Object)BoxesRunTime.boxToInteger((int)this.point())).append((Object)"]").toString();
    }

    public String toString() {
        String pointmsg = this.point() > this.source().length() ? "out-of-bounds-" : "offset=";
        return Predef$.MODULE$.augmentString("source-%s,line-%s,%s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.source().path(), BoxesRunTime.boxToInteger((int)this.line()), pointmsg, BoxesRunTime.boxToInteger((int)this.point())}));
    }

    public int hashCode() {
        return this.point() * 37 + this.source().file().hashCode();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object temp6 = that;
        if (temp6 instanceof OffsetPosition) {
            void var4_4;
            OffsetPosition temp7;
            OffsetPosition that2 = temp7 = (OffsetPosition)temp6;
            if (!true) throw new MatchError(temp6.toString());
            that2 = temp7;
            if (this.point() != var4_4.point()) return false;
            AbstractFile abstractFile = this.source().file();
            AbstractFile abstractFile2 = var4_4.source().file();
            if (abstractFile != null) {
                if (!abstractFile.equals(abstractFile2)) return false;
                return true;
            }
            if (abstractFile2 == null) return true;
            return false;
        }
        if (!true) throw new MatchError(temp6.toString());
        return false;
    }

    public Position union(Position pos) {
        return pos.isRange() ? pos : this;
    }

    public int column() {
        int col = 0;
        for (int idx = this.source().lineToOffset(this.source().offsetToLine(this.point())); idx != this.point(); ++idx) {
            col += this.source().content()[idx] == '\t' ? Position$.MODULE$.tabInc() - col % Position$.MODULE$.tabInc() : 1;
        }
        return col + 1;
    }

    public int line() {
        return this.source().offsetToLine(this.point()) + 1;
    }

    public OffsetPosition withSource(SourceFile source, int shift) {
        return new OffsetPosition(source, this.point() + shift);
    }

    public OffsetPosition withPoint(int off) {
        return new OffsetPosition(this.source(), off);
    }

    public int pointOrElse(int n) {
        return this.point();
    }

    public boolean isDefined() {
        return true;
    }

    public int point() {
        return this.point;
    }

    public SourceFile source() {
        return this.source;
    }

    public String dbgString() {
        return Position$class.dbgString(this);
    }

    public Position inUltimateSource(SourceFile source) {
        return Position$class.inUltimateSource(this, source);
    }

    public String lineContent() {
        return Position$class.lineContent(this);
    }

    public boolean sameRange(Position pos) {
        return Position$class.sameRange(this, pos);
    }

    public boolean overlaps(Position pos) {
        return Position$class.overlaps(this, pos);
    }

    public boolean properlyPrecedes(Position pos) {
        return Position$class.properlyPrecedes(this, pos);
    }

    public boolean precedes(Position pos) {
        return Position$class.precedes(this, pos);
    }

    public boolean properlyIncludes(Position pos) {
        return Position$class.properlyIncludes(this, pos);
    }

    public boolean includes(Position pos) {
        return Position$class.includes(this, pos);
    }

    public Position focusEnd() {
        return Position$class.focusEnd(this);
    }

    public Position focus() {
        return Position$class.focus(this);
    }

    public Position focusStart() {
        return Position$class.focusStart(this);
    }

    public Position withEnd(int off) {
        return Position$class.withEnd(this, off);
    }

    public Position withStart(int off) {
        return Position$class.withStart(this, off);
    }

    public Option offset() {
        return Position$class.offset(this);
    }

    public int endOrPoint() {
        return Position$class.endOrPoint(this);
    }

    public int end() {
        return Position$class.end(this);
    }

    public int startOrPoint() {
        return Position$class.startOrPoint(this);
    }

    public int start() {
        return Position$class.start(this);
    }

    public Position makeTransparent() {
        return Position$class.makeTransparent(this);
    }

    public boolean isOpaqueRange() {
        return Position$class.isOpaqueRange(this);
    }

    public boolean isRange() {
        return Position$class.isRange(this);
    }

    public boolean isTransparent() {
        return Position$class.isTransparent(this);
    }
}

