/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2010, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: SetQuantifier.scala 20154 2009-12-16 16:07:30Z cunei $


package scala.dbc
package statement


/** A set quantifier that defines the collection type of a relation. */
abstract class SetQuantifier {
  /** A SQL-99 compliant string representation of the set quantifier. */
  def sqlString: String
}

object SetQuantifier {

  /** A set quantifier that defines a relation as being a bag. That means
   *  that duplicates are allowed.
   */
  case object AllTuples extends SetQuantifier {
    /** A SQL-99 compliant string representation of the set quantifier. */
    def sqlString: String = "ALL"
  }

  /** A set quantifier that defines a relation as being a set. That means
   *  that duplicates are not allowed and will be pruned.
   */
  case object DistinctTuples extends SetQuantifier {
    /** A SQL-99 compliant string representation of the set quantifier. */
    def sqlString: String = "DISTINCT"
  }
}
