/* NSC -- new Scala compiler
 * Copyright 2002-2010 LAMP/EPFL
 * @author Martin Odersky
 */
// $Id: ReporterTimer.scala 20154 2009-12-16 16:07:30Z cunei $

package scala.tools.nsc
package reporters

import scala.tools.util.AbstractTimer

/**
 * This class implements a timer that uses a Reporter to issue
 * timings.
 */
class ReporterTimer(reporter: Reporter) extends AbstractTimer {

  def issue(msg: String, duration: Long) =
    reporter.info(null, "[" + msg + " in " + duration + "ms]", false)

}
