/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.DependencyError;
import sbaz.Filename;
import sbaz.InstalledEntry;
import sbaz.InstalledList;
import sbaz.ManagedDirectory$;
import sbaz.Package;
import sbaz.ProposedChanges;
import sbaz.Universe;
import sbaz.Universe$;
import sbaz.download.Download;
import sbaz.download.Downloader;
import sbaz.download.Downloader$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Node;
import scala.xml.XML$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedDirectory
implements ScalaObject {
    private final File scala_lib_jar;
    private final File sbaz_jar;
    private final boolean isWin;
    private Universe universe;
    private final InstalledList installed;
    private AvailableList available;
    private final Downloader downloader;
    private final FileLock lock;
    private final File misc_dir;
    private final File meta_dir;
    private final File lib_dir;
    private final File directory;

    public ManagedDirectory(File directory) {
        this.directory = directory;
        this.lib_dir = new File(directory, "lib");
        this.meta_dir = new File(directory, "meta");
        this.misc_dir = new File(directory, "misc");
        if (this.lib_dir().isDirectory() || this.meta_dir().isDirectory() || this.misc_dir().isDirectory()) {
            File lockFile = new File(this.meta_dir(), ".lock");
            lockFile.deleteOnExit();
            this.lock = new RandomAccessFile(lockFile, "rw").getChannel().tryLock();
            FileLock fileLock = this.lock();
            if (fileLock != null && !fileLock.equals(null) && this.lock().isValid()) {
                this.downloader = Downloader$.MODULE$.apply(new File(this.meta_dir(), "cache"));
                this.available = this.loadXML("available", new $anonfun$1(this), new AvailableList((List<AvailablePackage>)Nil$.MODULE$));
                this.installed = this.loadXML("installed", new $anonfun$2(this), new InstalledList());
                this.universe = Universe$.MODULE$.fromFile(new File(this.meta_dir(), "universe"));
                this.universe().keyringFilesAreIn(this.meta_dir());
                this.isWin = System.getProperty("os.name").startsWith("Windows");
                this.sbaz_jar = new File(this.misc_dir(), new StringBuilder().append((Object)"sbaz").append((Object)File.separator).append((Object)"sbaz.jar").toString());
                this.scala_lib_jar = new File(this.misc_dir(), new StringBuilder().append((Object)"sbaz").append((Object)File.separator).append((Object)"scala-library.jar").toString());
                return;
            }
            throw new Error(new StringBuilder().append((Object)"Directory ").append((Object)directory).append((Object)" is locked by another process.").toString());
        }
        throw new Error(new StringBuilder().append((Object)"Directory ").append((Object)directory).append((Object)" does not appear to be a sbaz-managed directory").toString());
    }

    private final void lp$2(InputStream inputStream, FileOutputStream fileOutputStream) {
        byte[] dat;
        int numread;
        while ((numread = inputStream.read(dat = new byte[100])) >= 0) {
            fileOutputStream.write(dat, 0, numread);
        }
    }

    public String toString() {
        return new StringBuilder().append((Object)"(").append((Object)this.directory().toString()).append((Object)": ").append((Object)BoxesRunTime.boxToInteger((int)this.installed().size())).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)this.available().numPackages())).append((Object)" packages)").toString();
    }

    public void compact() {
        this.downloader().flushCache();
    }

    public void updateAvailable() {
        this.available_$eq(this.universe().retrieveAvailable());
        this.saveAvailable();
    }

    private void downloadURL(URL url, File file) {
        URLConnection connection = url.openConnection();
        InputStream inputStream$1 = connection.getInputStream();
        FileOutputStream f$1 = new FileOutputStream(file);
        this.lp$2(inputStream$1, f$1);
        f$1.close();
    }

    public final void sbaz$ManagedDirectory$$removeNoCheck(InstalledEntry entry) {
        this.removeEntryFiles(entry);
        this.installed().remove(entry.packageSpec());
        this.saveInstalled();
    }

    public void remove(InstalledEntry entry) {
        if (this.installed().anyDependOn(entry.name())) {
            throw new DependencyError(new StringBuilder().append((Object)"Package ").append((Object)entry.name()).append((Object)" is still needed").toString());
        }
        this.sbaz$ManagedDirectory$$removeNoCheck(entry);
    }

    private void removeEntryFiles(InstalledEntry entry) {
        List fullFiles = (List)entry.files().map((Function1)new $anonfun$8(this), List$.MODULE$.canBuildFrom());
        List sortedFiles = (List)fullFiles.sortWith((Function2)new $anonfun$9(this));
        sortedFiles.withFilter((Function1)new $anonfun$removeEntryFiles$1(this)).foreach((Function1)new $anonfun$removeEntryFiles$2(this));
    }

    public void install(File file) {
        if (file.exists()) {
            this.makeChanges((scala.collection.immutable.Seq<ProposedChanges.ProposedChange>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ProposedChanges.AdditionFromFile[]{new ProposedChanges.AdditionFromFile(file)})));
            return;
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    public void install(AvailablePackage pack) {
        this.makeChanges((scala.collection.immutable.Seq<ProposedChanges.ProposedChange>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ProposedChanges.AdditionFromNet[]{new ProposedChanges.AdditionFromNet(pack)})));
    }

    public void installNoCheck(Package pack$1, File downloadedFile) {
        Option<InstalledEntry> temp17;
        block7: {
            block8: {
                InstalledEntry newEntry;
                List zipEntsToInstall;
                ZipFile zip;
                block6: {
                    InstalledEntry temp20;
                    block5: {
                        zip = new ZipFile(downloadedFile);
                        List<? extends ZipEntry> zipEntsAll = this.mkList(zip.entries());
                        zipEntsToInstall = (List)zipEntsAll.filter((Function1)new $anonfun$6(this));
                        zipEntsToInstall.withFilter((Function1)new $anonfun$installNoCheck$1(this)).foreach((Function1)new $anonfun$installNoCheck$2(this, pack$1));
                        List installedFiles = (List)zipEntsToInstall.map((Function1)new $anonfun$7(this), List$.MODULE$.canBuildFrom());
                        newEntry = new InstalledEntry(pack$1, (List<Filename>)installedFiles);
                        temp17 = this.installed().entryNamed(pack$1.name());
                        None$ none$ = None$.MODULE$;
                        Option<InstalledEntry> option = temp17;
                        if (none$ != null ? !none$.equals(option) : option != null) break block5;
                        if (!true) {
                            throw new MatchError(temp17.toString());
                        }
                        break block6;
                    }
                    if (!(temp17 instanceof Some)) break block7;
                    Some temp19 = (Some)temp17;
                    InstalledEntry entry = temp20 = (InstalledEntry)temp19.x();
                    if (!true) break block8;
                    entry = temp20;
                    this.removeEntryFiles(entry);
                }
                this.extractFiles(zip, (List<ZipEntry>)zipEntsToInstall, this.directory());
                this.installed().add(newEntry);
                this.saveInstalled();
                zip.close();
                return;
            }
            throw new MatchError(temp17.toString());
        }
        throw new MatchError(temp17.toString());
    }

    public final void sbaz$ManagedDirectory$$unpack200(File in, File out) {
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        JarOutputStream jout = new JarOutputStream(new FileOutputStream(out));
        unpacker.unpack(in, jout);
        jout.close();
    }

    public void extractFiles(ZipFile zip$1, List<ZipEntry> entries, File directory$1) {
        entries.foreach((Function1)new $anonfun$extractFiles$1(this, zip$1, directory$1));
    }

    public final boolean sbaz$ManagedDirectory$$isPack200(ZipEntry e) {
        return e.getName().endsWith(".pack");
    }

    public final boolean sbaz$ManagedDirectory$$isSpecial(File f) {
        return this.isWin() && (f.compareTo(this.sbaz_jar()) == 0 || f.compareTo(this.scala_lib_jar()) == 0);
    }

    private File scala_lib_jar() {
        return this.scala_lib_jar;
    }

    private File sbaz_jar() {
        return this.sbaz_jar;
    }

    private boolean isWin() {
        return this.isWin;
    }

    private <A> List<A> mkList(Enumeration<A> enumeration) {
        Nil$ l = Nil$.MODULE$;
        while (enumeration.hasMoreElements()) {
            A n;
            A a = n = enumeration.nextElement();
            l = l.$colon$colon(a);
        }
        return l.reverse();
    }

    private List<AvailablePackage> extractAvailablePackages(scala.collection.immutable.Seq<ProposedChanges.ProposedChange> changes) {
        return (List)changes.iterator().foldLeft((Object)Nil$.MODULE$, (Function2)new $anonfun$extractAvailablePackages$1(this));
    }

    public void makeChanges(scala.collection.immutable.Seq<ProposedChanges.ProposedChange> changes) {
        if (this.installed().changesAcceptible((Seq<ProposedChanges.ProposedChange>)changes)) {
            Map<AvailablePackage, Download.FinalStatus> dnlResults$1 = this.downloader().download(this.extractAvailablePackages(changes));
            changes.iterator().filter((Function1)new $anonfun$makeChanges$1(this)).foreach((Function1)new $anonfun$makeChanges$2(this));
            changes.iterator().foreach((Function1)new $anonfun$makeChanges$3(this, dnlResults$1));
            return;
        }
        throw new DependencyError();
    }

    /*
     * WARNING - void declaration
     */
    public final Object sbaz$ManagedDirectory$$makeExecutable(File file) {
        void var2_2;
        Object exceptionResult1 = null;
        try {
            exceptionResult1 = Runtime.getRuntime().exec((String[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"chmod", "+x", file.getPath()}), ClassManifest$.MODULE$.classType(String.class)));
        }
        catch (IOException iOException) {
            exceptionResult1 = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public final Filename sbaz$ManagedDirectory$$zipToFilename(ZipEntry ent) {
        List list;
        if (this.sbaz$ManagedDirectory$$isPack200(ent)) {
            String name = new StringBuilder().append((Object)ent.getName().substring(0, ent.getName().lastIndexOf(46))).append((Object)".jar").toString();
            list = (List)Predef$.MODULE$.refArrayOps((Object[])name.split("/")).toList().filter((Function1)new $anonfun$4(this));
        } else {
            list = (List)Predef$.MODULE$.refArrayOps((Object[])ent.getName().split("/")).toList().filter((Function1)new $anonfun$5(this));
        }
        List pathParts = list;
        return new Filename(!ent.isDirectory(), true, (List<String>)pathParts);
    }

    public final Filename sbaz$ManagedDirectory$$zipToOutputFilename(ZipEntry ent) {
        List pathParts = (List)Predef$.MODULE$.refArrayOps((Object[])ent.getName().split("/")).toList().filter((Function1)new $anonfun$3(this));
        return new Filename(!ent.isDirectory(), true, (List<String>)pathParts);
    }

    public void setUniverse(Universe newUniverse) {
        this.clearAvailable();
        this.universe_$eq(newUniverse);
        this.saveUniverse();
    }

    private boolean clearAvailable() {
        this.available_$eq(new AvailableList((List<AvailablePackage>)Nil$.MODULE$));
        return new File(this.meta_dir(), "available").delete();
    }

    private void saveUniverse() {
        this.saveXML(this.universe().toXML(), "universe");
    }

    public void universe_$eq(Universe universe) {
        this.universe = universe;
    }

    public Universe universe() {
        return this.universe;
    }

    private void saveInstalled() {
        this.saveXML(this.installed().toXML(), "installed");
    }

    public InstalledList installed() {
        return this.installed;
    }

    private void saveAvailable() {
        this.saveXML((Node)this.available().toXML(), "available");
    }

    public void available_$eq(AvailableList availableList) {
        this.available = availableList;
    }

    public AvailableList available() {
        return this.available;
    }

    private void saveXML(Node xml, String filename) {
        File tmpFile = new File(this.meta_dir(), new StringBuilder().append((Object)filename).append((Object)".tmp").toString());
        FileWriter str = new FileWriter(tmpFile);
        str.write(xml.toString());
        str.close();
        this.renameFile(tmpFile, new File(this.meta_dir(), filename));
    }

    private <T> T loadXML(String filename, Function1<Node, T> decoder, T t) {
        File file = new File(this.meta_dir(), filename);
        return (T)(file.exists() ? decoder.apply((Object)XML$.MODULE$.load(file.getAbsolutePath())) : t);
    }

    private void renameFile(File from, File to) {
        to.delete();
        from.renameTo(to);
    }

    private Downloader downloader() {
        return this.downloader;
    }

    public FileLock lock() {
        return this.lock;
    }

    private File misc_dir() {
        return this.misc_dir;
    }

    private File meta_dir() {
        return this.meta_dir;
    }

    private File lib_dir() {
        return this.lib_dir;
    }

    public File directory() {
        return this.directory;
    }
}

