/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sbaz.FormatError;
import sbaz.Package;
import sbaz.PackageUtil$;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFile
implements ScalaObject {
    private final Package pack;
    private final File file;

    public PackageFile(File file) {
        ZipEntry ent;
        this.file = file;
        ZipFile zip = this.openZip();
        ZipEntry zipEntry = ent = zip.getEntry("meta/description");
        if (zipEntry == null || zipEntry.equals(null)) {
            throw new FormatError("malformed package file: meta/description is missing");
        }
        InputStream inBytes = zip.getInputStream(ent);
        Elem packXML = (Elem)XML$.MODULE$.load(inBytes);
        inBytes.close();
        zip.close();
        this.pack = PackageUtil$.MODULE$.fromXML((Node)packXML);
    }

    public List<String> fileNames() {
        ZipFile zip = this.openZip();
        ListBuffer names = new ListBuffer();
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry ent = enumeration.nextElement();
            String name = ent.getName();
            Object object = name.startsWith("meta/") ? BoxedUnit.UNIT : names.$plus$eq((Object)name);
        }
        return names.toList();
    }

    public Package pack() {
        return this.pack;
    }

    public ZipFile openZip() {
        return new ZipFile(this.file());
    }

    public PackageFile(String filename) {
        this(new File(filename));
    }

    public File file() {
        return this.file;
    }
}

