/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$Pair$;
import scala.ScalaObject;
import scala.Some;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.actors.AbstractActor;
import scala.actors.Actor$;
import scala.actors.Debug$;
import scala.actors.OutputChannel;
import scala.actors.remote.FreshNameCreator$;
import scala.actors.remote.LocalApply0;
import scala.actors.remote.Locator;
import scala.actors.remote.NamedSend;
import scala.actors.remote.NetKernel$;
import scala.actors.remote.Node;
import scala.actors.remote.Proxy;
import scala.actors.remote.RemoteApply0;
import scala.actors.remote.SendTo;
import scala.actors.remote.Service;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetKernel
implements ScalaObject {
    private final HashMap<Tuple2<Node, Symbol>, Proxy> proxies;
    private final HashMap<OutputChannel<Object>, Symbol> names;
    private final HashMap<Symbol, OutputChannel<Object>> actors;
    private final Service service;

    public NetKernel(Service service) {
        this.service = service;
        this.actors = new HashMap();
        this.names = new HashMap();
        this.proxies = new HashMap();
    }

    private final void liftedTree1$1(Locator locator, byte[] byArray, Symbol symbol, OutputChannel outputChannel) {
        try {
            Object msg = this.service.serializer().deserialize(byArray);
            Proxy senderProxy = this.getOrCreateProxy(locator.node(), locator.name());
            senderProxy.send(new SendTo(outputChannel, msg, symbol), (OutputChannel<Object>)null);
        }
        catch (Exception exception) {
            Debug$.MODULE$.error(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": caught ")).append(exception).toString());
        }
    }

    public void terminate() {
        this.proxies().valuesIterator().foreach(new $anonfun$terminate$1(this));
        this.service.terminate();
    }

    public void processMsg(Node senderNode, Object msg) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            Object temp51;
            block13: {
                block14: {
                    Option<OutputChannel<Object>> temp47;
                    block18: {
                        block19: {
                            block12: {
                                BoxedUnit boxedUnit;
                                block17: {
                                    block15: {
                                        block16: {
                                            OutputChannel temp49;
                                            Symbol temp60;
                                            block5: {
                                                block6: {
                                                    Option<OutputChannel<Object>> temp43;
                                                    block10: {
                                                        block11: {
                                                            block9: {
                                                                block7: {
                                                                    block8: {
                                                                        OutputChannel temp45;
                                                                        Function2<AbstractActor, Proxy, Object> temp55;
                                                                        temp51 = msg;
                                                                        if (!(temp51 instanceof RemoteApply0)) break block5;
                                                                        RemoteApply0 temp52 = (RemoteApply0)temp51;
                                                                        Locator temp53 = temp52.senderLoc();
                                                                        Locator temp54 = temp52.receiverLoc();
                                                                        Function2<AbstractActor, Proxy, Object> rfun = temp55 = temp52.rfun();
                                                                        Locator receiverLoc = temp54;
                                                                        Locator senderLoc = temp53;
                                                                        RemoteApply0 cmd = temp52;
                                                                        if (!true) break block6;
                                                                        cmd = temp52;
                                                                        senderLoc = temp53;
                                                                        receiverLoc = temp54;
                                                                        rfun = temp55;
                                                                        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": processing ")).append(cmd).toString());
                                                                        temp43 = this.actors().get(receiverLoc.name());
                                                                        if (!(temp43 instanceof Some)) break block7;
                                                                        Some temp44 = (Some)temp43;
                                                                        OutputChannel a = temp45 = (OutputChannel)temp44.x();
                                                                        if (!true) break block8;
                                                                        a = temp45;
                                                                        Proxy senderProxy = this.getOrCreateProxy(senderLoc.node(), senderLoc.name());
                                                                        senderProxy.send(new LocalApply0(rfun, (AbstractActor)a), (OutputChannel<Object>)null);
                                                                        break block9;
                                                                    }
                                                                    throw new MatchError(temp43.toString());
                                                                }
                                                                None$ none$ = None$.MODULE$;
                                                                Option<OutputChannel<Object>> option = temp43;
                                                                if (none$ != null ? !none$.equals(option) : option != null) break block10;
                                                                if (!true) break block11;
                                                                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": lost message"));
                                                            }
                                                            boxedUnit = BoxedUnit.UNIT;
                                                            break block12;
                                                        }
                                                        throw new MatchError(temp43.toString());
                                                    }
                                                    throw new MatchError(temp43.toString());
                                                }
                                                throw new MatchError(temp51.toString());
                                            }
                                            if (!(temp51 instanceof NamedSend)) break block13;
                                            NamedSend temp56 = (NamedSend)temp51;
                                            Locator temp57 = temp56.senderLoc();
                                            Locator temp58 = temp56.receiverLoc();
                                            byte[] temp59 = temp56.data();
                                            Symbol session$3 = temp60 = temp56.session();
                                            byte[] data$2 = temp59;
                                            Locator receiverLoc = temp58;
                                            Locator senderLoc$3 = temp57;
                                            NamedSend cmd = temp56;
                                            if (!true) break block14;
                                            cmd = temp56;
                                            senderLoc$3 = temp57;
                                            receiverLoc = temp58;
                                            data$2 = temp59;
                                            session$3 = temp60;
                                            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": processing ")).append(cmd).toString());
                                            temp47 = this.actors().get(receiverLoc.name());
                                            if (!(temp47 instanceof Some)) break block15;
                                            Some temp48 = (Some)temp47;
                                            OutputChannel a$3 = temp49 = (OutputChannel)temp48.x();
                                            if (!true) break block16;
                                            a$3 = temp49;
                                            this.liftedTree1$1(senderLoc$3, data$2, session$3, a$3);
                                            break block17;
                                        }
                                        throw new MatchError(temp47.toString());
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<OutputChannel<Object>> option = temp47;
                                    if (none$ != null ? !none$.equals(option) : option != null) break block18;
                                    if (!true) break block19;
                                    Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": lost message"));
                                }
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(temp47.toString());
                    }
                    throw new MatchError(temp47.toString());
                }
                throw new MatchError(temp51.toString());
            }
            throw new MatchError(temp51.toString());
        }
    }

    public void registerProxy(Node senderNode, Symbol senderName, Proxy p) {
        HashMap<Tuple2<Node, Symbol>, Proxy> hashMap = this.proxies();
        synchronized (hashMap) {
            Option<Proxy> temp39;
            block8: {
                block9: {
                    block7: {
                        Object object;
                        block5: {
                            block6: {
                                temp39 = this.proxies().get(new Tuple2<Node, Symbol>(senderNode, senderName));
                                if (!(temp39 instanceof Some)) break block5;
                                if (!true) break block6;
                                object = BoxedUnit.UNIT;
                                break block7;
                            }
                            throw new MatchError(temp39.toString());
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Proxy> option = temp39;
                        if (none$ != null ? !none$.equals(option) : option != null) break block8;
                        if (!true) break block9;
                        object = this.proxies().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(new Tuple2<Node, Symbol>(senderNode, senderName), p));
                    }
                    return;
                }
                throw new MatchError(temp39.toString());
            }
            throw new MatchError(temp39.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Proxy getOrCreateProxy(Node senderNode, Symbol senderName) {
        HashMap<Tuple2<Node, Symbol>, Proxy> hashMap = this.proxies();
        synchronized (hashMap) {
            Option<Proxy> temp35;
            block6: {
                Proxy proxy;
                temp35 = this.proxies().get(new Tuple2<Node, Symbol>(senderNode, senderName));
                if (temp35 instanceof Some) {
                    Proxy temp37;
                    Some temp36 = (Some)temp35;
                    Proxy senderProxy = temp37 = (Proxy)temp36.x();
                    if (!true) throw new MatchError(temp35.toString());
                    proxy = senderProxy = temp37;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Proxy> option = temp35;
                    if (none$ != null ? !none$.equals(option) : option != null) throw new MatchError(temp35.toString());
                    if (!true) break block6;
                    proxy = this.createProxy(senderNode, senderName);
                }
                return proxy;
            }
            throw new MatchError(temp35.toString());
        }
    }

    public HashMap<Tuple2<Node, Symbol>, Proxy> proxies() {
        return this.proxies;
    }

    /*
     * WARNING - void declaration
     */
    public Proxy createProxy(Node node, Symbol sym) {
        void var3_3;
        Proxy p = new Proxy(node, sym, this);
        this.proxies().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(new Tuple2<Node, Symbol>(node, sym), p));
        return var3_3;
    }

    public void remoteApply(Node node, Symbol name, OutputChannel<Object> from2, Function2<AbstractActor, Proxy, Object> rfun) {
        Locator senderLoc = new Locator(this.service.node(), this.getOrCreateName(from2));
        Locator receiverLoc = new Locator(node, name);
        this.sendToNode(receiverLoc.node(), new RemoteApply0(senderLoc, receiverLoc, rfun));
    }

    public void forward(OutputChannel<Object> from2, Node node, Symbol name, Object msg, Symbol session) {
        Locator senderLoc = new Locator(this.service.node(), this.getOrCreateName(from2));
        Locator receiverLoc = new Locator(node, name);
        this.namedSend(senderLoc, receiverLoc, msg, session);
    }

    public void send(Node node, Symbol name, Object msg, Symbol session) {
        Locator senderLoc = new Locator(this.service.node(), this.getOrCreateName(Actor$.MODULE$.self()));
        Locator receiverLoc = new Locator(node, name);
        this.namedSend(senderLoc, receiverLoc, msg, session);
    }

    public void send(Node node, Symbol name, Object msg) {
        this.send(node, name, msg, (Symbol)Symbol$.MODULE$.apply("nosession"));
    }

    public Symbol getOrCreateName(OutputChannel<Object> from2) {
        Option<Symbol> temp31;
        block5: {
            block6: {
                Symbol symbol;
                block4: {
                    Symbol temp34;
                    block2: {
                        block3: {
                            temp31 = this.names().get(from2);
                            None$ none$ = None$.MODULE$;
                            Option<Symbol> option = temp31;
                            if (none$ != null ? !none$.equals(option) : option != null) break block2;
                            if (!true) break block3;
                            Symbol freshName = FreshNameCreator$.MODULE$.newName("remotesender");
                            this.register(freshName, from2);
                            symbol = freshName;
                            break block4;
                        }
                        throw new MatchError(temp31.toString());
                    }
                    if (!(temp31 instanceof Some)) break block5;
                    Some temp33 = (Some)temp31;
                    Symbol name = temp34 = (Symbol)temp33.x();
                    if (!true) break block6;
                    symbol = name = temp34;
                }
                return symbol;
            }
            throw new MatchError(temp31.toString());
        }
        throw new MatchError(temp31.toString());
    }

    public void register(Symbol name, OutputChannel<Object> a) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            this.actors().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(name, a));
            this.names().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(a, name));
            return;
        }
    }

    private HashMap<OutputChannel<Object>, Symbol> names() {
        return this.names;
    }

    private HashMap<Symbol, OutputChannel<Object>> actors() {
        return this.actors;
    }

    public void namedSend(Locator senderLoc, Locator receiverLoc, Object msg, Symbol session) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.sendToNode(receiverLoc.node(), new NamedSend(senderLoc, receiverLoc, bytes, session));
    }

    public void sendToNode(Node node, Object msg) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.service.send(node, bytes);
    }
}

