/*
 * System.Reflection-like API for access to .NET assemblies (DLL & EXE)
 */

// $Id: MethodInfo.java 18773 2009-09-24 13:09:40Z dubochet $

package ch.epfl.lamp.compiler.msil;

/**
 * Discovers the attributes of a method and provides access to method metadata.
 *
 * @author Nikolay Mihaylov
 * @version 1.0
 */
public class MethodInfo extends MethodBase {

    //##########################################################################
    // public members

    public final int MemberType() { return MemberTypes.Method; }

    public final boolean IsConstructor() { return false; }

    /** The return type of this method.
     */
    public final Type ReturnType;

    //##########################################################################
    // protected members

    protected static final MethodInfo[] EMPTY_ARRAY = new MethodInfo[0];

    /**
     * Constructor Initializes a new instance of the MethodInfo class.
     */
    protected MethodInfo(String name, Type declType,
			 int attrs, Type returnType, Type[] paramTypes )
    {
	super(name, declType, attrs, paramTypes);
	ReturnType = returnType;
    }

    protected MethodInfo(String name, Type declType,
			 int attrs, Type returnType, ParameterInfo[] params )
    {
	super(name, declType, attrs, params);
	ReturnType = returnType;
    }

    public String toString() {
 	return MethodAttributes.toString(Attributes) + " " + ReturnType +
	    " " + DeclaringType + "::" + Name + params2String();
    }

    //##########################################################################

}  // class MethodInfo
