/* NSC -- new Scala compiler
 * Copyright 2005-2010 LAMP/EPFL
 * @author  Martin Odersky
 */
// $Id: EvalLoop.scala 20154 2009-12-16 16:07:30Z cunei $

package scala.tools.nsc

trait EvalLoop {

  def prompt: String

  def loop(action: (String) => Unit) {
    Console.print(prompt)
    try {
      val line = Console.readLine
      if (line.length() > 0) {
        action(line)
        loop(action)
      }
    }
    catch {
      case _: java.io.EOFException => //nop
    }
  }

}
