/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.util;

import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.util.NoPosition$;
import scala.tools.nsc.util.OffsetPosition;
import scala.tools.nsc.util.Position;
import scala.tools.nsc.util.RangePosition$;
import scala.tools.nsc.util.SourceFile;
import scala.tools.nsc.util.TransparentPosition;

public class RangePosition
extends OffsetPosition
implements ScalaObject {
    private Position focusCache;
    private final int end;
    private final int start;

    public RangePosition(SourceFile source, int start2, int point, int end) {
        this.start = start2;
        this.end = end;
        super(source, point);
        if (start2 > end) {
            Predef$.MODULE$.assert(false, (Function0)new $anonfun$1(this));
        }
        this.focusCache = NoPosition$.MODULE$;
    }

    private void focusCache_$eq(Position position) {
        this.focusCache = position;
    }

    private Position focusCache() {
        return this.focusCache;
    }

    public String show() {
        return new StringBuilder().append((Object)"[").append((Object)BoxesRunTime.boxToInteger((int)this.start())).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.end())).append((Object)"]").toString();
    }

    public String toString() {
        return new StringBuilder().append((Object)"RangePosition(").append((Object)super.source()).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)this.start())).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)super.point())).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)this.end())).append((Object)")").toString();
    }

    public Position union(Position pos) {
        return pos.isRange() ? new RangePosition(super.source(), Predef$.MODULE$.intWrapper(this.start()).min(pos.start()), super.point(), Predef$.MODULE$.intWrapper(this.end()).max(pos.end())) : this;
    }

    public boolean includes(Position pos) {
        return pos.isDefined() && this.start() <= pos.startOrPoint() && pos.endOrPoint() <= this.end();
    }

    public TransparentPosition makeTransparent() {
        return new TransparentPosition(super.source(), this.start(), super.point(), this.end());
    }

    public OffsetPosition focusEnd() {
        return new OffsetPosition(super.source(), this.end());
    }

    public Position focus() {
        if (this.focusCache() == NoPosition$.MODULE$) {
            this.focusCache_$eq(new OffsetPosition(super.source(), super.point()));
        }
        return this.focusCache();
    }

    public OffsetPosition focusStart() {
        return new OffsetPosition(super.source(), this.start());
    }

    public RangePosition withSource(SourceFile source, int shift) {
        return new RangePosition(source, this.start() + shift, super.point() + shift, this.end() + shift);
    }

    public RangePosition withPoint(int off) {
        return new RangePosition(super.source(), this.start(), off, this.end());
    }

    public RangePosition withEnd(int off) {
        return new RangePosition(super.source(), this.start(), super.point(), off);
    }

    public RangePosition withStart(int off) {
        return new RangePosition(super.source(), off, super.point(), this.end());
    }

    public int endOrPoint() {
        return this.end();
    }

    public int startOrPoint() {
        return this.start();
    }

    public boolean isOpaqueRange() {
        return true;
    }

    public boolean isRange() {
        return true;
    }

    public int end() {
        return this.end;
    }

    public int start() {
        return this.start;
    }
}

