/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2002-2009, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: SetStorage.scala 18773 2009-09-24 13:09:40Z dubochet $

package scala.xml
package persistent

import scala.collection.mutable
import java.io.File

/** A persistent store with set semantics. This class allows to add and remove 
 *  trees, but never contains two structurally equal trees.
 *
 *  @author Burak Emir
 */
class SetStorage(file: File) extends CachedFileStorage(file) {

  private var theSet: mutable.HashSet[Node] = new mutable.HashSet[Node]

  // initialize

  {
    val it = super.initialNodes
    dirty = it.hasNext
    for(x <- it) {
      theSet += x;
    }
  }

  /* forwarding methods to hashset*/

  def += (e: Node): Unit = synchronized { this.dirty = true; theSet += e }

  def -= (e: Node): Unit = synchronized { this.dirty = true; theSet -= e }

  def nodes = synchronized { theSet.iterator }

}
