/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.backend.icode;

import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.BitSet;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Stack;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.backend.WorklistAlgorithm;
import scala.tools.nsc.backend.WorklistAlgorithm$class;
import scala.tools.nsc.backend.icode.BasicBlocks;
import scala.tools.nsc.backend.icode.ICodes;
import scala.tools.nsc.backend.icode.Linearizers$DepthFirstLinerizer$;
import scala.tools.nsc.backend.icode.Linearizers$NormalLinearizer$;
import scala.tools.nsc.backend.icode.Linearizers$ReversePostOrderLinearizer$;
import scala.tools.nsc.backend.icode.Members;
import scala.tools.nsc.backend.icode.Opcodes;

public interface Linearizers
extends ScalaObject {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Linearizer
    implements ScalaObject {
        public final /* synthetic */ ICodes $outer;

        public Linearizer(ICodes $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$Linearizers$Linearizer$$$outer() {
            return this.$outer;
        }

        public abstract List<BasicBlocks.BasicBlock> linearizeAt(Members.IMethod var1, BasicBlocks.BasicBlock var2);

        public abstract List<BasicBlocks.BasicBlock> linearize(Members.IMethod var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DumpLinearizer
    extends Linearizer
    implements ScalaObject {
        public DumpLinearizer(ICodes $outer) {
            super($outer);
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$Linearizers$DumpLinearizer$$$outer() {
            return this.$outer;
        }

        @Override
        public List<BasicBlocks.BasicBlock> linearizeAt(Members.IMethod m, BasicBlocks.BasicBlock start2) {
            throw Predef$.MODULE$.error("not implemented");
        }

        @Override
        public List<BasicBlocks.BasicBlock> linearize(Members.IMethod m) {
            return m.code().blocks().toList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NormalLinearizer
    extends Linearizer
    implements WorklistAlgorithm,
    ScalaObject {
        private List<BasicBlocks.BasicBlock> blocks;
        private final Stack<BasicBlocks.BasicBlock> worklist;

        public NormalLinearizer(ICodes $outer) {
            super($outer);
            WorklistAlgorithm$class.$init$(this);
            this.worklist = new Stack();
            this.blocks = Nil$.MODULE$;
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$Linearizers$NormalLinearizer$$$outer() {
            return this.$outer;
        }

        public void add(List<BasicBlocks.BasicBlock> bs) {
            bs.foreach((Function1)new NormalLinearizer$$anonfun$add$1(this));
        }

        public void add(BasicBlocks.BasicBlock b) {
            if (!this.blocks().contains((Object)b)) {
                BasicBlocks.BasicBlock basicBlock = b;
                this.blocks_$eq((List<BasicBlocks.BasicBlock>)this.blocks().$colon$colon((Object)basicBlock));
                this.worklist().push((Object)b);
            }
        }

        @Override
        public BasicBlocks.BasicBlock dequeue() {
            return (BasicBlocks.BasicBlock)this.worklist().pop();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void processElement(BasicBlocks.BasicBlock b) {
            if (b.size() <= 0) return;
            this.add(b);
            Opcodes.Instruction temp1 = b.lastInstruction();
            if (temp1 instanceof Opcodes.opcodes.JUMP) {
                BasicBlocks.BasicBlock temp3;
                Opcodes.opcodes.JUMP temp2 = (Opcodes.opcodes.JUMP)temp1;
                BasicBlocks.BasicBlock whereto = temp3 = temp2.whereto();
                if (!true) throw new MatchError(temp1.toString());
                whereto = temp3;
                this.add(whereto);
                return;
            } else if (temp1 instanceof Opcodes.opcodes.CJUMP) {
                BasicBlocks.BasicBlock temp6;
                Opcodes.opcodes.CJUMP temp4 = (Opcodes.opcodes.CJUMP)temp1;
                BasicBlocks.BasicBlock temp5 = temp4.successBlock();
                BasicBlocks.BasicBlock failure2 = temp6 = temp4.failureBlock();
                BasicBlocks.BasicBlock success = temp5;
                if (!true) throw new MatchError(temp1.toString());
                success = temp5;
                failure2 = temp6;
                this.add(success);
                this.add(failure2);
                return;
            } else if (temp1 instanceof Opcodes.opcodes.CZJUMP) {
                BasicBlocks.BasicBlock temp11;
                Opcodes.opcodes.CZJUMP temp9 = (Opcodes.opcodes.CZJUMP)temp1;
                BasicBlocks.BasicBlock temp10 = temp9.successBlock();
                BasicBlocks.BasicBlock failure3 = temp11 = temp9.failureBlock();
                BasicBlocks.BasicBlock success = temp10;
                if (!true) throw new MatchError(temp1.toString());
                success = temp10;
                failure3 = temp11;
                this.add(success);
                this.add(failure3);
                return;
            } else if (temp1 instanceof Opcodes.opcodes.SWITCH) {
                List<BasicBlocks.BasicBlock> temp16;
                Opcodes.opcodes.SWITCH temp14 = (Opcodes.opcodes.SWITCH)temp1;
                List<BasicBlocks.BasicBlock> labels = temp16 = temp14.labels();
                if (!true) throw new MatchError(temp1.toString());
                labels = temp16;
                this.add(labels);
                return;
            } else {
                if (temp1 instanceof Opcodes.opcodes.RETURN) {
                    if (true) return;
                    throw new MatchError(temp1.toString());
                }
                if (!(temp1 instanceof Opcodes.opcodes.THROW)) throw new MatchError(temp1.toString());
                if (true) return;
                throw new MatchError(temp1.toString());
            }
        }

        public List<BasicBlocks.BasicBlock> linearize(BasicBlocks.BasicBlock startBlock$1) {
            this.run(new NormalLinearizer$$anonfun$linearize$2(this, startBlock$1));
            return this.blocks().reverse();
        }

        @Override
        public List<BasicBlocks.BasicBlock> linearizeAt(Members.IMethod m, BasicBlocks.BasicBlock start2) {
            this.blocks_$eq((List<BasicBlocks.BasicBlock>)Nil$.MODULE$);
            this.worklist().clear();
            return this.linearize(start2);
        }

        @Override
        public List<BasicBlocks.BasicBlock> linearize(Members.IMethod m$1) {
            BasicBlocks.BasicBlock b$1 = m$1.code().startBlock();
            this.blocks_$eq((List<BasicBlocks.BasicBlock>)Nil$.MODULE$);
            this.run(new NormalLinearizer$$anonfun$linearize$1(this, m$1, b$1));
            return this.blocks().reverse();
        }

        public void blocks_$eq(List<BasicBlocks.BasicBlock> list2) {
            this.blocks = list2;
        }

        public List<BasicBlocks.BasicBlock> blocks() {
            return this.blocks;
        }

        public Stack<BasicBlocks.BasicBlock> worklist() {
            return this.worklist;
        }

        public void run(Function0 initWorklist) {
            WorklistAlgorithm$class.run(this, initWorklist);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DepthFirstLinerizer
    extends Linearizer
    implements ScalaObject {
        private List<BasicBlocks.BasicBlock> blocks = Nil$.MODULE$;

        public DepthFirstLinerizer(ICodes $outer) {
            super($outer);
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$Linearizers$DepthFirstLinerizer$$$outer() {
            return this.$outer;
        }

        public boolean add(BasicBlocks.BasicBlock b) {
            boolean bl;
            if (this.blocks().contains((Object)b)) {
                bl = false;
            } else {
                BasicBlocks.BasicBlock basicBlock = b;
                this.blocks_$eq((List<BasicBlocks.BasicBlock>)this.blocks().$colon$colon((Object)basicBlock));
                bl = true;
            }
            return bl;
        }

        public void dfs(BasicBlocks.BasicBlock b) {
            if (b.size() > 0 && this.add(b)) {
                b.successors().foreach((Function1)new DepthFirstLinerizer$$anonfun$dfs$1(this));
            }
        }

        @Override
        public List<BasicBlocks.BasicBlock> linearizeAt(Members.IMethod m, BasicBlocks.BasicBlock start2) {
            this.blocks_$eq((List<BasicBlocks.BasicBlock>)Nil$.MODULE$);
            this.dfs(start2);
            return this.blocks().reverse();
        }

        @Override
        public List<BasicBlocks.BasicBlock> linearize(Members.IMethod m) {
            this.blocks_$eq((List<BasicBlocks.BasicBlock>)Nil$.MODULE$);
            this.dfs(m.code().startBlock());
            m.exh().foreach((Function1)new DepthFirstLinerizer$$anonfun$linearize$3(this));
            return this.blocks().reverse();
        }

        public void blocks_$eq(List<BasicBlocks.BasicBlock> list2) {
            this.blocks = list2;
        }

        public List<BasicBlocks.BasicBlock> blocks() {
            return this.blocks;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReversePostOrderLinearizer
    extends Linearizer
    implements ScalaObject {
        private final BitSet added;
        private HashSet<BasicBlocks.BasicBlock> visited;
        private List<BasicBlocks.BasicBlock> blocks = Nil$.MODULE$;

        public ReversePostOrderLinearizer(ICodes $outer) {
            super($outer);
            this.visited = new HashSet();
            this.added = new BitSet();
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$Linearizers$ReversePostOrderLinearizer$$$outer() {
            return this.$outer;
        }

        public void add(BasicBlocks.BasicBlock b) {
            if (!this.added().apply((Object)BoxesRunTime.boxToInteger((int)b.label()))) {
                this.added().$plus$eq(b.label());
                BasicBlocks.BasicBlock basicBlock = b;
                this.blocks_$eq((List<BasicBlocks.BasicBlock>)this.blocks().$colon$colon((Object)basicBlock));
            }
        }

        public void rpo(BasicBlocks.BasicBlock b) {
            if (b.size() > 0 && !this.visited().contains((Object)b)) {
                this.visited().$plus$eq((Object)b);
                b.successors().foreach((Function1)new ReversePostOrderLinearizer$$anonfun$rpo$1(this));
                this.add(b);
            }
        }

        @Override
        public List<BasicBlocks.BasicBlock> linearizeAt(Members.IMethod m, BasicBlocks.BasicBlock start2) {
            this.blocks_$eq((List<BasicBlocks.BasicBlock>)Nil$.MODULE$);
            this.visited().clear();
            this.added().clear();
            this.rpo(start2);
            return this.blocks();
        }

        @Override
        public List<BasicBlocks.BasicBlock> linearize(Members.IMethod m$2) {
            List list2;
            this.blocks_$eq((List<BasicBlocks.BasicBlock>)Nil$.MODULE$);
            this.visited().clear();
            this.added().clear();
            m$2.exh().foreach((Function1)new ReversePostOrderLinearizer$$anonfun$linearize$4(this));
            this.rpo(m$2.code().startBlock());
            if (m$2.code().startBlock().predecessors() == Nil$.MODULE$) {
                list2 = this.blocks();
            } else {
                BasicBlocks.BasicBlock basicBlock = m$2.code().startBlock();
                list2 = ((List)this.blocks().filterNot((Function1)new ReversePostOrderLinearizer$$anonfun$linearize$5(this, m$2))).$colon$colon((Object)basicBlock);
            }
            return list2;
        }

        public BitSet added() {
            return this.added;
        }

        public void visited_$eq(HashSet<BasicBlocks.BasicBlock> hashSet) {
            this.visited = hashSet;
        }

        public HashSet<BasicBlocks.BasicBlock> visited() {
            return this.visited;
        }

        public void blocks_$eq(List<BasicBlocks.BasicBlock> list2) {
            this.blocks = list2;
        }

        public List<BasicBlocks.BasicBlock> blocks() {
            return this.blocks;
        }
    }
}

