/* NSC -- new Scala compiler
 * Copyright 2006-2009 LAMP/EPFL
 * @author  Stephane Micheloud
 */

// $Id: Properties.scala 18773 2009-09-24 13:09:40Z dubochet $

package scala.tools.nsc

/** Loads compiler.properties from the jar. */
object Properties extends scala.util.PropertiesTrait {
  protected def propCategory    = "compiler"
  protected def pickJarBasedOn  = classOf[Global]
  
  // settings based on jar properties
  val fileEndingString      = prop("file.ending", ".scala|.java")
  val residentPromptString  = prop("resident.prompt", "\nnsc> ")
  val shellPromptString     = prop("shell.prompt", "\nscala> ")
  
  // derived values
  val cmdName               = if (isWin) "scala.bat" else "scala"
  val fileEndings           = fileEndingString.split("""\|""").toList
  
}
