/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Function0;
import scala.Function1;
import scala.Function1$class;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$class;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$class;
import scala.collection.IterableLike$class;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$class;
import scala.collection.SeqLike;
import scala.collection.SeqLike$class;
import scala.collection.SeqView;
import scala.collection.Traversable;
import scala.collection.Traversable$class;
import scala.collection.TraversableLike;
import scala.collection.TraversableLike$class;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.generic.GenericTraversableTemplate$class;
import scala.collection.generic.TraversableFactory;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector$;
import scala.collection.immutable.VectorIterator;
import scala.collection.immutable.VectorPointer;
import scala.collection.immutable.VectorPointer$class;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.StringBuilder;
import scala.compat.Platform$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassManifest;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vector<A>
implements scala.collection.immutable.Seq<A>,
GenericTraversableTemplate<A, Vector>,
SeqLike<A, Vector<A>>,
VectorPointer<A>,
ScalaObject {
    private Object[] display5;
    private Object[] display4;
    private Object[] display3;
    private Object[] display2;
    private Object[] display1;
    private Object[] display0;
    private int depth;
    private boolean dirty;
    private final int focus;
    private final int endIndex;
    private final int startIndex;

    public static final <A> Vector<A> empty() {
        return Vector$.MODULE$.empty();
    }

    public static final Vector<Nothing$> NIL() {
        return Vector$.MODULE$.NIL();
    }

    public static final <A> CanBuildFrom<Vector<?>, A, Vector<A>> canBuildFrom() {
        return Vector$.MODULE$.canBuildFrom();
    }

    public static final TraversableFactory.GenericCanBuildFrom<Nothing$> BF() {
        return Vector$.MODULE$.BF();
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static final Some unapplySeq(Seq seq2) {
        return Vector$.MODULE$.unapplySeq(seq2);
    }

    public static final <A> Vector<A> iterate(A a, int n, Function1<A, A> function1) {
        return Vector$.MODULE$.iterate(a, n, function1);
    }

    public static final Vector<Integer> range(int n, int n2, int n3) {
        return Vector$.MODULE$.range(n, n2, n3);
    }

    public static final Vector<Integer> range(int n, int n2) {
        return Vector$.MODULE$.range(n, n2);
    }

    public static final <A> Vector<Vector<Vector<Vector<Vector<A>>>>> tabulate(int n, int n2, int n3, int n4, int n5, Function5<Integer, Integer, Integer, Integer, Integer, A> function5) {
        return Vector$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static final <A> Vector<Vector<Vector<Vector<A>>>> tabulate(int n, int n2, int n3, int n4, Function4<Integer, Integer, Integer, Integer, A> function4) {
        return Vector$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static final <A> Vector<Vector<Vector<A>>> tabulate(int n, int n2, int n3, Function3<Integer, Integer, Integer, A> function3) {
        return Vector$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static final <A> Vector<Vector<A>> tabulate(int n, int n2, Function2<Integer, Integer, A> function2) {
        return Vector$.MODULE$.tabulate(n, n2, function2);
    }

    public static final <A> Vector<A> tabulate(int n, Function1<Integer, A> function1) {
        return Vector$.MODULE$.tabulate(n, function1);
    }

    public static final <A> Vector<Vector<Vector<Vector<Vector<A>>>>> fill(int n, int n2, int n3, int n4, int n5, Function0<A> function0) {
        return Vector$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static final <A> Vector<Vector<Vector<Vector<A>>>> fill(int n, int n2, int n3, int n4, Function0<A> function0) {
        return Vector$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static final <A> Vector<Vector<Vector<A>>> fill(int n, int n2, int n3, Function0<A> function0) {
        return Vector$.MODULE$.fill(n, n2, n3, function0);
    }

    public static final <A> Vector<Vector<A>> fill(int n, int n2, Function0<A> function0) {
        return Vector$.MODULE$.fill(n, n2, function0);
    }

    public static final <A> Vector<A> fill(int n, Function0<A> function0) {
        return Vector$.MODULE$.fill(n, function0);
    }

    public static final <A> Vector<A> concat(Seq<Traversable<A>> seq2) {
        return Vector$.MODULE$.concat(seq2);
    }

    public static final <A> Vector<A> empty() {
        return Vector$.MODULE$.empty();
    }

    public Vector(int startIndex, int endIndex, int focus) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.focus = focus;
        TraversableLike$class.$init$(this);
        GenericTraversableTemplate$class.$init$(this);
        Traversable$class.$init$(this);
        scala.collection.immutable.Traversable$class.$init$(this);
        IterableLike$class.$init$(this);
        Iterable$class.$init$(this);
        scala.collection.immutable.Iterable$class.$init$(this);
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        SeqLike$class.$init$(this);
        Seq$class.$init$(this);
        scala.collection.immutable.Seq$class.$init$(this);
        VectorPointer$class.$init$(this);
        this.dirty = false;
    }

    private Vector<A> dropBack0(int cutIndex) {
        int blockIndex = cutIndex - 1 & ~31;
        int lo = (cutIndex - 1 & 0x1F) + 1;
        int xor = this.startIndex ^ cutIndex - 1;
        int d = this.requiredDepth(xor);
        int shift = this.startIndex & ~((1 << 5 * d) - 1);
        Vector<A> s = new Vector<A>(this.startIndex - shift, cutIndex - shift, blockIndex - shift);
        s.initFrom(this);
        s.dirty_$eq(this.dirty());
        super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
        super.preClean(d);
        super.cleanRightEdge(cutIndex - shift);
        return s;
    }

    private Vector<A> dropFront0(int cutIndex) {
        int blockIndex = cutIndex & ~31;
        int lo = cutIndex & 0x1F;
        int xor = cutIndex ^ this.endIndex - 1;
        int d = this.requiredDepth(xor);
        int shift = cutIndex & ~((1 << 5 * d) - 1);
        Vector<A> s = new Vector<A>(cutIndex - shift, this.endIndex - shift, blockIndex - shift);
        s.initFrom(this);
        s.dirty_$eq(this.dirty());
        super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
        super.preClean(d);
        super.cleanLeftEdge(cutIndex - shift);
        return s;
    }

    private int requiredDepth(int xor) {
        block8: {
            int n;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (xor >= 32) break block2;
                                    n = 1;
                                    break block3;
                                }
                                if (xor >= 1024) break block4;
                                n = 2;
                                break block3;
                            }
                            if (xor >= 32768) break block5;
                            n = 3;
                            break block3;
                        }
                        if (xor >= 0x100000) break block6;
                        n = 4;
                        break block3;
                    }
                    if (xor >= 0x2000000) break block7;
                    n = 5;
                    break block3;
                }
                if (xor >= 0x40000000) break block8;
                n = 6;
            }
            return n;
        }
        throw new IllegalArgumentException();
    }

    private void cleanRightEdge(int cutIndex) {
        block8: {
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (cutIndex > 32) break block2;
                                    this.zeroRight(this.display0(), cutIndex);
                                    break block3;
                                }
                                if (cutIndex > 1024) break block4;
                                this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                                this.display1_$eq(this.copyLeft(this.display1(), cutIndex >>> 5));
                                break block3;
                            }
                            if (cutIndex > 32768) break block5;
                            this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                            this.display1_$eq(this.copyLeft(this.display1(), (cutIndex - 1 >>> 5 & 0x1F) + 1));
                            this.display2_$eq(this.copyLeft(this.display2(), cutIndex >>> 10));
                            break block3;
                        }
                        if (cutIndex > 0x100000) break block6;
                        this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                        this.display1_$eq(this.copyLeft(this.display1(), (cutIndex - 1 >>> 5 & 0x1F) + 1));
                        this.display2_$eq(this.copyLeft(this.display2(), (cutIndex - 1 >>> 10 & 0x1F) + 1));
                        this.display3_$eq(this.copyLeft(this.display3(), cutIndex >>> 15));
                        break block3;
                    }
                    if (cutIndex > 0x2000000) break block7;
                    this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                    this.display1_$eq(this.copyLeft(this.display1(), (cutIndex - 1 >>> 5 & 0x1F) + 1));
                    this.display2_$eq(this.copyLeft(this.display2(), (cutIndex - 1 >>> 10 & 0x1F) + 1));
                    this.display3_$eq(this.copyLeft(this.display3(), (cutIndex - 1 >>> 15 & 0x1F) + 1));
                    this.display4_$eq(this.copyLeft(this.display4(), cutIndex >>> 20));
                    break block3;
                }
                if (cutIndex > 0x40000000) break block8;
                this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                this.display1_$eq(this.copyLeft(this.display1(), (cutIndex - 1 >>> 5 & 0x1F) + 1));
                this.display2_$eq(this.copyLeft(this.display2(), (cutIndex - 1 >>> 10 & 0x1F) + 1));
                this.display3_$eq(this.copyLeft(this.display3(), (cutIndex - 1 >>> 15 & 0x1F) + 1));
                this.display4_$eq(this.copyLeft(this.display4(), (cutIndex - 1 >>> 20 & 0x1F) + 1));
                this.display5_$eq(this.copyLeft(this.display5(), cutIndex >>> 25));
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private void cleanLeftEdge(int cutIndex) {
        block8: {
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (cutIndex >= 32) break block2;
                                    this.zeroLeft(this.display0(), cutIndex);
                                    break block3;
                                }
                                if (cutIndex >= 1024) break block4;
                                this.zeroLeft(this.display0(), cutIndex & 0x1F);
                                this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5));
                                break block3;
                            }
                            if (cutIndex >= 32768) break block5;
                            this.zeroLeft(this.display0(), cutIndex & 0x1F);
                            this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5 & 0x1F));
                            this.display2_$eq(this.copyRight(this.display2(), cutIndex >>> 10));
                            break block3;
                        }
                        if (cutIndex >= 0x100000) break block6;
                        this.zeroLeft(this.display0(), cutIndex & 0x1F);
                        this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5 & 0x1F));
                        this.display2_$eq(this.copyRight(this.display2(), cutIndex >>> 10 & 0x1F));
                        this.display3_$eq(this.copyRight(this.display3(), cutIndex >>> 15));
                        break block3;
                    }
                    if (cutIndex >= 0x2000000) break block7;
                    this.zeroLeft(this.display0(), cutIndex & 0x1F);
                    this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5 & 0x1F));
                    this.display2_$eq(this.copyRight(this.display2(), cutIndex >>> 10 & 0x1F));
                    this.display3_$eq(this.copyRight(this.display3(), cutIndex >>> 15 & 0x1F));
                    this.display4_$eq(this.copyRight(this.display4(), cutIndex >>> 20));
                    break block3;
                }
                if (cutIndex >= 0x40000000) break block8;
                this.zeroLeft(this.display0(), cutIndex & 0x1F);
                this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5 & 0x1F));
                this.display2_$eq(this.copyRight(this.display2(), cutIndex >>> 10 & 0x1F));
                this.display3_$eq(this.copyRight(this.display3(), cutIndex >>> 15 & 0x1F));
                this.display4_$eq(this.copyRight(this.display4(), cutIndex >>> 20 & 0x1F));
                this.display5_$eq(this.copyRight(this.display5(), cutIndex >>> 25));
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private void preClean(int depth) {
        int temp2;
        block12: {
            this.depth_$eq(depth);
            temp2 = depth - 1;
            switch (temp2) {
                default: {
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp2)).toString());
                }
                case 5: {
                    if (true) break;
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp2)).toString());
                }
                case 4: {
                    if (true) {
                        this.display5_$eq(null);
                        break;
                    }
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp2)).toString());
                }
                case 3: {
                    if (true) {
                        this.display4_$eq(null);
                        this.display5_$eq(null);
                        break;
                    }
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp2)).toString());
                }
                case 2: {
                    if (true) {
                        this.display3_$eq(null);
                        this.display4_$eq(null);
                        this.display5_$eq(null);
                        break;
                    }
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp2)).toString());
                }
                case 1: {
                    if (true) {
                        this.display2_$eq(null);
                        this.display3_$eq(null);
                        this.display4_$eq(null);
                        this.display5_$eq(null);
                        break;
                    }
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp2)).toString());
                }
                case 0: {
                    if (!true) break block12;
                    this.display1_$eq(null);
                    this.display2_$eq(null);
                    this.display3_$eq(null);
                    this.display4_$eq(null);
                    this.display5_$eq(null);
                }
            }
            return;
        }
        throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp2)).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Object[] copyRight(Object[] array, int left) {
        void var3_3;
        Object[] a2 = new Object[array.length];
        Platform$.MODULE$.arraycopy(array, left, a2, left, a2.length - left);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] copyLeft(Object[] array, int right) {
        void var3_3;
        Object[] a2 = new Object[array.length];
        Platform$.MODULE$.arraycopy(array, 0, a2, 0, right);
        return var3_3;
    }

    public void zeroRight(Object[] array, int index2) {
        for (int i = index2; i < array.length; ++i) {
            array[i] = null;
        }
    }

    public void zeroLeft(Object[] array, int index2) {
        for (int i = 0; i < index2; ++i) {
            array[i] = null;
        }
    }

    private void shiftTopLevel(int oldLeft, int newLeft) {
        int temp1;
        block13: {
            temp1 = this.depth() - 1;
            switch (temp1) {
                default: {
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp1)).toString());
                }
                case 5: {
                    if (true) {
                        this.display5_$eq(this.copyRange(this.display5(), oldLeft, newLeft));
                        break;
                    }
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp1)).toString());
                }
                case 4: {
                    if (true) {
                        this.display4_$eq(this.copyRange(this.display4(), oldLeft, newLeft));
                        break;
                    }
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp1)).toString());
                }
                case 3: {
                    if (true) {
                        this.display3_$eq(this.copyRange(this.display3(), oldLeft, newLeft));
                        break;
                    }
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp1)).toString());
                }
                case 2: {
                    if (true) {
                        this.display2_$eq(this.copyRange(this.display2(), oldLeft, newLeft));
                        break;
                    }
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp1)).toString());
                }
                case 1: {
                    if (true) {
                        this.display1_$eq(this.copyRange(this.display1(), oldLeft, newLeft));
                        break;
                    }
                    throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp1)).toString());
                }
                case 0: {
                    if (!true) break block13;
                    this.display0_$eq(this.copyRange(this.display0(), oldLeft, newLeft));
                }
            }
            return;
        }
        throw new MatchError(((Object)BoxesRunTime.boxToInteger(temp1)).toString());
    }

    public <B> Vector<B> appendBack(B value2) {
        Vector<A> vector;
        if (this.endIndex != this.startIndex) {
            int blockIndex = this.endIndex & ~31;
            int lo = this.endIndex & 0x1F;
            if (this.endIndex != blockIndex) {
                Vector<A> s = new Vector<A>(this.startIndex, this.endIndex + 1, blockIndex);
                s.initFrom(this);
                s.dirty_$eq(this.dirty());
                super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
                s.display0()[lo] = value2;
                vector = s;
            } else {
                int shift = this.startIndex & ~((1 << 5 * (this.depth() - 1)) - 1);
                int shiftBlocks = this.startIndex >>> 5 * (this.depth() - 1);
                if (shift != 0) {
                    this.debug();
                    if (this.depth() > 1) {
                        int newBlockIndex = blockIndex - shift;
                        int newFocus = this.focus - shift;
                        Vector<A> s = new Vector<A>(this.startIndex - shift, this.endIndex + 1 - shift, newBlockIndex);
                        s.initFrom(this);
                        s.dirty_$eq(this.dirty());
                        super.shiftTopLevel(shiftBlocks, 0);
                        s.debug();
                        super.gotoFreshPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                        s.display0()[lo] = value2;
                        s.debug();
                        vector = s;
                    } else {
                        int newBlockIndex = blockIndex - 32;
                        int newFocus = this.focus;
                        Vector<A> s = new Vector<A>(this.startIndex - shift, this.endIndex + 1 - shift, newBlockIndex);
                        s.initFrom(this);
                        s.dirty_$eq(this.dirty());
                        super.shiftTopLevel(shiftBlocks, 0);
                        super.gotoPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                        s.display0()[32 - shift] = value2;
                        s.debug();
                        vector = s;
                    }
                } else {
                    int newBlockIndex = blockIndex;
                    int newFocus = this.focus;
                    Vector<A> s = new Vector<A>(this.startIndex, this.endIndex + 1, newBlockIndex);
                    s.initFrom(this);
                    s.dirty_$eq(this.dirty());
                    super.gotoFreshPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                    s.display0()[lo] = value2;
                    if (s.depth() == this.depth() + 1) {
                        s.debug();
                    }
                    vector = s;
                }
            }
        } else {
            Object[] elems = new Object[32];
            elems[0] = value2;
            Vector<A> s = new Vector<A>(0, 1, 0);
            s.depth_$eq(1);
            s.display0_$eq(elems);
            vector = s;
        }
        return vector;
    }

    public <B> Vector<B> appendFront(B value2) {
        Vector<A> vector;
        if (this.endIndex != this.startIndex) {
            int blockIndex = this.startIndex - 1 & ~31;
            int lo = this.startIndex - 1 & 0x1F;
            if (this.startIndex != blockIndex + 32) {
                Vector<A> s = new Vector<A>(this.startIndex - 1, this.endIndex, blockIndex);
                s.initFrom(this);
                s.dirty_$eq(this.dirty());
                super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
                s.display0()[lo] = value2;
                vector = s;
            } else {
                int freeSpace = (1 << 5 * this.depth()) - this.endIndex;
                int shift = freeSpace & ~((1 << 5 * (this.depth() - 1)) - 1);
                int shiftBlocks = freeSpace >>> 5 * (this.depth() - 1);
                if (shift != 0) {
                    this.debug();
                    if (this.depth() > 1) {
                        int newBlockIndex = blockIndex + shift;
                        int newFocus = this.focus + shift;
                        Vector<A> s = new Vector<A>(this.startIndex - 1 + shift, this.endIndex + shift, newBlockIndex);
                        s.initFrom(this);
                        s.dirty_$eq(this.dirty());
                        super.shiftTopLevel(0, shiftBlocks);
                        s.debug();
                        super.gotoFreshPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                        s.display0()[lo] = value2;
                        vector = s;
                    } else {
                        int newBlockIndex = blockIndex + 32;
                        int newFocus = this.focus;
                        Vector<A> s = new Vector<A>(this.startIndex - 1 + shift, this.endIndex + shift, newBlockIndex);
                        s.initFrom(this);
                        s.dirty_$eq(this.dirty());
                        super.shiftTopLevel(0, shiftBlocks);
                        super.gotoPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                        s.display0()[shift - 1] = value2;
                        s.debug();
                        vector = s;
                    }
                } else if (blockIndex < 0) {
                    int move = (1 << 5 * (this.depth() + 1)) - (1 << 5 * this.depth());
                    int newBlockIndex = blockIndex + move;
                    int newFocus = this.focus + move;
                    Vector<A> s = new Vector<A>(this.startIndex - 1 + move, this.endIndex + move, newBlockIndex);
                    s.initFrom(this);
                    s.dirty_$eq(this.dirty());
                    s.debug();
                    super.gotoFreshPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                    s.display0()[lo] = value2;
                    s.debug();
                    vector = s;
                } else {
                    int newBlockIndex = blockIndex;
                    int newFocus = this.focus;
                    Vector<A> s = new Vector<A>(this.startIndex - 1, this.endIndex, newBlockIndex);
                    s.initFrom(this);
                    s.dirty_$eq(this.dirty());
                    super.gotoFreshPosWritable(newFocus, newBlockIndex, newFocus ^ newBlockIndex);
                    s.display0()[lo] = value2;
                    vector = s;
                }
            }
        } else {
            Object[] elems = new Object[32];
            elems[31] = value2;
            Vector<A> s = new Vector<A>(31, 32, 0);
            s.depth_$eq(1);
            s.display0_$eq(elems);
            vector = s;
        }
        return vector;
    }

    private void gotoFreshPosWritable(int oldIndex, int newIndex, int xor) {
        if (this.dirty()) {
            this.gotoFreshPosWritable1(oldIndex, newIndex, xor);
        } else {
            this.gotoFreshPosWritable0(oldIndex, newIndex, xor);
            this.dirty_$eq(true);
        }
    }

    private void gotoPosWritable(int oldIndex, int newIndex, int xor) {
        if (this.dirty()) {
            this.gotoPosWritable1(oldIndex, newIndex, xor);
        } else {
            this.gotoPosWritable0(newIndex, xor);
            this.dirty_$eq(true);
        }
    }

    public <B> Vector<B> updateAt(int index2, B elem2) {
        int idx = this.checkRangeConvert(index2);
        Vector<A> s = new Vector<A>(this.startIndex, this.endIndex, idx);
        s.initFrom(this);
        s.dirty_$eq(this.dirty());
        super.gotoPosWritable(this.focus, idx, this.focus ^ idx);
        s.display0()[idx & 0x1F] = elem2;
        return s;
    }

    @Override
    public Vector<A> dropRight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger(n)).toString());
        }
        return this.endIndex - n > this.startIndex ? this.dropBack0(this.endIndex - n) : Vector$.MODULE$.empty();
    }

    @Override
    public Vector<A> takeRight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger(n)).toString());
        }
        return this.endIndex - n > this.startIndex ? this.dropFront0(this.endIndex - n) : this;
    }

    @Override
    public Vector<A> drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger(n)).toString());
        }
        return this.startIndex + n < this.endIndex ? this.dropFront0(this.startIndex + n) : Vector$.MODULE$.empty();
    }

    @Override
    public Vector<A> take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger(n)).toString());
        }
        return this.startIndex + n < this.endIndex ? this.dropBack0(this.startIndex + n) : this;
    }

    @Override
    public <B, That> That $colon$plus(B elem2, CanBuildFrom<Vector<A>, B, That> bf) {
        return (That)this.appendBack(elem2);
    }

    @Override
    public <B, That> That $plus$colon(B elem2, CanBuildFrom<Vector<A>, B, That> bf) {
        return (That)this.appendFront(elem2);
    }

    @Override
    public <B, That> That updated(int index2, B elem2, CanBuildFrom<Vector<A>, B, That> bf) {
        return (That)this.updateAt(index2, elem2);
    }

    private int checkRangeConvert(int index2) {
        int idx = index2 + this.startIndex;
        if (0 <= index2 && idx < this.endIndex) {
            return idx;
        }
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(index2)).toString());
    }

    @Override
    public A apply(int index2) {
        int idx = this.checkRangeConvert(index2);
        return (A)this.getElem(idx, idx ^ this.focus);
    }

    public <B, That> That map0(Function1<A, B> f$1, CanBuildFrom<Vector<A>, B, That> bf) {
        Builder<B, That> b$1 = bf.apply((Vector<A>)this.repr());
        this.foreach0(new $anonfun$map0$1(this, f$1, b$1));
        return b$1.result();
    }

    public <U> void foreach0(Function1<A, U> f) {
        ((VectorIterator)this.iterator()).foreach0(f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public VectorIterator<A> iterator() {
        void var1_1;
        VectorIterator s = new VectorIterator(this.startIndex, this.endIndex);
        s.initFrom(this);
        if (this.dirty()) {
            s.stabilize(this.focus);
        }
        if (s.depth() > 1) {
            s.gotoPos(this.startIndex, this.startIndex ^ this.focus);
        }
        return var1_1;
    }

    @Override
    public int lengthCompare(int len) {
        return this.length() - len;
    }

    @Override
    public int length() {
        return this.endIndex - this.startIndex;
    }

    public void dirty_$eq(boolean bl) {
        this.dirty = bl;
    }

    public boolean dirty() {
        return this.dirty;
    }

    @Override
    public GenericCompanion<Vector> companion() {
        return Vector$.MODULE$;
    }

    @Override
    public TraversableLike.WithFilter withFilter(Function1 p) {
        return TraversableLike$class.withFilter(this, p);
    }

    @Override
    public String stringPrefix() {
        return TraversableLike$class.stringPrefix(this);
    }

    @Override
    public StringBuilder addString(StringBuilder b) {
        return TraversableLike$class.addString(this, b);
    }

    @Override
    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableLike$class.addString(this, b, sep);
    }

    @Override
    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableLike$class.addString(this, b, start, sep, end);
    }

    @Override
    public String mkString() {
        return TraversableLike$class.mkString(this);
    }

    @Override
    public String mkString(String sep) {
        return TraversableLike$class.mkString(this, sep);
    }

    @Override
    public String mkString(String start, String sep, String end) {
        return TraversableLike$class.mkString(this, start, sep, end);
    }

    @Override
    public Set toSet() {
        return TraversableLike$class.toSet(this);
    }

    @Override
    public IndexedSeq toIndexedSeq() {
        return TraversableLike$class.toIndexedSeq(this);
    }

    @Override
    public List toList() {
        return TraversableLike$class.toList(this);
    }

    public Object toArray(ClassManifest evidence$1) {
        return TraversableLike$class.toArray(this, evidence$1);
    }

    public void copyToArray(Object xs, int start) {
        TraversableLike$class.copyToArray(this, xs, start);
    }

    @Override
    public void copyToBuffer(Buffer dest) {
        TraversableLike$class.copyToBuffer(this, dest);
    }

    @Override
    public Tuple2 splitAt(int n) {
        return TraversableLike$class.splitAt(this, n);
    }

    @Override
    public Tuple2 span(Function1 p) {
        return TraversableLike$class.span(this, p);
    }

    @Override
    public Object dropWhile(Function1 p) {
        return TraversableLike$class.dropWhile(this, p);
    }

    @Override
    public Object init() {
        return TraversableLike$class.init(this);
    }

    @Override
    public Option lastOption() {
        return TraversableLike$class.lastOption(this);
    }

    @Override
    public Object last() {
        return TraversableLike$class.last(this);
    }

    @Override
    public Object tail() {
        return TraversableLike$class.tail(this);
    }

    @Override
    public Option headOption() {
        return TraversableLike$class.headOption(this);
    }

    @Override
    public Object max(Ordering cmp) {
        return TraversableLike$class.max(this, cmp);
    }

    @Override
    public Object min(Ordering cmp) {
        return TraversableLike$class.min(this, cmp);
    }

    @Override
    public Object product(Numeric num) {
        return TraversableLike$class.product(this, num);
    }

    @Override
    public Object sum(Numeric num) {
        return TraversableLike$class.sum(this, num);
    }

    @Override
    public Option reduceRightOption(Function2 op) {
        return TraversableLike$class.reduceRightOption(this, op);
    }

    @Override
    public Option reduceLeftOption(Function2 op) {
        return TraversableLike$class.reduceLeftOption(this, op);
    }

    @Override
    public Object reduceLeft(Function2 op) {
        return TraversableLike$class.reduceLeft(this, op);
    }

    @Override
    public Object $colon$bslash(Object z, Function2 op) {
        return TraversableLike$class.$colon$bslash(this, z, op);
    }

    @Override
    public Object $div$colon(Object z, Function2 op) {
        return TraversableLike$class.$div$colon(this, z, op);
    }

    @Override
    public Object foldLeft(Object z, Function2 op) {
        return TraversableLike$class.foldLeft(this, z, op);
    }

    @Override
    public int count(Function1 p) {
        return TraversableLike$class.count(this, p);
    }

    @Override
    public Map groupBy(Function1 f) {
        return TraversableLike$class.groupBy(this, f);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return TraversableLike$class.partition(this, p);
    }

    @Override
    public Object remove(Function1 p) {
        return TraversableLike$class.remove(this, p);
    }

    @Override
    public Object partialMap(PartialFunction pf, CanBuildFrom bf) {
        return TraversableLike$class.partialMap(this, pf, bf);
    }

    @Override
    public Object filterNot(Function1 p) {
        return TraversableLike$class.filterNot(this, p);
    }

    @Override
    public Object filter(Function1 p) {
        return TraversableLike$class.filter(this, p);
    }

    @Override
    public Object flatMap(Function1 f, CanBuildFrom bf) {
        return TraversableLike$class.flatMap(this, f, bf);
    }

    @Override
    public Object map(Function1 f, CanBuildFrom bf) {
        return TraversableLike$class.map(this, f, bf);
    }

    @Override
    public Object $plus$plus(Iterator that, CanBuildFrom bf) {
        return TraversableLike$class.$plus$plus((TraversableLike)this, that, bf);
    }

    @Override
    public Object $plus$plus(Traversable that, CanBuildFrom bf) {
        return TraversableLike$class.$plus$plus((TraversableLike)this, that, bf);
    }

    @Override
    public boolean hasDefiniteSize() {
        return TraversableLike$class.hasDefiniteSize(this);
    }

    @Override
    public boolean nonEmpty() {
        return TraversableLike$class.nonEmpty(this);
    }

    @Override
    public Object repr() {
        return TraversableLike$class.repr(this);
    }

    @Override
    public Traversable transpose(Function1 asTraversable) {
        return GenericTraversableTemplate$class.transpose(this, asTraversable);
    }

    @Override
    public Traversable flatten(Function1 asTraversable) {
        return GenericTraversableTemplate$class.flatten(this, asTraversable);
    }

    @Override
    public Tuple2 unzip(Function1 asPair) {
        return GenericTraversableTemplate$class.unzip(this, asPair);
    }

    @Override
    public Builder genericBuilder() {
        return GenericTraversableTemplate$class.genericBuilder(this);
    }

    @Override
    public Builder newBuilder() {
        return GenericTraversableTemplate$class.newBuilder(this);
    }

    @Override
    public Option firstOption() {
        return IterableLike$class.firstOption(this);
    }

    @Override
    public Object first() {
        return IterableLike$class.first(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return IterableLike$class.canEqual(this, that);
    }

    @Override
    public Stream toStream() {
        return IterableLike$class.toStream(this);
    }

    @Override
    public boolean sameElements(Iterable that) {
        return IterableLike$class.sameElements(this, that);
    }

    @Override
    public Object zipWithIndex(CanBuildFrom bf) {
        return IterableLike$class.zipWithIndex(this, bf);
    }

    @Override
    public Object zipAll(Iterable that, Object thisElem, Object thatElem, CanBuildFrom bf) {
        return IterableLike$class.zipAll(this, that, thisElem, thatElem, bf);
    }

    @Override
    public Object zip(Iterable that, CanBuildFrom bf) {
        return IterableLike$class.zip(this, that, bf);
    }

    public void copyToArray(Object xs, int start, int len) {
        IterableLike$class.copyToArray(this, xs, start, len);
    }

    @Override
    public Object takeWhile(Function1 p) {
        return IterableLike$class.takeWhile(this, p);
    }

    @Override
    public Object slice(int from2, int until2) {
        return IterableLike$class.slice(this, from2, until2);
    }

    @Override
    public Object head() {
        return IterableLike$class.head(this);
    }

    @Override
    public Iterable toIterable() {
        return IterableLike$class.toIterable(this);
    }

    @Override
    public Object reduceRight(Function2 op) {
        return IterableLike$class.reduceRight(this, op);
    }

    @Override
    public Object foldRight(Object z, Function2 op) {
        return IterableLike$class.foldRight(this, z, op);
    }

    @Override
    public boolean isEmpty() {
        return IterableLike$class.isEmpty(this);
    }

    @Override
    public Option find(Function1 p) {
        return IterableLike$class.find(this, p);
    }

    @Override
    public boolean exists(Function1 p) {
        return IterableLike$class.exists(this, p);
    }

    @Override
    public boolean forall(Function1 p) {
        return IterableLike$class.forall(this, p);
    }

    @Override
    public void foreach(Function1 f) {
        IterableLike$class.foreach(this, f);
    }

    @Override
    public Iterator elements() {
        return IterableLike$class.elements(this);
    }

    @Override
    public Function1 compose(Function1 g) {
        return Function1$class.compose(this, g);
    }

    @Override
    public PartialFunction andThen(Function1 k) {
        return PartialFunction$class.andThen(this, k);
    }

    @Override
    public PartialFunction orElse(PartialFunction that) {
        return PartialFunction$class.orElse(this, that);
    }

    @Override
    public Object projection() {
        return SeqLike$class.projection(this);
    }

    @Override
    public boolean containsSlice(Seq that) {
        return SeqLike$class.containsSlice(this, that);
    }

    @Override
    public boolean equalsWith(Seq that, Function2 f) {
        return SeqLike$class.equalsWith(this, that, f);
    }

    @Override
    public int findLastIndexOf(Function1 p) {
        return SeqLike$class.findLastIndexOf(this, p);
    }

    @Override
    public String toString() {
        return SeqLike$class.toString(this);
    }

    @Override
    public boolean equals(Object that) {
        return SeqLike$class.equals(this, that);
    }

    @Override
    public int hashCode() {
        return SeqLike$class.hashCode(this);
    }

    @Override
    public SeqView view(int from2, int until2) {
        return SeqLike$class.view(this, from2, until2);
    }

    @Override
    public Object view() {
        return SeqLike$class.view(this);
    }

    @Override
    public Range indices() {
        return SeqLike$class.indices(this);
    }

    @Override
    public Seq toSeq() {
        return SeqLike$class.toSeq(this);
    }

    @Override
    public Object sortBy(Function1 f, Ordering ord) {
        return SeqLike$class.sortBy(this, f, ord);
    }

    @Override
    public Object sortWith(Ordering ord) {
        return SeqLike$class.sortWith((SeqLike)this, ord);
    }

    @Override
    public Object sortWith(Function2 lt) {
        return SeqLike$class.sortWith((SeqLike)this, lt);
    }

    @Override
    public Object padTo(int len, Object elem2, CanBuildFrom bf) {
        return SeqLike$class.padTo(this, len, elem2, bf);
    }

    @Override
    public Object patch(int from2, Seq patch, int replaced, CanBuildFrom bf) {
        return SeqLike$class.patch(this, from2, patch, replaced, bf);
    }

    @Override
    public Object removeDuplicates() {
        return SeqLike$class.removeDuplicates(this);
    }

    @Override
    public Object intersect(Seq that) {
        return SeqLike$class.intersect(this, that);
    }

    @Override
    public Object diff(Seq that) {
        return SeqLike$class.diff(this, that);
    }

    @Override
    public Object union(Seq that, CanBuildFrom bf) {
        return SeqLike$class.union(this, that, bf);
    }

    @Override
    public boolean contains(Object elem2) {
        return SeqLike$class.contains(this, elem2);
    }

    @Override
    public int lastIndexOfSeq(Seq that, int fromIndex) {
        return SeqLike$class.lastIndexOfSeq(this, that, fromIndex);
    }

    @Override
    public int lastIndexOfSeq(Seq that) {
        return SeqLike$class.lastIndexOfSeq(this, that);
    }

    @Override
    public int indexOfSeq(Seq that, int fromIndex) {
        return SeqLike$class.indexOfSeq(this, that, fromIndex);
    }

    @Override
    public int indexOfSeq(Seq that) {
        return SeqLike$class.indexOfSeq(this, that);
    }

    @Override
    public boolean endsWith(Seq that) {
        return SeqLike$class.endsWith(this, that);
    }

    @Override
    public boolean startsWith(Seq that) {
        return SeqLike$class.startsWith(this, that);
    }

    @Override
    public boolean startsWith(Seq that, int offset) {
        return SeqLike$class.startsWith(this, that, offset);
    }

    @Override
    public Iterator reversedElements() {
        return SeqLike$class.reversedElements(this);
    }

    @Override
    public Iterator reverseIterator() {
        return SeqLike$class.reverseIterator(this);
    }

    @Override
    public Object reverseMap(Function1 f, CanBuildFrom bf) {
        return SeqLike$class.reverseMap(this, f, bf);
    }

    @Override
    public Object reverse() {
        return SeqLike$class.reverse(this);
    }

    @Override
    public int lastIndexWhere(Function1 p, int end) {
        return SeqLike$class.lastIndexWhere(this, p, end);
    }

    @Override
    public int lastIndexWhere(Function1 p) {
        return SeqLike$class.lastIndexWhere(this, p);
    }

    @Override
    public int lastIndexOf(Object elem2, int end) {
        return SeqLike$class.lastIndexOf(this, elem2, end);
    }

    @Override
    public int lastIndexOf(Object elem2) {
        return SeqLike$class.lastIndexOf(this, elem2);
    }

    @Override
    public int indexOf(Object elem2, int from2) {
        return SeqLike$class.indexOf(this, elem2, from2);
    }

    @Override
    public int indexOf(Object elem2) {
        return SeqLike$class.indexOf(this, elem2);
    }

    @Override
    public int findIndexOf(Function1 p) {
        return SeqLike$class.findIndexOf(this, p);
    }

    @Override
    public int indexWhere(Function1 p, int from2) {
        return SeqLike$class.indexWhere(this, p, from2);
    }

    @Override
    public int indexWhere(Function1 p) {
        return SeqLike$class.indexWhere(this, p);
    }

    @Override
    public int prefixLength(Function1 p) {
        return SeqLike$class.prefixLength(this, p);
    }

    @Override
    public int segmentLength(Function1 p, int from2) {
        return SeqLike$class.segmentLength(this, p, from2);
    }

    @Override
    public boolean isDefinedAt(int x) {
        return SeqLike$class.isDefinedAt(this, x);
    }

    @Override
    public int size() {
        return SeqLike$class.size(this);
    }

    @Override
    public Seq toCollection(Object repr) {
        return SeqLike$class.toCollection(this, repr);
    }

    @Override
    public Seq thisCollection() {
        return SeqLike$class.thisCollection(this);
    }

    @Override
    public void debug() {
        VectorPointer$class.debug(this);
    }

    @Override
    public final void gotoFreshPosWritable1(int oldIndex, int newIndex, int xor) {
        VectorPointer$class.gotoFreshPosWritable1(this, oldIndex, newIndex, xor);
    }

    @Override
    public final void gotoFreshPosWritable0(int oldIndex, int newIndex, int xor) {
        VectorPointer$class.gotoFreshPosWritable0(this, oldIndex, newIndex, xor);
    }

    @Override
    public final Object[] copyRange(Object[] array, int oldLeft, int newLeft) {
        return VectorPointer$class.copyRange(this, array, oldLeft, newLeft);
    }

    @Override
    public final void gotoPosWritable1(int oldIndex, int newIndex, int xor) {
        VectorPointer$class.gotoPosWritable1(this, oldIndex, newIndex, xor);
    }

    @Override
    public final void gotoPosWritable0(int newIndex, int xor) {
        VectorPointer$class.gotoPosWritable0(this, newIndex, xor);
    }

    @Override
    public final void stabilize(int index2) {
        VectorPointer$class.stabilize(this, index2);
    }

    @Override
    public final Object[] nullSlotAndCopy(Object[] array, int index2) {
        return VectorPointer$class.nullSlotAndCopy(this, array, index2);
    }

    @Override
    public final Object[] copyOf(Object[] a) {
        return VectorPointer$class.copyOf(this, a);
    }

    @Override
    public final void gotoNextBlockStartWritable(int index2, int xor) {
        VectorPointer$class.gotoNextBlockStartWritable(this, index2, xor);
    }

    @Override
    public final void gotoNextBlockStart(int index2, int xor) {
        VectorPointer$class.gotoNextBlockStart(this, index2, xor);
    }

    @Override
    public final void gotoPos(int index2, int xor) {
        VectorPointer$class.gotoPos(this, index2, xor);
    }

    @Override
    public final Object getElem(int index2, int xor) {
        return VectorPointer$class.getElem(this, index2, xor);
    }

    @Override
    public final void initFrom(VectorPointer that, int depth) {
        VectorPointer$class.initFrom(this, that, depth);
    }

    @Override
    public final void initFrom(VectorPointer that) {
        VectorPointer$class.initFrom(this, that);
    }

    @Override
    public void display5_$eq(Object[] objectArray) {
        this.display5 = objectArray;
    }

    @Override
    public Object[] display5() {
        return this.display5;
    }

    @Override
    public void display4_$eq(Object[] objectArray) {
        this.display4 = objectArray;
    }

    @Override
    public Object[] display4() {
        return this.display4;
    }

    @Override
    public void display3_$eq(Object[] objectArray) {
        this.display3 = objectArray;
    }

    @Override
    public Object[] display3() {
        return this.display3;
    }

    @Override
    public void display2_$eq(Object[] objectArray) {
        this.display2 = objectArray;
    }

    @Override
    public Object[] display2() {
        return this.display2;
    }

    @Override
    public void display1_$eq(Object[] objectArray) {
        this.display1 = objectArray;
    }

    @Override
    public Object[] display1() {
        return this.display1;
    }

    @Override
    public void display0_$eq(Object[] objectArray) {
        this.display0 = objectArray;
    }

    @Override
    public Object[] display0() {
        return this.display0;
    }

    @Override
    public void depth_$eq(int n) {
        this.depth = n;
    }

    @Override
    public int depth() {
        return this.depth;
    }
}

