/* NSC -- new Scala compiler
 * Copyright 2007-2009 LAMP/EPFL
 * @author Lex Spoon
 * Updated by Anders Bach Nielsen
 */
// $Id: PluginComponent.scala 18773 2009-09-24 13:09:40Z dubochet $

package scala.tools.nsc
package plugins

/** A component that is part of a Plugin.
 *
 * @author Lex Spoon 
 * @version 1.1, 2009/1/2
 * Updated 2009/1/2 by Anders Bach Nielsen: Added features to implement SIP 00002
 */
abstract class PluginComponent extends SubComponent {

  /** Internal flag to tell external from internal phases */
  final override val internal = false

  /** Phases supplied by plugins should not have give the runsRightAfter constraint,
   * but can override it */
  val runsRightAfter: Option[String] = None

}
