/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2005-2009, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: Scheduler.scala 19065 2009-10-12 14:35:21Z phaller $

package scala.actors

import java.util.concurrent._
import scheduler.{DelegatingScheduler, ResizableThreadPoolScheduler}

/**
 * The <code>Scheduler</code> object is used by <code>Actor</code> to
 * execute tasks of an execution of an actor.
 *
 * @author Philipp Haller
 */
object Scheduler extends DelegatingScheduler {

  Debug.info("initializing "+this+"...")

  def makeNewScheduler: IScheduler = {
    val s = new ResizableThreadPoolScheduler(false)
    Debug.info(this+": starting new "+s+" ["+s.getClass+"]")
    s.start()
    s
  }

  @deprecated("snapshot will be removed")
  def snapshot() {
    if (sched.isInstanceOf[ResizableThreadPoolScheduler]) {
      sched.asInstanceOf[ResizableThreadPoolScheduler].snapshot()
    } else
      error("scheduler does not implement snapshot")
  }

  @deprecated("restart will be removed")
  def restart() {
    if (sched.isInstanceOf[ResizableThreadPoolScheduler]) {
      sched.asInstanceOf[ResizableThreadPoolScheduler].restart()
    } else
      error("scheduler does not implement restart")
  }

}
