/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2009, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: CharacterString.scala 18773 2009-09-24 13:09:40Z dubochet $


package scala.dbc
package datatype;


/** A type category for all SQL types that store strings of characters. */
abstract class CharacterString extends String {
  
  type NativeType = java.lang.String;
  val nativeTypeId = DataType.STRING;
  
  /** The name of the character set in which the string is encoded. */
  def encoding: Option[java.lang.String] = None;
  
}
