/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2002-2009, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: BoxedObjectArray.scala 19398 2009-11-04 18:25:19Z rytz $


package scala.runtime
import scala.reflect.ClassManifest

@serializable
final class BoxedObjectArray[A <: AnyRef](val value: Array[AnyRef], val elemManifest: ClassManifest[A]) extends BoxedArray[A] {

// @deprecated("creating array w/o manifest")
    def this(value: Array[AnyRef]) = this(value, null) // !!! todo: remove

  def length: Int = value.length

  def apply(index: Int): A = value(index).asInstanceOf[A]

  def update(index: Int, elem: A) { 
    value(index) = elem 
  }

  def unbox(elemClass: Class[_]): AnyRef = value

/*
  override def equals(other: Any): Boolean =
    (value eq other.asInstanceOf[AnyRef]) ||
    other.isInstanceOf[BoxedObjectArray[_]] && (value eq other.asInstanceOf[BoxedObjectArray[_]].value)

  override def hashCode(): Int = (value.asInstanceOf[AnyRef]).hashCode()
*/

}

