/* NSC -- new Scala compiler
 * Copyright 2005-2009 LAMP/EPFL
 * @author  Martin Odersky
 */
// $Id: InterpreterResults.scala 18773 2009-09-24 13:09:40Z dubochet $

package scala.tools.nsc

object InterpreterResults {

  /** A result from interpreting one line of input. */
  abstract sealed class Result

  /** The line was interpreted successfully. */
  case object Success extends Result

  /** The line was erroneous in some way. */
  case object Error extends Result
  
  /** The input was incomplete.  The caller should request more
   *  input.
   */
  case object Incomplete extends Result

}
