/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Function1;
import scala.Function1$class;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$class;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.IndexedSeq$class;
import scala.collection.IndexedSeqLike$class;
import scala.collection.Iterable;
import scala.collection.IterableLike$class;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$class;
import scala.collection.SeqLike;
import scala.collection.SeqLike$class;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableLike$class;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate$class;
import scala.collection.generic.Growable;
import scala.collection.generic.Growable$class;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Builder$class;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.IndexedSeqView;
import scala.collection.mutable.Iterable$class;
import scala.collection.mutable.StringBuilder$;
import scala.collection.mutable.Traversable$class;
import scala.compat.Platform$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringBuilder
implements Builder<Character, String>,
IndexedSeq<Character>,
ScalaObject {
    public static final long serialVersionUID = -8525408645367278351L;
    private int count;
    private char[] array;
    private final String initValue;

    public StringBuilder(int initCapacity, String initValue) {
        this.initValue = initValue;
        Growable$class.$init$(this);
        Builder$class.$init$(this);
        TraversableLike$class.$init$(this);
        GenericTraversableTemplate$class.$init$(this);
        scala.collection.Traversable$class.$init$(this);
        Traversable$class.$init$(this);
        IterableLike$class.$init$(this);
        scala.collection.Iterable$class.$init$(this);
        Iterable$class.$init$(this);
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        SeqLike$class.$init$(this);
        Seq$class.$init$(this);
        scala.collection.mutable.Seq$class.$init$(this);
        IndexedSeqLike$class.$init$(this);
        IndexedSeq$class.$init$(this);
        scala.collection.mutable.IndexedSeqLike$class.$init$(this);
        scala.collection.mutable.IndexedSeq$class.$init$(this);
        Predef$.MODULE$.require(initCapacity >= 0);
        this.array = new char[initCapacity + initValue.length()];
        this.count = 0;
        this.append(initValue);
    }

    @Override
    public String result() {
        return this.toString();
    }

    @Override
    public String toString() {
        return new String(this.array(), 0, this.count());
    }

    @Override
    public StringBuilder reverse() {
        boolean hasSurrogate = false;
        int n = this.count() - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.array()[j];
            char temp2 = this.array()[n - j];
            if (!hasSurrogate) {
                hasSurrogate = temp >= '\ud800' && temp <= '\udfff' || temp2 >= '\ud800' && temp2 <= '\udfff';
            }
            this.array()[j] = temp2;
            this.array()[n - j] = temp;
        }
        if (hasSurrogate) {
            for (int i = 0; i < this.count() - 1; ++i) {
                char c1;
                char c2 = this.array()[i];
                if (!Character.isLowSurrogate(c2) || !Character.isHighSurrogate(c1 = this.array()[i + 1])) continue;
                this.array()[i] = c1;
                this.array()[++i] = c2;
            }
        }
        return this;
    }

    @Override
    public int lastIndexOf(String str, int fromIndex) {
        return this.lastIndexOfSeq(Predef$.MODULE$.augmentString(str).toIndexedSeq(), fromIndex);
    }

    @Override
    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count());
    }

    @Override
    public int indexOf(String str, int fromIndex) {
        return this.indexOfSeq(Predef$.MODULE$.augmentString(str).toIndexedSeq(), fromIndex);
    }

    @Override
    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public StringBuilder insert(int at, double x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, float x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, long x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, int x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, short x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, char x) {
        if (at < 0 || at > this.count()) {
            throw new StringIndexOutOfBoundsException(at);
        }
        this.ensureCapacity(this.count() + 1);
        Platform$.MODULE$.arraycopy(this.array(), at, this.array(), at + 1, this.count() - at);
        this.array()[at] = x;
        this.count_$eq(this.count() + 1);
        return this;
    }

    public StringBuilder insert(int at, byte x) {
        return this.insert(at, String.valueOf((char)x));
    }

    public StringBuilder insert(int at, boolean x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, char[] x) {
        return this.insertAll(at, x);
    }

    public StringBuilder insertAll(int at, char[] x) {
        if (at < 0 || at > this.count()) {
            throw new StringIndexOutOfBoundsException(at);
        }
        int len = x.length;
        this.ensureCapacity(this.count() + len);
        Platform$.MODULE$.arraycopy(this.array(), at, this.array(), at + len, this.count() - at);
        Platform$.MODULE$.arraycopy(x, 0, this.array(), at, len);
        this.count_$eq(this.count() + len);
        return this;
    }

    public StringBuilder insert(int at, Seq<Character> x) {
        return this.insertAll(at, x);
    }

    public StringBuilder insertAll(int at, Seq<Character> x) {
        return this.insertAll(at, (char[])x.toArray((ClassManifest)Manifest$.MODULE$.Char()));
    }

    public StringBuilder insert(int at, String x) {
        if (at < 0 || at > this.count()) {
            throw new StringIndexOutOfBoundsException(at);
        }
        String string2 = x;
        String str = string2 == null || string2.equals(null) ? "null" : x;
        int len = str.length();
        this.ensureCapacity(this.count() + len);
        Platform$.MODULE$.arraycopy(this.array(), at, this.array(), at + len, this.count() - at);
        str.getChars(0, len, this.array(), at);
        this.count_$eq(this.count() + len);
        return this;
    }

    public StringBuilder insert(int at, Object x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int index2, char[] str, int offset, int len) {
        return this.insertAll(index2, str, offset, len);
    }

    public StringBuilder insertAll(int index2, char[] str, int offset, int len) {
        if (index2 < 0 || index2 > this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        if (offset < 0 || len < 0 || offset > str.length - len) {
            throw new StringIndexOutOfBoundsException(new StringBuilder().append((Object)"offset ").append(BoxesRunTime.boxToInteger(offset)).append((Object)", len ").append(BoxesRunTime.boxToInteger(len)).append((Object)", str.length ").append(BoxesRunTime.boxToInteger(str.length)).toString());
        }
        this.ensureCapacity(this.count() + len);
        Platform$.MODULE$.arraycopy(this.array(), index2, this.array(), index2 + len, this.count() - index2);
        Platform$.MODULE$.arraycopy(str, offset, this.array(), index2, len);
        this.count_$eq(this.count() + len);
        return this;
    }

    public void replace(int start, int end, String str) {
        if (start < 0 || start > this.count() || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int end0 = end > this.count() ? this.count() : end;
        int len = str.length();
        int newCount = this.count() + len - (end0 - start);
        this.ensureCapacity(newCount);
        Platform$.MODULE$.arraycopy(this.array(), end, this.array(), start + len, this.count() - end);
        str.getChars(0, len, this.array(), start);
        this.count_$eq(newCount);
    }

    public StringBuilder delete(int start, int end) {
        if (start < 0 || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int end0 = end > this.count() ? this.count() : end;
        int len = end0 - start;
        if (len > 0) {
            Platform$.MODULE$.arraycopy(this.array(), start + len, this.array(), start, this.count() - end0);
            this.count_$eq(this.count() - len);
        }
        return this;
    }

    public StringBuilder append(double x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(float x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(long x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(int x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(short x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(char x) {
        this.ensureCapacity(this.count() + 1);
        this.array()[this.count()] = x;
        this.count_$eq(this.count() + 1);
        return this;
    }

    public StringBuilder append(byte x) {
        return this.append(String.valueOf((char)x));
    }

    public StringBuilder append(boolean x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(char[] x, int offset, int len) {
        return this.appendAll(x, offset, len);
    }

    public StringBuilder appendAll(char[] x, int offset, int len) {
        this.ensureCapacity(this.count() + len);
        Platform$.MODULE$.arraycopy(x, offset, this.array(), this.count(), len);
        this.count_$eq(this.count() + len);
        return this;
    }

    public StringBuilder append(char[] x) {
        return this.appendAll(x);
    }

    public StringBuilder appendAll(char[] x) {
        return this.appendAll(x, 0, x.length);
    }

    public StringBuilder append(Seq<Character> x) {
        return this.appendAll(x);
    }

    public StringBuilder appendAll(Seq<Character> x) {
        return this.appendAll((char[])x.toArray((ClassManifest)Manifest$.MODULE$.Char()), 0, x.length());
    }

    public StringBuilder append(StringBuilder sb) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = sb;
        if (stringBuilder2 == null || ((Object)stringBuilder2).equals(null)) {
            stringBuilder = this.append("null");
        } else {
            int len = sb.length();
            this.ensureCapacity(this.count() + len);
            Platform$.MODULE$.arraycopy(sb.toArray(), 0, this.array(), this.count(), len);
            this.count_$eq(this.count() + len);
            stringBuilder = this;
        }
        return stringBuilder;
    }

    public StringBuilder append(String s) {
        String string2 = s;
        String str = string2 == null || string2.equals(null) ? "null" : s;
        int len = str.length();
        this.ensureCapacity(this.count() + len);
        str.getChars(0, len, this.array(), this.count());
        this.count_$eq(this.count() + len);
        return this;
    }

    public StringBuilder append(Object x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder $plus(char x) {
        this.$plus$eq(x);
        return this;
    }

    public StringBuilder $plus$eq(char x) {
        this.append(x);
        return this;
    }

    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count()) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.array(), start, end - start);
    }

    public String substring(int start) {
        return this.substring(start, this.count());
    }

    @Override
    public void update(int i, char c) {
        this.setCharAt(i, c);
    }

    public void setCharAt(int index2, char ch) {
        if (index2 < 0 || index2 >= this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        this.array()[index2] = ch;
    }

    public StringBuilder deleteCharAt(int index2) {
        if (index2 < 0 || index2 >= this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        Platform$.MODULE$.arraycopy(this.array(), index2 + 1, this.array(), index2, this.count() - index2 - 1);
        this.count_$eq(this.count() - 1);
        return this;
    }

    @Override
    public char apply(int i) {
        return this.charAt(i);
    }

    public char charAt(int index2) {
        if (index2 < 0 || index2 >= this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        return this.array()[index2];
    }

    public void ensureCapacity(int n) {
        if (n > this.array().length) {
            int newsize;
            for (newsize = this.array().length * 2; n > newsize; newsize *= 2) {
            }
            char[] newar = new char[newsize];
            Platform$.MODULE$.arraycopy(this.array(), 0, newar, 0, this.count());
            this.array_$eq(newar);
        }
    }

    public void capacity_$eq(int n) {
        this.ensureCapacity(n);
    }

    public int capacity() {
        return this.array().length;
    }

    public void setLength(int n$1) {
        Predef$.MODULE$.require(n$1 >= 0, new $anonfun$setLength$1(this, n$1));
        while (this.count() < n$1) {
            this.append('\u0000');
        }
        this.count_$eq(n$1);
    }

    @Override
    public void clear() {
        this.setLength(0);
    }

    public void length_$eq(int n) {
        this.setLength(n);
    }

    @Override
    public int length() {
        return this.count();
    }

    public char[] toArray() {
        return this.array();
    }

    public StringBuilder(String str) {
        this(16, str);
    }

    public StringBuilder(int capacity) {
        this(capacity, "");
    }

    public StringBuilder() {
        this(16, "");
    }

    private void count_$eq(int n) {
        this.count = n;
    }

    private int count() {
        return this.count;
    }

    private void array_$eq(char[] cArray) {
        this.array = cArray;
    }

    private char[] array() {
        return this.array;
    }

    private String initValue() {
        return this.initValue;
    }

    @Override
    public Growable $plus$plus$eq(Traversable iter) {
        return Growable$class.$plus$plus$eq((Growable)this, iter);
    }

    @Override
    public Growable $plus$plus$eq(Iterator iter) {
        return Growable$class.$plus$plus$eq((Growable)this, iter);
    }

    @Override
    public Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable$class.$plus$eq(this, elem1, elem2, elems);
    }

    @Override
    public Builder mapResult(Function1 f) {
        return Builder$class.mapResult(this, f);
    }

    @Override
    public void sizeHint(int size2) {
        Builder$class.sizeHint(this, size2);
    }

    @Override
    public TraversableLike.WithFilter withFilter(Function1 p) {
        return TraversableLike$class.withFilter(this, p);
    }

    @Override
    public String stringPrefix() {
        return TraversableLike$class.stringPrefix(this);
    }

    @Override
    public StringBuilder addString(StringBuilder b) {
        return TraversableLike$class.addString(this, b);
    }

    @Override
    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableLike$class.addString(this, b, sep);
    }

    @Override
    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableLike$class.addString(this, b, start, sep, end);
    }

    @Override
    public String mkString() {
        return TraversableLike$class.mkString(this);
    }

    @Override
    public String mkString(String sep) {
        return TraversableLike$class.mkString(this, sep);
    }

    @Override
    public String mkString(String start, String sep, String end) {
        return TraversableLike$class.mkString(this, start, sep, end);
    }

    @Override
    public Set toSet() {
        return TraversableLike$class.toSet(this);
    }

    @Override
    public IndexedSeq toIndexedSeq() {
        return TraversableLike$class.toIndexedSeq(this);
    }

    @Override
    public List toList() {
        return TraversableLike$class.toList(this);
    }

    public Object toArray(ClassManifest evidence$1) {
        return TraversableLike$class.toArray(this, evidence$1);
    }

    public void copyToArray(Object xs, int start) {
        TraversableLike$class.copyToArray(this, xs, start);
    }

    @Override
    public void copyToBuffer(Buffer dest) {
        TraversableLike$class.copyToBuffer(this, dest);
    }

    @Override
    public Option lastOption() {
        return TraversableLike$class.lastOption(this);
    }

    @Override
    public Option headOption() {
        return TraversableLike$class.headOption(this);
    }

    @Override
    public Object max(Ordering cmp) {
        return TraversableLike$class.max(this, cmp);
    }

    @Override
    public Object min(Ordering cmp) {
        return TraversableLike$class.min(this, cmp);
    }

    @Override
    public Object product(Numeric num) {
        return TraversableLike$class.product(this, num);
    }

    @Override
    public Object sum(Numeric num) {
        return TraversableLike$class.sum(this, num);
    }

    @Override
    public Option reduceRightOption(Function2 op) {
        return TraversableLike$class.reduceRightOption(this, op);
    }

    @Override
    public Option reduceLeftOption(Function2 op) {
        return TraversableLike$class.reduceLeftOption(this, op);
    }

    @Override
    public Object $colon$bslash(Object z, Function2 op) {
        return TraversableLike$class.$colon$bslash(this, z, op);
    }

    @Override
    public Object $div$colon(Object z, Function2 op) {
        return TraversableLike$class.$div$colon(this, z, op);
    }

    @Override
    public int count(Function1 p) {
        return TraversableLike$class.count(this, p);
    }

    @Override
    public Map groupBy(Function1 f) {
        return TraversableLike$class.groupBy(this, f);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return TraversableLike$class.partition(this, p);
    }

    @Override
    public Object remove(Function1 p) {
        return TraversableLike$class.remove(this, p);
    }

    @Override
    public Object partialMap(PartialFunction pf, CanBuildFrom bf) {
        return TraversableLike$class.partialMap(this, pf, bf);
    }

    @Override
    public Object filterNot(Function1 p) {
        return TraversableLike$class.filterNot(this, p);
    }

    @Override
    public Object filter(Function1 p) {
        return TraversableLike$class.filter(this, p);
    }

    @Override
    public Object flatMap(Function1 f, CanBuildFrom bf) {
        return TraversableLike$class.flatMap(this, f, bf);
    }

    @Override
    public Object map(Function1 f, CanBuildFrom bf) {
        return TraversableLike$class.map(this, f, bf);
    }

    @Override
    public Object $plus$plus(Iterator that, CanBuildFrom bf) {
        return TraversableLike$class.$plus$plus((TraversableLike)this, that, bf);
    }

    @Override
    public Object $plus$plus(Traversable that, CanBuildFrom bf) {
        return TraversableLike$class.$plus$plus((TraversableLike)this, that, bf);
    }

    @Override
    public boolean hasDefiniteSize() {
        return TraversableLike$class.hasDefiniteSize(this);
    }

    @Override
    public boolean nonEmpty() {
        return TraversableLike$class.nonEmpty(this);
    }

    @Override
    public Object repr() {
        return TraversableLike$class.repr(this);
    }

    @Override
    public Traversable transpose(Function1 asTraversable) {
        return GenericTraversableTemplate$class.transpose(this, asTraversable);
    }

    @Override
    public Traversable flatten(Function1 asTraversable) {
        return GenericTraversableTemplate$class.flatten(this, asTraversable);
    }

    @Override
    public Tuple2 unzip(Function1 asPair) {
        return GenericTraversableTemplate$class.unzip(this, asPair);
    }

    @Override
    public Builder genericBuilder() {
        return GenericTraversableTemplate$class.genericBuilder(this);
    }

    @Override
    public Builder newBuilder() {
        return GenericTraversableTemplate$class.newBuilder(this);
    }

    @Override
    public Option firstOption() {
        return IterableLike$class.firstOption(this);
    }

    @Override
    public Object first() {
        return IterableLike$class.first(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return IterableLike$class.canEqual(this, that);
    }

    @Override
    public Stream toStream() {
        return IterableLike$class.toStream(this);
    }

    @Override
    public Object zipAll(Iterable that, Object thisElem, Object thatElem, CanBuildFrom bf) {
        return IterableLike$class.zipAll(this, that, thisElem, thatElem, bf);
    }

    @Override
    public Iterable toIterable() {
        return IterableLike$class.toIterable(this);
    }

    @Override
    public Iterator elements() {
        return IterableLike$class.elements(this);
    }

    @Override
    public Function1 compose(Function1 g) {
        return Function1$class.compose(this, g);
    }

    @Override
    public PartialFunction andThen(Function1 k) {
        return PartialFunction$class.andThen(this, k);
    }

    @Override
    public PartialFunction orElse(PartialFunction that) {
        return PartialFunction$class.orElse(this, that);
    }

    @Override
    public Object projection() {
        return SeqLike$class.projection(this);
    }

    @Override
    public boolean containsSlice(Seq that) {
        return SeqLike$class.containsSlice(this, that);
    }

    @Override
    public boolean equalsWith(Seq that, Function2 f) {
        return SeqLike$class.equalsWith(this, that, f);
    }

    @Override
    public int findLastIndexOf(Function1 p) {
        return SeqLike$class.findLastIndexOf(this, p);
    }

    @Override
    public boolean equals(Object that) {
        return SeqLike$class.equals(this, that);
    }

    @Override
    public int hashCode() {
        return SeqLike$class.hashCode(this);
    }

    @Override
    public Range indices() {
        return SeqLike$class.indices(this);
    }

    @Override
    public Seq toSeq() {
        return SeqLike$class.toSeq(this);
    }

    @Override
    public Object sortBy(Function1 f, Ordering ord) {
        return SeqLike$class.sortBy(this, f, ord);
    }

    @Override
    public Object sortWith(Ordering ord) {
        return SeqLike$class.sortWith((SeqLike)this, ord);
    }

    @Override
    public Object sortWith(Function2 lt) {
        return SeqLike$class.sortWith((SeqLike)this, lt);
    }

    @Override
    public Object padTo(int len, Object elem2, CanBuildFrom bf) {
        return SeqLike$class.padTo(this, len, elem2, bf);
    }

    @Override
    public Object $colon$plus(Object elem2, CanBuildFrom bf) {
        return SeqLike$class.$colon$plus(this, elem2, bf);
    }

    @Override
    public Object $plus$colon(Object elem2, CanBuildFrom bf) {
        return SeqLike$class.$plus$colon(this, elem2, bf);
    }

    @Override
    public Object updated(int index2, Object elem2, CanBuildFrom bf) {
        return SeqLike$class.updated(this, index2, elem2, bf);
    }

    @Override
    public Object patch(int from2, Seq patch, int replaced, CanBuildFrom bf) {
        return SeqLike$class.patch(this, from2, patch, replaced, bf);
    }

    @Override
    public Object removeDuplicates() {
        return SeqLike$class.removeDuplicates(this);
    }

    @Override
    public Object intersect(Seq that) {
        return SeqLike$class.intersect(this, that);
    }

    @Override
    public Object diff(Seq that) {
        return SeqLike$class.diff(this, that);
    }

    @Override
    public Object union(Seq that, CanBuildFrom bf) {
        return SeqLike$class.union(this, that, bf);
    }

    @Override
    public boolean contains(Object elem2) {
        return SeqLike$class.contains(this, elem2);
    }

    @Override
    public int lastIndexOfSeq(Seq that, int fromIndex) {
        return SeqLike$class.lastIndexOfSeq(this, that, fromIndex);
    }

    @Override
    public int lastIndexOfSeq(Seq that) {
        return SeqLike$class.lastIndexOfSeq(this, that);
    }

    @Override
    public int indexOfSeq(Seq that, int fromIndex) {
        return SeqLike$class.indexOfSeq(this, that, fromIndex);
    }

    @Override
    public int indexOfSeq(Seq that) {
        return SeqLike$class.indexOfSeq(this, that);
    }

    @Override
    public boolean startsWith(Seq that) {
        return SeqLike$class.startsWith(this, that);
    }

    @Override
    public Iterator reversedElements() {
        return SeqLike$class.reversedElements(this);
    }

    @Override
    public Object reverseMap(Function1 f, CanBuildFrom bf) {
        return SeqLike$class.reverseMap(this, f, bf);
    }

    @Override
    public int lastIndexWhere(Function1 p) {
        return SeqLike$class.lastIndexWhere(this, p);
    }

    @Override
    public int lastIndexOf(Object elem2, int end) {
        return SeqLike$class.lastIndexOf(this, elem2, end);
    }

    @Override
    public int lastIndexOf(Object elem2) {
        return SeqLike$class.lastIndexOf(this, elem2);
    }

    @Override
    public int indexOf(Object elem2, int from2) {
        return SeqLike$class.indexOf(this, elem2, from2);
    }

    @Override
    public int indexOf(Object elem2) {
        return SeqLike$class.indexOf(this, elem2);
    }

    @Override
    public int findIndexOf(Function1 p) {
        return SeqLike$class.findIndexOf(this, p);
    }

    @Override
    public int indexWhere(Function1 p) {
        return SeqLike$class.indexWhere(this, p);
    }

    @Override
    public int prefixLength(Function1 p) {
        return SeqLike$class.prefixLength(this, p);
    }

    @Override
    public boolean isDefinedAt(int x) {
        return SeqLike$class.isDefinedAt(this, x);
    }

    @Override
    public int size() {
        return SeqLike$class.size(this);
    }

    @Override
    public boolean endsWith(Seq that) {
        return IndexedSeqLike$class.endsWith(this, that);
    }

    @Override
    public boolean startsWith(Seq that, int offset) {
        return IndexedSeqLike$class.startsWith(this, that, offset);
    }

    @Override
    public Iterator reverseIterator() {
        return IndexedSeqLike$class.reverseIterator(this);
    }

    @Override
    public int lastIndexWhere(Function1 p, int end) {
        return IndexedSeqLike$class.lastIndexWhere(this, p, end);
    }

    @Override
    public int indexWhere(Function1 p, int from2) {
        return IndexedSeqLike$class.indexWhere(this, p, from2);
    }

    @Override
    public int segmentLength(Function1 p, int from2) {
        return IndexedSeqLike$class.segmentLength(this, p, from2);
    }

    @Override
    public int lengthCompare(int len) {
        return IndexedSeqLike$class.lengthCompare(this, len);
    }

    public void copyToArray(Object xs, int start, int len) {
        IndexedSeqLike$class.copyToArray(this, xs, start, len);
    }

    @Override
    public boolean sameElements(Iterable that) {
        return IndexedSeqLike$class.sameElements(this, that);
    }

    @Override
    public Tuple2 span(Function1 p) {
        return IndexedSeqLike$class.span(this, p);
    }

    @Override
    public Object dropWhile(Function1 p) {
        return IndexedSeqLike$class.dropWhile(this, p);
    }

    @Override
    public Object takeWhile(Function1 p) {
        return IndexedSeqLike$class.takeWhile(this, p);
    }

    @Override
    public Tuple2 splitAt(int n) {
        return IndexedSeqLike$class.splitAt(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return IndexedSeqLike$class.dropRight(this, n);
    }

    @Override
    public Object takeRight(int n) {
        return IndexedSeqLike$class.takeRight(this, n);
    }

    @Override
    public Object drop(int n) {
        return IndexedSeqLike$class.drop(this, n);
    }

    @Override
    public Object take(int n) {
        return IndexedSeqLike$class.take(this, n);
    }

    @Override
    public Object init() {
        return IndexedSeqLike$class.init(this);
    }

    @Override
    public Object last() {
        return IndexedSeqLike$class.last(this);
    }

    @Override
    public Object tail() {
        return IndexedSeqLike$class.tail(this);
    }

    @Override
    public Object head() {
        return IndexedSeqLike$class.head(this);
    }

    @Override
    public Object slice(int from2, int until2) {
        return IndexedSeqLike$class.slice(this, from2, until2);
    }

    @Override
    public Object zipWithIndex(CanBuildFrom bf) {
        return IndexedSeqLike$class.zipWithIndex(this, bf);
    }

    @Override
    public Object zip(Iterable that, CanBuildFrom bf) {
        return IndexedSeqLike$class.zip(this, that, bf);
    }

    @Override
    public Object reduceRight(Function2 op) {
        return IndexedSeqLike$class.reduceRight(this, op);
    }

    @Override
    public Object reduceLeft(Function2 op) {
        return IndexedSeqLike$class.reduceLeft(this, op);
    }

    @Override
    public Object foldRight(Object z, Function2 op) {
        return IndexedSeqLike$class.foldRight(this, z, op);
    }

    @Override
    public Object foldLeft(Object z, Function2 op) {
        return IndexedSeqLike$class.foldLeft(this, z, op);
    }

    @Override
    public Option find(Function1 p) {
        return IndexedSeqLike$class.find(this, p);
    }

    @Override
    public boolean exists(Function1 p) {
        return IndexedSeqLike$class.exists(this, p);
    }

    @Override
    public boolean forall(Function1 p) {
        return IndexedSeqLike$class.forall(this, p);
    }

    @Override
    public void foreach(Function1 f) {
        IndexedSeqLike$class.foreach(this, f);
    }

    @Override
    public boolean isEmpty() {
        return IndexedSeqLike$class.isEmpty(this);
    }

    @Override
    public Iterator iterator() {
        return IndexedSeqLike$class.iterator(this);
    }

    @Override
    public final boolean scala$collection$IndexedSeqLike$$super$endsWith(Seq that) {
        return SeqLike$class.endsWith(this, that);
    }

    @Override
    public final boolean scala$collection$IndexedSeqLike$$super$sameElements(Iterable that) {
        return IterableLike$class.sameElements(this, that);
    }

    @Override
    public final Object scala$collection$IndexedSeqLike$$super$init() {
        return TraversableLike$class.init(this);
    }

    @Override
    public final Object scala$collection$IndexedSeqLike$$super$last() {
        return TraversableLike$class.last(this);
    }

    @Override
    public final Object scala$collection$IndexedSeqLike$$super$tail() {
        return TraversableLike$class.tail(this);
    }

    @Override
    public final Object scala$collection$IndexedSeqLike$$super$head() {
        return IterableLike$class.head(this);
    }

    @Override
    public final Object scala$collection$IndexedSeqLike$$super$zip(Iterable that, CanBuildFrom bf) {
        return IterableLike$class.zip(this, that, bf);
    }

    @Override
    public final Object scala$collection$IndexedSeqLike$$super$reduceRight(Function2 op) {
        return IterableLike$class.reduceRight(this, op);
    }

    @Override
    public final Object scala$collection$IndexedSeqLike$$super$reduceLeft(Function2 op) {
        return TraversableLike$class.reduceLeft(this, op);
    }

    @Override
    public IndexedSeqView view(int from2, int until2) {
        return scala.collection.mutable.IndexedSeqLike$class.view(this, from2, until2);
    }

    @Override
    public Object view() {
        return scala.collection.mutable.IndexedSeqLike$class.view(this);
    }

    @Override
    public IndexedSeq toCollection(Object repr) {
        return scala.collection.mutable.IndexedSeqLike$class.toCollection(this, repr);
    }

    @Override
    public IndexedSeq thisCollection() {
        return scala.collection.mutable.IndexedSeqLike$class.thisCollection(this);
    }

    @Override
    public GenericCompanion companion() {
        return scala.collection.mutable.IndexedSeq$class.companion(this);
    }
}

