/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JConstantPool;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class JInnerClassesAttribute
extends JAttribute {
    private LinkedList entries = new LinkedList();
    private JConstantPool pool;

    public JInnerClassesAttribute(FJBGContext context, JClass clazz) {
        super(context, clazz);
        this.pool = clazz.pool;
    }

    public void addEntry(String inner, String outer, String name, int flags) {
        Entry e = new Entry(inner, outer, name, flags);
        this.entries.add(e);
    }

    public String getName() {
        return "InnerClasses";
    }

    protected int getSize() {
        return 2 + this.entries.size() * 8;
    }

    protected void writeContentsTo(DataOutputStream stream) throws IOException {
        stream.writeShort(this.entries.size());
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            Entry e = (Entry)it.next();
            stream.writeShort(e.innerInfo);
            stream.writeShort(e.outerInfo);
            stream.writeShort(e.originalName);
            stream.writeShort(e.innerFlags);
        }
    }

    private class Entry {
        int innerInfo;
        int outerInfo;
        int originalName;
        int innerFlags;

        public Entry(int iI, int oI, int oN, int f) {
            this.innerInfo = iI;
            this.outerInfo = oI;
            this.originalName = oN;
            this.innerFlags = f;
        }

        public Entry(String innerClass, String outerClass, String name, int flags) {
            this(jInnerClassesAttribute.pool.addClass(innerClass), jInnerClassesAttribute.pool.addClass(outerClass), jInnerClassesAttribute.pool.addUtf8(name), flags);
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                Entry otherEntry = (Entry)other;
                return otherEntry.innerInfo == this.innerInfo;
            }
            return false;
        }
    }
}

