/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime;

import scala.runtime.Equality;

public class BoxesRunTime {
    private static final int CHAR = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int INT = 3;
    private static final int LONG = 4;
    private static final int FLOAT = 5;
    private static final int DOUBLE = 6;
    private static final int OTHER = 7;

    private static int typeCode(Object object) {
        if (object instanceof Integer) {
            return 3;
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Character) {
            return 0;
        }
        if (object instanceof Long) {
            return 4;
        }
        if (object instanceof Double) {
            return 6;
        }
        if (object instanceof Short) {
            return 2;
        }
        if (object instanceof Float) {
            return 5;
        }
        return 7;
    }

    private static String boxDescription(Object object) {
        return "" + object.getClass().getSimpleName() + "(" + object + ")";
    }

    public static Boolean boxToBoolean(boolean bl) {
        return bl;
    }

    public static Character boxToCharacter(char c) {
        Character c2;
        try {
            c2 = Character.valueOf(c);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            c2 = new Character(c);
        }
        return c2;
    }

    public static Byte boxToByte(byte by) {
        return by;
    }

    public static Short boxToShort(short s) {
        return s;
    }

    public static Integer boxToInteger(int n) {
        return n;
    }

    public static Long boxToLong(long l) {
        return l;
    }

    public static Float boxToFloat(float f) {
        return Float.valueOf(f);
    }

    public static Double boxToDouble(double d) {
        return d;
    }

    public static boolean unboxToBoolean(Object object) {
        return object == null ? false : (Boolean)object;
    }

    public static char unboxToChar(Object object) {
        return object == null ? (char)'\u0000' : ((Character)object).charValue();
    }

    public static byte unboxToByte(Object object) {
        return object == null ? (byte)0 : (Byte)object;
    }

    public static short unboxToShort(Object object) {
        return object == null ? (short)0 : (Short)object;
    }

    public static int unboxToInt(Object object) {
        return object == null ? 0 : (Integer)object;
    }

    public static long unboxToLong(Object object) {
        return object == null ? 0L : (Long)object;
    }

    public static float unboxToFloat(Object object) {
        return object == null ? 0.0f : ((Float)object).floatValue();
    }

    public static double unboxToDouble(Object object) {
        return object == null ? 0.0 : (Double)object;
    }

    private static boolean equalsBonusLogicFromScala27(Object object, Object object2) {
        if (object instanceof Number || object instanceof Character || object2 instanceof Number || object2 instanceof Character) {
            int n;
            int n2 = BoxesRunTime.typeCode(object);
            int n3 = n2 < (n = BoxesRunTime.typeCode(object2)) ? n : n2;
            boolean bl = false;
            if (n3 <= 3) {
                int n4 = n2 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
                int n5 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                boolean bl2 = bl = n4 == n5;
            }
            if (n3 <= 4) {
                long l = n2 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
                long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                boolean bl3 = bl = l == l2;
            }
            if (n3 <= 5) {
                float f = n2 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
                float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
                boolean bl4 = bl = f == f2;
            }
            if (n3 <= 6) {
                double d = n2 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
                double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
                boolean bl5 = bl = d == d2;
            }
            return bl || object2.equals(object);
        }
        return false;
    }

    private static String logMessage(Object object, Object object2, String string2) {
        return "Compared boxed primitives (" + BoxesRunTime.boxDescription(object) + " == " + BoxesRunTime.boxDescription(object2) + ") @ " + string2;
    }

    private static void verifyEqEq(Object object, Object object2, boolean bl, boolean bl2) {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n < 7 && n2 < 7 && n != n2 && (!bl2 || BoxesRunTime.equalsBonusLogicFromScala27(object, object2))) {
            String string2 = BoxesRunTime.logMessage(object, object2, Equality.whereAreWe(5));
            Equality.warnOrDie(string2, bl);
        }
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        BoxesRunTime.verifyEqEq(object, object2, Equality.dieOnBoxedCompare || Equality.dieOnBoxedCompareIfValuesAreEqual, Equality.warnOnBoxedCompareIfValuesAreEqual || Equality.dieOnBoxedCompareIfValuesAreEqual);
        if (object.equals(object2)) {
            return true;
        }
        if (Equality.use28Semantics) {
            return false;
        }
        return BoxesRunTime.equalsBonusLogicFromScala27(object, object2);
    }

    public static Object add(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 + n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l + l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f + f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d + d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object subtract(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 - n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l - l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f - f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d - d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object multiply(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 * n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l * l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f * f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d * d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object divide(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 / n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l / l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f / f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d / d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeModulo(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 % n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l % l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f % f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d % d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object shiftSignedRight(Object object, Object object2) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n <= 3) {
            int n3;
            int n4 = n3 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            if (n2 <= 3) {
                int n5 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToInteger(n3 >> n5);
            }
            if (n2 <= 4) {
                long l = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToInteger(n3 >> (int)l);
            }
        }
        if (n <= 4) {
            long l;
            long l2 = l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            if (n2 <= 3) {
                int n6 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToLong(l >> n6);
            }
            if (n2 <= 4) {
                long l3 = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToLong(l >> (int)l3);
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object shiftSignedLeft(Object object, Object object2) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n <= 3) {
            int n3;
            int n4 = n3 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            if (n2 <= 3) {
                int n5 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToInteger(n3 << n5);
            }
            if (n2 <= 4) {
                long l = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToInteger(n3 << (int)l);
            }
        }
        if (n <= 4) {
            long l;
            long l2 = l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            if (n2 <= 3) {
                int n6 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToLong(l << n6);
            }
            if (n2 <= 4) {
                long l3 = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToLong(l << (int)l3);
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object shiftLogicalRight(Object object, Object object2) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n <= 3) {
            int n3;
            int n4 = n3 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            if (n2 <= 3) {
                int n5 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToInteger(n3 >>> n5);
            }
            if (n2 <= 4) {
                long l = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToInteger(n3 >>> (int)l);
            }
        }
        if (n <= 4) {
            long l;
            long l2 = l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            if (n2 <= 3) {
                int n6 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToLong(l >>> n6);
            }
            if (n2 <= 4) {
                long l3 = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToLong(l >>> (int)l3);
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object negate(Object object) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        if (n <= 3) {
            int n2 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            return BoxesRunTime.boxToInteger(-n2);
        }
        if (n <= 4) {
            long l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            return BoxesRunTime.boxToLong(-l);
        }
        if (n <= 5) {
            float f = n == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            return BoxesRunTime.boxToFloat(-f);
        }
        if (n <= 6) {
            double d = n == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            return BoxesRunTime.boxToDouble(-d);
        }
        throw new NoSuchMethodException();
    }

    public static Object positive(Object object) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        if (n <= 3) {
            int n2 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            return BoxesRunTime.boxToInteger(n2);
        }
        if (n <= 4) {
            long l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            return BoxesRunTime.boxToLong(l);
        }
        if (n <= 5) {
            float f = n == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            return BoxesRunTime.boxToFloat(f);
        }
        if (n <= 6) {
            double d = n == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            return BoxesRunTime.boxToDouble(d);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeAnd(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) {
                throw new NoSuchMethodException();
            }
            return BoxesRunTime.boxToBoolean((Boolean)object & (Boolean)object2);
        }
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 & n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l & l2);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeOr(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) {
                throw new NoSuchMethodException();
            }
            return BoxesRunTime.boxToBoolean((Boolean)object | (Boolean)object2);
        }
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 | n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l | l2);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeXor(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) {
                throw new NoSuchMethodException();
            }
            return BoxesRunTime.boxToBoolean((Boolean)object ^ (Boolean)object2);
        }
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 ^ n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l ^ l2);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeConditionalAnd(Object object, Object object2) throws NoSuchMethodException {
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return BoxesRunTime.boxToBoolean((Boolean)object != false && (Boolean)object2 != false);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeConditionalOr(Object object, Object object2) throws NoSuchMethodException {
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return BoxesRunTime.boxToBoolean((Boolean)object != false || (Boolean)object2 != false);
        }
        throw new NoSuchMethodException();
    }

    public static Object complement(Object object) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        if (n <= 3) {
            int n2 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            return BoxesRunTime.boxToInteger(~n2);
        }
        if (n <= 4) {
            long l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            return BoxesRunTime.boxToLong(l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeNot(Object object) throws NoSuchMethodException {
        if (object instanceof Boolean) {
            return BoxesRunTime.boxToBoolean((Boolean)object == false);
        }
        throw new NoSuchMethodException();
    }

    public static Object testEqual(Object object, Object object2) throws NoSuchMethodException {
        return BoxesRunTime.boxToBoolean(object == object2);
    }

    public static Object testNotEqual(Object object, Object object2) throws NoSuchMethodException {
        return BoxesRunTime.boxToBoolean(object != object2);
    }

    public static Object testLessThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToBoolean(n5 < n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToBoolean(l < l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToBoolean(f < f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToBoolean(d < d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object testLessOrEqualThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToBoolean(n5 <= n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToBoolean(l <= l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToBoolean(f <= f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToBoolean(d <= d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object testGreaterOrEqualThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToBoolean(n5 >= n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToBoolean(l >= l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToBoolean(f >= f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToBoolean(d >= d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object testGreaterThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToBoolean(n5 > n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToBoolean(l > l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToBoolean(f > f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToBoolean(d > d2);
        }
        throw new NoSuchMethodException();
    }

    public static Character toCharacter(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToShort(object));
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToDouble(object));
        }
        throw new NoSuchMethodException();
    }

    public static Byte toByte(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToShort(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToDouble(object));
        }
        throw new NoSuchMethodException();
    }

    public static Short toShort(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToShort(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToDouble(object));
        }
        throw new NoSuchMethodException();
    }

    public static Integer toInteger(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToDouble(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }

    public static Long toLong(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToDouble(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }

    public static Float toFloat(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToDouble(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }

    public static Double toDouble(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }
}

