/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Stream$cons$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public abstract class Iterator$class {
    public static void $init$(Iterator $this) {
    }

    private static final Iterator loop$1(Iterator $this, int left) {
        while (left > 0 && $this.hasNext()) {
            $this.next();
            --left;
        }
        return $this;
    }

    public static /* synthetic */ int sliding$default$2(Iterator $this) {
        return 1;
    }

    public static void readInto(Iterator $this, Object xs) {
        $this.readInto(xs, 0, ScalaRunTime$.MODULE$.array_length(xs));
    }

    public static void readInto(Iterator $this, Object xs, int start) {
        $this.readInto(xs, start, ScalaRunTime$.MODULE$.array_length(xs) - start);
    }

    public static void readInto(Iterator $this, Object xs, int start, int sz) {
        int i = start;
        while ($this.hasNext() && i - start < sz) {
            ScalaRunTime$.MODULE$.array_update(xs, i, $this.next());
            ++i;
        }
    }

    public static Object counted(Iterator $this) {
        return new Iterator$.anon.1($this);
    }

    public static Seq collect(Iterator $this) {
        return $this.toSeq();
    }

    public static int findIndexOf(Iterator $this, Function1 p) {
        return $this.indexWhere(p);
    }

    public static Object append(Iterator $this, Iterator that$4) {
        return new Iterator$.anon.29($this, that$4);
    }

    public static String toString(Iterator $this) {
        return new StringBuilder().append((Object)($this.hasNext() ? "non-empty" : "empty")).append((Object)" iterator").toString();
    }

    public static StringBuilder addString(Iterator $this, StringBuilder buf) {
        return $this.addString(buf, "", "", "");
    }

    public static StringBuilder addString(Iterator $this, StringBuilder buf, String sep) {
        return $this.addString(buf, "", sep, "");
    }

    public static StringBuilder addString(Iterator $this, StringBuilder buf, String start, String sep, String end) {
        buf.append(start);
        Iterator elems = $this;
        Object object = elems.hasNext() ? buf.append(elems.next()) : BoxedUnit.UNIT;
        while (elems.hasNext()) {
            buf.append(sep);
            buf.append(elems.next());
        }
        return buf.append(end);
    }

    public static String mkString(Iterator $this) {
        return $this.mkString("");
    }

    public static String mkString(Iterator $this, String sep) {
        return $this.mkString("", sep, "");
    }

    public static String mkString(Iterator $this, String start, String sep, String end) {
        StringBuilder buf = new StringBuilder();
        return $this.addString(buf, start, sep, end).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Seq toSeq(Iterator $this) {
        void var1_1;
        ArrayBuffer buffer = new ArrayBuffer();
        $this.copyToBuffer(buffer);
        return var1_1;
    }

    public static Stream toStream(Iterator $this) {
        return $this.hasNext() ? Stream$cons$.MODULE$.apply($this.next(), new Iterator$.anonfun.toStream.1($this)) : Stream$.MODULE$.empty();
    }

    public static List toList(Iterator $this) {
        ListBuffer res = new ListBuffer();
        while ($this.hasNext()) {
            res.$plus$eq($this.next());
        }
        return res.toList();
    }

    public static void copyToBuffer(Iterator $this, Buffer dest) {
        while ($this.hasNext()) {
            dest.$plus$eq($this.next());
        }
    }

    public static void copyToArray(Iterator $this, Object xs) {
        $this.copyToArray(xs, 0, ScalaRunTime$.MODULE$.array_length(xs));
    }

    public static void copyToArray(Iterator $this, Object xs, int start) {
        $this.copyToArray(xs, start, ScalaRunTime$.MODULE$.array_length(xs) - start);
    }

    public static void copyToArray(Iterator $this, Object xs, int start, int len) {
        int end = Predef$.MODULE$.intWrapper(start + len).min(ScalaRunTime$.MODULE$.array_length(xs));
        for (int i = start; $this.hasNext() && i < end; ++i) {
            ScalaRunTime$.MODULE$.array_update(xs, i, $this.next());
        }
    }

    public static Object patch(Iterator $this, int from$1, Iterator patchElems$1, int replaced$1) {
        return new Iterator$.anon.28($this, from$1, patchElems$1, replaced$1);
    }

    public static Tuple2 duplicate(Iterator $this) {
        Queue gap$1 = new Queue();
        ObjectRef ahead$1 = new ObjectRef(null);
        return new Tuple2<Iterator.Partner.1, Iterator.Partner.1>(new Iterator.Partner.1($this, gap$1, ahead$1), new Iterator.Partner.1($this, gap$1, ahead$1));
    }

    /*
     * WARNING - void declaration
     */
    public static int length(Iterator $this) {
        void var1_1;
        int i = 0;
        while ($this.hasNext()) {
            $this.next();
            ++i;
        }
        return (int)var1_1;
    }

    public static Iterator.GroupedIterator sliding(Iterator $this, int size2, int step) {
        return new Iterator.GroupedIterator($this, $this, size2, step);
    }

    public static Iterator.GroupedIterator grouped(Iterator $this, int size2) {
        return new Iterator.GroupedIterator($this, $this, size2, size2);
    }

    /*
     * WARNING - void declaration
     */
    public static final Seq scala$collection$Iterator$$takeDestructively(Iterator $this, int size2) {
        void var2_2;
        ArrayBuffer buf = new ArrayBuffer();
        for (int i = 0; $this.hasNext() && i < size2; ++i) {
            buf.$plus$eq($this.next());
        }
        return var2_2;
    }

    public static Object buffered(Iterator $this) {
        return new Iterator$.anon.2($this);
    }

    public static Option reduceRightOption(Iterator $this, Function2 op) {
        return $this.hasNext() ? new Some($this.reduceRight(op)) : None$.MODULE$;
    }

    public static Option reduceLeftOption(Iterator $this, Function2 op) {
        return $this.hasNext() ? new Some($this.reduceLeft(op)) : None$.MODULE$;
    }

    public static Object reduceRight(Iterator $this, Function2 op) {
        if ($this.hasNext()) {
            return $this.foldRight($this.next(), op);
        }
        throw new UnsupportedOperationException("empty.reduceRight");
    }

    public static Object reduceLeft(Iterator $this, Function2 op) {
        if ($this.hasNext()) {
            return $this.foldLeft($this.next(), op);
        }
        throw new UnsupportedOperationException("empty.reduceLeft");
    }

    public static Object $colon$bslash(Iterator $this, Object z, Function2 op) {
        return $this.foldRight(z, op);
    }

    public static Object $div$colon(Iterator $this, Object z, Function2 op) {
        return $this.foldLeft(z, op);
    }

    public static Object foldRight(Iterator $this, Object z, Function2 op) {
        return $this.hasNext() ? op.apply($this.next(), $this.foldRight(z, op)) : z;
    }

    /*
     * WARNING - void declaration
     */
    public static Object foldLeft(Iterator $this, Object z, Function2 op) {
        void var3_3;
        Object acc = z;
        while ($this.hasNext()) {
            acc = op.apply(acc, $this.next());
        }
        return var3_3;
    }

    public static int indexOf(Iterator $this, Object elem2) {
        int i = 0;
        boolean found = false;
        while (!found && $this.hasNext()) {
            if (BoxesRunTime.equals($this.next(), elem2)) {
                found = true;
                continue;
            }
            ++i;
        }
        return found ? i : -1;
    }

    public static int indexWhere(Iterator $this, Function1 p) {
        int i = 0;
        boolean found = false;
        while (!found && $this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply($this.next()))) {
                found = true;
                continue;
            }
            ++i;
        }
        return found ? i : -1;
    }

    /*
     * WARNING - void declaration
     */
    public static Option find(Iterator $this, Function1 p) {
        void var2_2;
        Option res = None$.MODULE$;
        while (((Option)res).isEmpty() && $this.hasNext()) {
            Object e = $this.next();
            if (!BoxesRunTime.unboxToBoolean(p.apply(e))) continue;
            res = new Some(e);
        }
        return var2_2;
    }

    public static boolean contains(Iterator $this, Object elem$5) {
        return $this.exists(new Iterator$.anonfun.contains.1($this, elem$5));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean exists(Iterator $this, Function1 p) {
        void var2_2;
        boolean res = false;
        while (!res && $this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean forall(Iterator $this, Function1 p) {
        void var2_2;
        boolean res = true;
        while (res && $this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    public static void foreach(Iterator $this, Function1 f) {
        while ($this.hasNext()) {
            f.apply($this.next());
        }
    }

    public static Object zipAll(Iterator $this, Iterator that$1, Object thisElem$1, Object thatElem$1) {
        return new Iterator$.anon.5($this, that$1, thisElem$1, thatElem$1);
    }

    public static Object zipWithIndex(Iterator $this) {
        return new Iterator$.anon.27($this);
    }

    public static Object padTo(Iterator $this, int len$2, Object elem$4) {
        return new Iterator$.anon.26($this, len$2, elem$4);
    }

    public static Object zip(Iterator $this, Iterator that$3) {
        return new Iterator$.anon.7($this, that$3);
    }

    public static Iterator dropWhile(Iterator $this, Function1 p$3) {
        Object self$5 = $this.buffered();
        return new Iterator$.anon.25($this, p$3, self$5);
    }

    public static Tuple2 partition(Iterator $this, Function1 p$5) {
        Object self$4 = $this.buffered();
        Iterator.PartitionIterator.1 l = new Iterator.PartitionIterator.1($this, p$5, self$4);
        Iterator.PartitionIterator.1 r = new Iterator.PartitionIterator.1($this, (Function1)new Iterator$.anonfun.1($this, p$5), self$4);
        l.other_$eq(r);
        r.other_$eq(l);
        return new Tuple2<Iterator.PartitionIterator.1, Iterator.PartitionIterator.1>(l, r);
    }

    public static Iterator takeWhile(Iterator $this, Function1 p$2) {
        Object self$3 = $this.buffered();
        return new Iterator$.anon.24($this, p$2, self$3);
    }

    public static Iterator filterMap(Iterator $this, PartialFunction pf$1) {
        Object self$2 = $this.buffered();
        return new Iterator$.anon.23($this, pf$1, self$2);
    }

    public static Iterator filterNot(Iterator $this, Function1 p$4) {
        return $this.filter(new Iterator$.anonfun.filterNot.1($this, p$4));
    }

    public static Iterator filter(Iterator $this, Function1 p$1) {
        Object self$1 = $this.buffered();
        return new Iterator$.anon.22($this, p$1, self$1);
    }

    public static Iterator flatMap(Iterator $this, Function1 f$2) {
        return new Iterator$.anon.21($this, f$2);
    }

    public static Object $plus$plus(Iterator $this, Function0 that$2) {
        return new Iterator$.anon.6($this, that$2);
    }

    public static Iterator map(Iterator $this, Function1 f$1) {
        return new Iterator$.anon.20($this, f$1);
    }

    public static Iterator slice(Iterator $this, int from2, int until2) {
        return $this.drop(from2).take(until2 - from2);
    }

    public static Iterator drop(Iterator $this, int n) {
        return Iterator$class.loop$1($this, n);
    }

    public static Iterator take(Iterator $this, int n$1) {
        return new Iterator$.anon.19($this, n$1);
    }
}

