/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.scheduler;

import java.util.Iterator;
import java.util.List;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Actor;
import scala.actors.Debug$;
import scala.actors.IScheduler;
import scala.actors.IScheduler$class;
import scala.actors.Reactor;
import scala.actors.scheduler.QuitException;
import scala.actors.scheduler.ResizableThreadPoolScheduler$;
import scala.actors.scheduler.TerminationMonitor;
import scala.actors.scheduler.TerminationMonitor$class;
import scala.actors.scheduler.ThreadPoolConfig$;
import scala.actors.threadpool.BlockingQueue;
import scala.actors.threadpool.LinkedBlockingQueue;
import scala.actors.threadpool.ThreadPoolExecutor;
import scala.actors.threadpool.TimeUnit;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ManagedBlocker;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizableThreadPoolScheduler
extends Thread
implements IScheduler,
TerminationMonitor,
ScalaObject {
    private boolean scala$actors$scheduler$TerminationMonitor$$started;
    private final HashMap terminationHandlers;
    private int activeActors;
    private ThreadPoolExecutor executor;
    private final int CHECK_FREQ;
    private final int numCores;
    private final int maxSize;
    private int coreSize;
    private volatile List<?> drainedTasks;
    private boolean suspending;
    private boolean terminating;
    private final boolean daemon;
    private final boolean terminate;

    public ResizableThreadPoolScheduler(boolean terminate2, boolean daemon) {
        this.terminate = terminate2;
        this.daemon = daemon;
        IScheduler$class.$init$(this);
        TerminationMonitor$class.$init$(this);
        this.setDaemon(daemon);
        this.terminating = false;
        this.suspending = false;
        this.drainedTasks = null;
        this.coreSize = ThreadPoolConfig$.MODULE$.corePoolSize();
        this.maxSize = ThreadPoolConfig$.MODULE$.maxPoolSize();
        this.numCores = Runtime.getRuntime().availableProcessors();
        this.CHECK_FREQ = 10;
        this.executor = this.makeNewPool();
        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": corePoolSize = ")).append(BoxesRunTime.boxToInteger(this.coreSize())).append((Object)", maxPoolSize = ").append(BoxesRunTime.boxToInteger(this.maxSize())).toString());
    }

    private final void liftedTree1$1() {
        try {
            this.wait(Predef$.MODULE$.int2long(this.CHECK_FREQ()));
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void restart() {
        block7: {
            ResizableThreadPoolScheduler resizableThreadPoolScheduler = this;
            // MONITORENTER : resizableThreadPoolScheduler
            if (!this.suspending()) break block7;
            if (this.isActive()) {
                throw Predef$.MODULE$.error("scheduler is still active");
            }
            this.suspending_$eq(false);
            this.executor_$eq(this.makeNewPool());
            // MONITOREXIT : resizableThreadPoolScheduler
            Iterator<?> iter = this.drainedTasks().iterator();
            while (true) {
                if (!iter.hasNext()) {
                    this.start();
                    return;
                }
                this.executor().execute((Runnable)iter.next());
            }
        }
        throw Predef$.MODULE$.error("snapshot has not been invoked");
    }

    public void snapshot() {
        ResizableThreadPoolScheduler resizableThreadPoolScheduler = this;
        synchronized (resizableThreadPoolScheduler) {
            this.suspending_$eq(true);
            return;
        }
    }

    @Override
    public void managedBlock(ManagedBlocker blocker) {
        blocker.block();
    }

    @Override
    public boolean isActive() {
        ResizableThreadPoolScheduler resizableThreadPoolScheduler = this;
        synchronized (resizableThreadPoolScheduler) {
            return BoxesRunTime.unboxToBoolean(BoxesRunTime.boxToBoolean(!this.terminating() && this.executor() != null && !this.executor().isShutdown()));
        }
    }

    @Override
    public void shutdown() {
        ResizableThreadPoolScheduler resizableThreadPoolScheduler = this;
        synchronized (resizableThreadPoolScheduler) {
            this.terminating_$eq(true);
            return;
        }
    }

    @Override
    public void execute(Function0<Object> fun$1) {
        this.executor().execute(new $anon$1(this, fun$1));
    }

    @Override
    public void execute(Runnable task) {
        this.executor().execute(task);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                var1_1 = this;
                synchronized (var1_1) {
                    this.liftedTree1$1();
                    if (this.terminating()) {
                        throw new QuitException();
                    }
                    if (this.suspending()) {
                        this.drainedTasks_$eq(this.executor().shutdownNow());
                        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": drained ")).append(BoxesRunTime.boxToInteger(this.drainedTasks().size())).append((Object)" tasks").toString());
                        this.terminating_$eq(true);
                        throw new QuitException();
                    }
                    this.gc();
                    activeBlocked = this.numWorkersBlocked();
                    if (this.coreSize() - activeBlocked < this.numCores() && this.coreSize() < this.maxSize()) {
                        this.coreSize_$eq(this.numCores() + activeBlocked);
                        this.executor().setCorePoolSize(this.coreSize());
                        v0 = BoxedUnit.UNIT;
                    } else if (this.terminate() && this.allTerminated()) {
                        if (this.executor().getActiveCount() == 0) {
                            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": initiating shutdown..."));
                            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": corePoolSize = ")).append(BoxesRunTime.boxToInteger(this.coreSize())).append((Object)", maxPoolSize = ").append(BoxesRunTime.boxToInteger(this.maxSize())).toString());
                            this.terminating_$eq(true);
                            throw new QuitException();
                        }
                        v0 = BoxedUnit.UNIT;
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                    continue;
                }
                break;
            }
        }
        catch (QuitException v2) {
            this.executor().shutdown();
            return;
        }
        {
            ** while (true)
        }
    }

    /*
     * WARNING - void declaration
     */
    private int numWorkersBlocked() {
        void var2_2;
        this.executor().mainLock.lock();
        Iterator iter = this.executor().workers.iterator();
        int numBlocked = 0;
        while (iter.hasNext()) {
            Thread.State s;
            ThreadPoolExecutor.Worker w = (ThreadPoolExecutor.Worker)iter.next();
            if (w.tryLock()) {
                w.unlock();
                continue;
            }
            Thread.State state = s = w.thread.getState();
            Thread.State state2 = Thread.State.WAITING;
            if (state == null ? state2 != null : !((Object)((Object)state)).equals((Object)state2)) {
                Thread.State state3 = s;
                Thread.State state4 = Thread.State.TIMED_WAITING;
                if (state3 != null ? !((Object)((Object)state3)).equals((Object)state4) : state4 != null) continue;
            }
            ++numBlocked;
        }
        this.executor().mainLock.unlock();
        return (int)var2_2;
    }

    public ResizableThreadPoolScheduler() {
        this(false);
    }

    public ResizableThreadPoolScheduler(boolean d) {
        this(true, d);
    }

    private void executor_$eq(ThreadPoolExecutor threadPoolExecutor) {
        this.executor = threadPoolExecutor;
    }

    private ThreadPoolExecutor executor() {
        return this.executor;
    }

    private ThreadPoolExecutor makeNewPool() {
        LinkedBlockingQueue workQueue = new LinkedBlockingQueue();
        return new ThreadPoolExecutor(this.coreSize(), this.maxSize(), 60000L, TimeUnit.MILLISECONDS, (BlockingQueue)workQueue, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public int CHECK_FREQ() {
        return this.CHECK_FREQ;
    }

    private int numCores() {
        return this.numCores;
    }

    private int maxSize() {
        return this.maxSize;
    }

    private void coreSize_$eq(int n) {
        this.coreSize = n;
    }

    private int coreSize() {
        return this.coreSize;
    }

    private void drainedTasks_$eq(List<?> list2) {
        this.drainedTasks = list2;
    }

    private List<?> drainedTasks() {
        return this.drainedTasks;
    }

    private void suspending_$eq(boolean bl) {
        this.suspending = bl;
    }

    private boolean suspending() {
        return this.suspending;
    }

    private void terminating_$eq(boolean bl) {
        this.terminating = bl;
    }

    private boolean terminating() {
        return this.terminating;
    }

    public boolean daemon() {
        return this.daemon;
    }

    public boolean terminate() {
        return this.terminate;
    }

    @Override
    public void printActorDump() {
        IScheduler$class.printActorDump(this);
    }

    public void onLockup(int millis, Function0 handler) {
        IScheduler$class.onLockup(this, millis, handler);
    }

    public void onLockup(Function0 handler) {
        IScheduler$class.onLockup(this, handler);
    }

    @Override
    public void tick(Actor a) {
        IScheduler$class.tick(this, a);
    }

    @Override
    public void executeFromActor(Runnable task) {
        IScheduler$class.executeFromActor(this, task);
    }

    @Override
    public void gc() {
        TerminationMonitor$class.gc(this);
    }

    @Override
    public boolean allTerminated() {
        return TerminationMonitor$class.allTerminated(this);
    }

    @Override
    public void terminated(Reactor a) {
        TerminationMonitor$class.terminated(this, a);
    }

    public void onTerminate(Reactor a, Function0 f) {
        TerminationMonitor$class.onTerminate(this, a, f);
    }

    @Override
    public void newActor(Reactor a) {
        TerminationMonitor$class.newActor(this, a);
    }

    @Override
    public void scala$actors$scheduler$TerminationMonitor$_setter_$terminationHandlers_$eq(HashMap hashMap) {
        this.terminationHandlers = hashMap;
    }

    @Override
    public final void scala$actors$scheduler$TerminationMonitor$$started_$eq(boolean bl) {
        this.scala$actors$scheduler$TerminationMonitor$$started = bl;
    }

    @Override
    public final boolean scala$actors$scheduler$TerminationMonitor$$started() {
        return this.scala$actors$scheduler$TerminationMonitor$$started;
    }

    public HashMap terminationHandlers() {
        return this.terminationHandlers;
    }

    @Override
    public void activeActors_$eq(int n) {
        this.activeActors = n;
    }

    @Override
    public int activeActors() {
        return this.activeActors;
    }
}

