/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.tools.nsc.CompileClient$;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.StandardCompileClient;
import scala.tools.nsc.io.Directory;
import scala.tools.nsc.io.File;
import scala.tools.nsc.io.File$;
import scala.tools.nsc.io.Path;
import scala.tools.nsc.io.Path$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileSocket
implements ScalaObject {
    private final int sleepTime;
    private final int MaxAttempts;
    private final Directory portsDir;
    private final Directory tmpDir;
    private final Pattern errorPattern;
    private final String errorRegex;
    private final String serverClass;
    private final String vmCommand;

    public CompileSocket() {
        String temp1;
        block7: {
            String string;
            block6: {
                Codec x$10;
                block4: {
                    block5: {
                        temp1 = Properties$.MODULE$.scalaHome();
                        if (temp1 != null) break block4;
                        if (!true) break block5;
                        string = this.cmdName();
                        break block6;
                    }
                    throw new MatchError(temp1.toString());
                }
                String dirname = temp1;
                if (!true) break block7;
                dirname = temp1;
                Path x$9 = Path$.MODULE$.string2path(dirname);
                Path trial = File$.MODULE$.apply(x$9, x$10 = File$.MODULE$.apply$default$2(x$9)).$div(Path$.MODULE$.string2path("bin")).$div(Path$.MODULE$.string2path(this.cmdName()));
                string = trial.canRead() ? trial.path() : this.cmdName();
            }
            this.vmCommand = string;
            this.serverClass = "scala.tools.nsc.CompileServer";
            this.errorRegex = ".*(errors? found|don't know|bad option).*";
            this.errorPattern = Pattern.compile(this.errorRegex());
            String udir = (String)Option$.MODULE$.apply((Object)Properties$.MODULE$.userName()).getOrElse((Function0)new $anonfun$1(this));
            Path qual$1 = Path$.MODULE$.apply(Properties$.MODULE$.tmpDir()).$div(Path$.MODULE$.string2path("scala-devel")).$div(Path$.MODULE$.string2path(udir));
            boolean x$3 = qual$1.createDirectory$default$1();
            boolean x$4 = qual$1.createDirectory$default$2();
            Directory f2 = qual$1.createDirectory(x$3, x$4);
            if (f2.isDirectory() && f2.canWrite()) {
                this.info(new StringBuilder().append((Object)"[Temp directory: ").append((Object)f2).append((Object)"]").toString());
                this.tmpDir = f2;
                Path qual$2 = this.tmpDir().$div(Path$.MODULE$.string2path(this.dirName()));
                boolean x$5 = qual$2.createDirectory$default$1();
                boolean x$6 = qual$2.createDirectory$default$2();
                this.portsDir = qual$2.createDirectory(x$5, x$6);
                this.MaxAttempts = 100;
                this.sleepTime = 20;
                return;
            }
            throw this.fatal("Could not find a directory for temporary files");
        }
        throw new MatchError(temp1.toString());
    }

    public final long check$1(File file) {
        Thread.sleep(100L);
        return file.length();
    }

    private final Nothing$ fail$1(String string) {
        return this.fatal(Predef$.MODULE$.augmentString("Malformed server address: %s; exiting").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    private final Socket getsock$1(int attempts, String string, boolean bl) {
        Socket socket;
        if (attempts == 0) {
            this.error("Unable to establish connection to compilation daemon");
            socket = null;
        } else {
            int port;
            int n = port = bl ? this.getPort(string) : this.pollPort();
            if (port < 0) {
                return null;
            }
            InetAddress hostAdr = InetAddress.getLocalHost();
            Socket exceptionResult3 = null;
            try {
                Socket result = new Socket(hostAdr, port);
                this.info(new StringBuilder().append((Object)"[Connected to compilation daemon at port ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"]").toString());
                exceptionResult3 = result;
            }
            catch (Exception exception) {
                this.info(exception.toString());
                this.info(new StringBuilder().append((Object)"[Connecting to compilation daemon at port ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)" failed; re-trying...]").toString());
                Object object = attempts % 2 == 0 ? BoxesRunTime.boxToBoolean((boolean)this.portFile(port).delete()) : BoxedUnit.UNIT;
                Thread.sleep(100L);
                exceptionResult3 = this.getsock$1(attempts - 1, string, bl);
            }
            socket = exceptionResult3;
        }
        return socket;
    }

    public /* synthetic */ boolean getOrCreateSocket$default$2() {
        return true;
    }

    public String getPassword(int port) {
        File ff$1 = this.portFile(port);
        BufferedReader f2 = ff$1.bufferedReader(ff$1.bufferedReader$default$1());
        if (package$.MODULE$.Iterator().continually((Function0)new $anonfun$getPassword$1(this, ff$1)).take(50).find((Function1)new $anonfun$getPassword$2(this)).isEmpty()) {
            ff$1.delete();
            throw this.fatal("Unable to establish connection to server.");
        }
        String result = f2.readLine();
        f2.close();
        return result;
    }

    public Socket getSocket(String hostName, int port) {
        Socket exceptionResult2 = null;
        try {
            exceptionResult2 = new Socket(hostName, port);
            return exceptionResult2;
        }
        catch (Throwable throwable) {
            Throwable temp15;
            block9: {
                block10: {
                    block8: {
                        block6: {
                            block7: {
                                IOException temp16;
                                temp15 = throwable;
                                if (!(temp15 instanceof IOException)) break block6;
                                IOException e = temp16 = (IOException)temp15;
                                if (!true) break block7;
                                e = temp16;
                                break block8;
                            }
                            throw new MatchError(temp15.toString());
                        }
                        if (!(temp15 instanceof SecurityException)) break block9;
                        if (!true) break block10;
                        SecurityException e = (SecurityException)temp15;
                    }
                    throw this.fatal(Predef$.MODULE$.augmentString("Unable to establish connection to server %s:%d; exiting").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostName, BoxesRunTime.boxToInteger((int)port)})));
                }
                throw new MatchError(temp15.toString());
            }
            if (true) {
                throw throwable;
            }
            throw new MatchError(temp15.toString());
        }
    }

    public Socket getSocket(String serverAdr$1) {
        int temp14 = serverAdr$1.indexOf(58);
        if (temp14 == -1) {
            if (true) {
                throw this.fail$1(serverAdr$1);
            }
            throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp14)).toString());
        }
        int cpos = temp14;
        if (true) {
            cpos = temp14;
            String hostName = (String)Predef$.MODULE$.augmentString(serverAdr$1).take(cpos);
            Option<Integer> temp11 = this.parseInt((String)Predef$.MODULE$.augmentString(serverAdr$1).drop(cpos + 1));
            if (temp11 instanceof Some) {
                int temp13;
                Some temp12 = (Some)temp11;
                int port = temp13 = BoxesRunTime.unboxToInt((Object)temp12.x());
                if (true) {
                    port = temp13;
                    return this.getSocket(hostName, port);
                }
                throw new MatchError(temp11.toString());
            }
            if (true) {
                throw this.fail$1(serverAdr$1);
            }
            throw new MatchError(temp11.toString());
        }
        throw new MatchError(((Object)BoxesRunTime.boxToInteger((int)temp14)).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Option<Integer> parseInt(String x2) {
        void var2_2;
        None$ exceptionResult1 = null;
        try {
            exceptionResult1 = new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(x2).toInt()));
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult1 = None$.MODULE$;
        }
        return var2_2;
    }

    public Socket getOrCreateSocket(String vmArgs$1, boolean create$1) {
        int nAttempts = 49;
        return this.getsock$1(nAttempts, vmArgs$1, create$1);
    }

    public boolean deletePort(int port) {
        return this.portFile(port).delete();
    }

    public void setPort(int port) {
        File file = this.portFile(port);
        String secret = ((Object)BoxesRunTime.boxToInteger((int)new SecureRandom().nextInt())).toString();
        try {
            file.writeAll((Traversable<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{secret})), file.writeAll$default$2(), file.writeAll$default$3());
            return;
        }
        catch (Throwable throwable) {
            Throwable temp8;
            block9: {
                block10: {
                    block8: {
                        block6: {
                            block7: {
                                FileNotFoundException temp9;
                                temp8 = throwable;
                                if (!(temp8 instanceof FileNotFoundException)) break block6;
                                FileNotFoundException e = temp9 = (FileNotFoundException)temp8;
                                if (!true) break block7;
                                e = temp9;
                                break block8;
                            }
                            throw new MatchError(temp8.toString());
                        }
                        if (!(temp8 instanceof SecurityException)) break block9;
                        if (!true) break block10;
                        SecurityException e = (SecurityException)temp8;
                    }
                    throw this.fatal(Predef$.MODULE$.augmentString("Cannot create file: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.path()})));
                }
                throw new MatchError(temp8.toString());
            }
            if (true) {
                throw throwable;
            }
            throw new MatchError(temp8.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getPort(String vmArgs) {
        void var3_3;
        int attempts = 0;
        int port = this.pollPort();
        if (port < 0) {
            this.startNewServer(vmArgs);
        }
        while (port < 0 && attempts < this.MaxAttempts()) {
            ++attempts;
            Thread.sleep(Predef$.MODULE$.int2long(this.sleepTime()));
            port = this.pollPort();
        }
        this.info(new StringBuilder().append((Object)"[Port number: ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"]").toString());
        if (port < 0) {
            throw this.fatal("Could not connect to compilation daemon.");
        }
        return (int)var3_3;
    }

    private int pollPort() {
        List temp3;
        block5: {
            block6: {
                int n;
                block4: {
                    List temp7;
                    block2: {
                        block3: {
                            temp3 = this.portsDir().list().toList();
                            Nil$ nil$ = Nil$.MODULE$;
                            List list2 = temp3;
                            if (nil$ != null ? !nil$.equals(list2) : list2 != null) break block2;
                            if (!true) break block3;
                            n = -1;
                            break block4;
                        }
                        throw new MatchError(temp3.toString());
                    }
                    if (!(temp3 instanceof .colon.colon)) break block5;
                    .colon.colon temp5 = (.colon.colon)temp3;
                    Path temp6 = (Path)temp5.hd$1();
                    List xs = temp7 = temp5.tl$1();
                    Path p = temp6;
                    if (!true) break block6;
                    p = temp6;
                    xs = temp7;
                    xs.forall((Function1)new $anonfun$pollPort$1(this));
                    n = Predef$.MODULE$.augmentString(p.name()).toInt();
                }
                return n;
            }
            throw new MatchError(temp3.toString());
        }
        throw new MatchError(temp3.toString());
    }

    public File portFile(int port) {
        Path x$7 = Path$.MODULE$.string2path(((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        Codec x$8 = File$.MODULE$.apply$default$2(x$7);
        return this.portsDir().$div(File$.MODULE$.apply(x$7, x$8));
    }

    private void startNewServer(String vmArgs) {
        String cmd = this.serverCommand(vmArgs);
        this.info(new StringBuilder().append((Object)"[Executed command: ").append((Object)cmd).append((Object)"]").toString());
        try {
            Runtime.getRuntime().exec(cmd);
            return;
        }
        catch (IOException iOException) {
            throw this.fatal(new StringBuilder().append((Object)"Cannot start compilation daemon.\ntried command: ").append((Object)cmd).toString());
        }
    }

    private String serverCommand(String vmArgs) {
        return new StringBuilder().append((Object)this.vmCommand()).append((Object)vmArgs).append((Object)" ").append((Object)this.serverClass()).toString();
    }

    private int sleepTime() {
        return this.sleepTime;
    }

    private int MaxAttempts() {
        return this.MaxAttempts;
    }

    public Directory portsDir() {
        return this.portsDir;
    }

    public Directory tmpDir() {
        return this.tmpDir;
    }

    public void info(String msg) {
        if (this.compileClient().verbose()) {
            System.out.println(msg);
        }
    }

    public Nothing$ fatal(String msg) {
        this.error(msg);
        throw new Exception("fsc failure");
    }

    public void error(String msg) {
        System.err.println(msg);
    }

    public Pattern errorPattern() {
        return this.errorPattern;
    }

    public String errorRegex() {
        return this.errorRegex;
    }

    public String serverClass() {
        return this.serverClass;
    }

    public String vmCommand() {
        return this.vmCommand;
    }

    public String cmdName() {
        return Properties$.MODULE$.cmdName();
    }

    public String dirName() {
        return "scalac-compile-server-port";
    }

    public StandardCompileClient compileClient() {
        return CompileClient$.MODULE$;
    }
}

