/* NSC -- new Scala compiler
 * Copyright 2006-2009 LAMP/EPFL
 * @author  Martin Odersky
 */
// $Id: ConsoleWriter.scala 18773 2009-09-24 13:09:40Z dubochet $

package scala.tools.nsc

import java.io.Writer

/** A Writer that writes onto the Scala Console.
 *
 *  @author  Lex Spoon
 *  @version 1.0
 */
class ConsoleWriter extends Writer {
  def close = flush
  
  def flush = Console.flush
  
  def write(cbuf: Array[Char], off: Int, len: Int) {
    if (len > 0)
      write(new String(cbuf.slice(off, off+len)))
  }

  override def write(str: String) { Console.print(str) }
}
