/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.CustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.Module;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.PEType;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.TypeAttributes;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.io.File;
import java.io.IOException;

final class PEModule
extends Module {
    protected final PEFile pefile;
    private final int definingRow;
    private Type[] typeRefs = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected PEModule(PEFile pEFile, int n, String string, Assembly assembly) {
        super(pEFile.getName(), pEFile.getAbsolutePath(), string, assembly);
        this.pefile = pEFile;
        this.definingRow = n;
        pEFile.initModule(this);
        pEFile.TypeDef.load();
        this.loadGlobals();
    }

    public Type GetType(String string) {
        this.initTypes();
        Object v = this.typesMap.get(string);
        if (v == null) {
            return null;
        }
        return v instanceof Type ? (Type)v : this.getTypeDef((Integer)v);
    }

    protected void loadTypes() {
        int n;
        this.typeRefs = new Type[this.pefile.TypeRef.rows];
        int n2 = this.pefile.TypeDef.rows;
        for (n = 2; n <= n2; ++n) {
            String string = this.pefile.TypeDef(n).getFullName();
            this.typesMap.put(string, new Integer(n));
        }
        this.types = new Type[n2 - 1];
        for (n = 2; n <= n2; ++n) {
            this.getTypeDef(n);
        }
    }

    Type getTypeDef(int n) {
        if (this.types[n - 2] != null) {
            return this.types[n - 2];
        }
        Table.TypeDef typeDef = this.pefile.TypeDef(n);
        int n2 = typeDef.Flags;
        String string = typeDef.getFullName();
        Type type = null;
        if (TypeAttributes.isNested(n2)) {
            for (int i = 1; i <= this.pefile.NestedClass.rows; ++i) {
                this.pefile.NestedClass.readRow(i);
                if (this.pefile.NestedClass.NestedClass != n) continue;
                type = this.getTypeDef(this.pefile.NestedClass.EnclosingClass);
            }
        }
        PEType pEType = new PEType(this, n2, string, type, 0, this.pefile, n);
        this.types[n - 2] = pEType;
        this.addType(pEType);
        return pEType;
    }

    protected void loadGlobals() {
    }

    protected void loadCustomAttributes(Type type) {
        this.initAttributes(this, 1, 0, type);
    }

    Type getTypeRef(int n) {
        return this.getTypeRef(n, null);
    }

    Type getTypeRef(int n, Assembly assembly) {
        Type type = this.typeRefs[n - 1];
        if (type != null) {
            return type;
        }
        Table.TypeRef typeRef2 = this.pefile.TypeRef;
        typeRef2.readRow(n);
        int n2 = Table.getTableId(11, typeRef2.ResolutionScope);
        int n3 = typeRef2.ResolutionScope >> Table.NoBits[11];
        String string = typeRef2.getFullName();
        this.pefile.getTable(n2).readRow(n3);
        switch (n2) {
            case 35: {
                String string2 = this.pefile.AssemblyRef.getName();
                if (assembly != null && !assembly.GetName().Name.equals(string2)) {
                    return null;
                }
                Assembly assembly2 = this.getAssembly(string2);
                type = assembly2.GetType(string);
                if (type != null) break;
                throw new RuntimeException("Failed to locate type " + string + " in assembly " + assembly2);
            }
            case 0: {
                if (!$assertionsDisabled && n3 != 1) {
                    throw new AssertionError();
                }
                type = this.GetType(string);
                break;
            }
            case 1: {
                type = this.getTypeRef(n3);
                break;
            }
            case 26: {
                type = this.getAssembly(this.pefile.ModuleRef.getName()).GetType(string);
            }
            default: {
                throw new RuntimeException(n3 + "@" + this.pefile.getTable(n2).getTableName());
            }
        }
        if (this.typeRefs[n - 1] != null) {
            System.out.println("TypeRef[" + PEFile.short2hex(n) + "] " + "changing type " + this.typeRefs[n - 1] + " for type " + type);
        }
        this.typeRefs[n - 1] = type;
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)("Couldn't find type " + string));
        }
        return type;
    }

    private Assembly getAssembly(String string) {
        Assembly assembly = ch.epfl.lamp.compiler.msil.Assembly.getAssembly(string);
        if (assembly != null) {
            return assembly;
        }
        File file = this.pefile.getParentFile();
        assembly = ch.epfl.lamp.compiler.msil.Assembly.LoadFrom(file, string);
        if (assembly != null) {
            return assembly;
        }
        try {
            file = this.pefile.getUnderlyingFile().getCanonicalFile().getParentFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        assembly = ch.epfl.lamp.compiler.msil.Assembly.LoadFrom(file, string);
        if (assembly != null) {
            return assembly;
        }
        throw new RuntimeException("Cannot find assembly: " + string);
    }

    public Type getTypeDefOrRef(int n) {
        int n2 = Table.getTableId(0, n);
        int n3 = n >> Table.NoBits[0];
        Type type = null;
        switch (n2) {
            case 2: {
                type = this.getTypeDef(n3);
                break;
            }
            case 1: {
                return this.getTypeRef(n3);
            }
            case 27: {
                throw new RuntimeException("PEModule.getTypeDefOrRef(): TypeSpec");
            }
            default: {
                throw new RuntimeException("PEModule.getTypeDefOrRef(): oops!");
            }
        }
        return type;
    }

    MethodBase getMethod(int n) {
        for (int i = 0; i < this.types.length; ++i) {
            PEType pEType = (PEType)this.types[i];
            if (pEType.methodListBeg > n || n >= pEType.methodListEnd) continue;
            pEType.initMethods();
            return pEType.methoddefs[n - pEType.methodListBeg];
        }
        throw new RuntimeException("In module " + this + ": cannot find type defining method 0x" + PEFile.int2hex(n));
    }

    protected MemberInfo getMemberRef(int n) {
        return this.getMemberRef(n, null);
    }

    protected MemberInfo getMemberRef(int n, Assembly assembly) {
        MethodBase methodBase = null;
        Table.MemberRef memberRef = this.pefile.MemberRef;
        memberRef.readRow(n);
        int n2 = Table.getTableId(5, memberRef.Class);
        int n3 = Table.getTableIndex(5, memberRef.Class);
        switch (n2) {
            case 1: {
                Type type = this.getTypeRef(n3, assembly);
                if (type == null) {
                    return null;
                }
                PEFile.Sig sig = memberRef.getSignature();
                int n4 = sig.readByte();
                int n5 = sig.decodeInt();
                Type type2 = sig.decodeRetType();
                Type[] typeArray = new Type[n5];
                for (int i = 0; i < n5; ++i) {
                    typeArray[i] = sig.decodeParamType();
                }
                String string = memberRef.getName();
                methodBase = string.equals(".ctor") || string.equals(".cctor") ? type.GetConstructor(typeArray) : type.GetMethod(string, typeArray);
                if (!$assertionsDisabled && methodBase == null) {
                    throw new AssertionError((Object)(type + "::" + string));
                }
                break;
            }
            case 6: 
            case 26: 
            case 27: {
                throw new RuntimeException("initCustomAttributes: " + this.pefile.getTable(n2).getTableName());
            }
        }
        return methodBase;
    }

    protected void initCustomAttributes(Type type) {
        this.initAttributes(this, this.definingRow, 0, type);
    }

    void initAttributes(CustomAttributeProvider customAttributeProvider, int n, int n2, Type type) {
        int n3 = Table.encodeIndex(n, 2, n2);
        Table.CustomAttribute customAttribute = this.pefile.CustomAttribute;
        for (int i = 1; i <= customAttribute.rows; ++i) {
            ConstructorInfo constructorInfo = null;
            customAttribute.readRow(i);
            if (customAttribute.Parent != n3) continue;
            int n4 = Table.getTableId(10, customAttribute.Type);
            int n5 = Table.getTableIndex(10, customAttribute.Type);
            switch (n4) {
                case 6: {
                    constructorInfo = (ConstructorInfo)this.getMethod(n5);
                    break;
                }
                case 10: {
                    Assembly assembly = type == null ? null : type.Assembly();
                    MemberInfo memberInfo = this.getMemberRef(n5, assembly);
                    if (memberInfo == null) break;
                    if (!$assertionsDisabled && !(memberInfo instanceof ConstructorInfo)) {
                        throw new AssertionError((Object)("Expected ConstructorInfo; found " + memberInfo));
                    }
                    constructorInfo = (ConstructorInfo)memberInfo;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (constructorInfo == null || constructorInfo.DeclaringType != type && type != null) continue;
            customAttributeProvider.addCustomAttribute(constructorInfo, customAttribute.getValue());
        }
    }

    static {
        $assertionsDisabled = !PEModule.class.desiredAssertionStatus();
    }
}

