/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.midp.publickeystore.InputStorage;
import com.sun.midp.publickeystore.OwnerEnum;
import com.sun.midp.publickeystore.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class PublicKeyStore {
    private Vector keyList = null;

    protected PublicKeyStore() {
    }

    public PublicKeyStore(InputStream in) throws IOException {
        this.initPublicKeyStore(in, new Vector());
    }

    protected void initPublicKeyStore(Vector sharedKeyList) {
        if (this.keyList != null) {
            return;
        }
        this.keyList = sharedKeyList;
    }

    protected void initPublicKeyStore(InputStream in, Vector sharedKeyList) throws IOException {
        InputStorage storage = new InputStorage(in);
        if (this.keyList != null) {
            return;
        }
        this.keyList = sharedKeyList;
        PublicKeyInfo keyInfo;
        while ((keyInfo = PublicKeyInfo.getKeyFromStorage(storage)) != null) {
            this.keyList.addElement(keyInfo);
        }
        return;
    }

    public synchronized PublicKeyInfo findKey(String alias) {
        Enumeration e = this.keyList.elements();
        while (e.hasMoreElements()) {
            PublicKeyInfo keyInfo = (PublicKeyInfo)e.nextElement();
            if (keyInfo.getOwner().compareTo(alias) != 0) continue;
            return keyInfo;
        }
        return null;
    }

    public Enumeration getOwners() {
        return new OwnerEnum(this.keyList);
    }

    synchronized int numberOfKeys() {
        return this.keyList.size();
    }
}

