/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.Message;
import sbaz.PackageSpec;
import sbaz.ServletRequestHandler$;
import sbaz.SimpleUniverse;
import sbaz.Universe;
import sbaz.keys.Key;
import sbaz.keys.KeyRing;
import sbaz.keys.KeyUtil$;
import sbaz.keys.MessagePattern;
import sbaz.messages.AddPackage;
import sbaz.messages.KeyCreate;
import sbaz.messages.KeyCreated;
import sbaz.messages.KeyList;
import sbaz.messages.KeyRevoke;
import sbaz.messages.LatestPackages;
import sbaz.messages.NotOK;
import sbaz.messages.OK;
import sbaz.messages.RemovePackage;
import sbaz.messages.SendKeyList$;
import sbaz.messages.SendPackageList;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.Predef$;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestHandler
implements ScalaObject {
    private final List keylessRequests;
    private final KeyRing keyring;
    private AvailableList packages;
    private final SimpleUniverse universe;
    private final File directory;

    public ServletRequestHandler(File directory) {
        this.directory = directory;
        Universe universe = (Universe)this.loadXML("universe", new $anonfun$2(this), new $anonfun$1(this));
        if (universe instanceof SimpleUniverse) {
            this.universe = (SimpleUniverse)universe;
            this.packages = (AvailableList)this.loadXML("packages", new $anonfun$4(this), new $anonfun$3(this));
            this.keyring = (KeyRing)this.loadXML("keyring", new $anonfun$6(this), new $anonfun$5(this));
            this.keylessRequests = (List)this.loadXML("keylessRequests", new $anonfun$8(this), new $anonfun$7(this));
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"requests needing no key are: ").append(this.keylessRequests()).toString());
            return;
        }
        throw new Error("this universe is not a simple universe");
    }

    public final List<MessagePattern> fromXML$1(Node xml) {
        return xml.child().toList().filter((Function1)new $anonfun$fromXML$1$1(this)).map((Function1)new $anonfun$fromXML$1$2(this));
    }

    public Message handleRequest(Message req0) {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            Message message;
            Message req$1 = req0.sansKeys();
            List keys = req0.authKeys().filter((Function1)new $anonfun$9(this));
            if (this.keylessRequests().exists((Function1)new $anonfun$handleRequest$1(this, req$1)) || keys.exists((Function1)new $anonfun$handleRequest$2(this, req$1))) {
                Message message2 = req$1;
                if (message2 instanceof SendPackageList) {
                    message = new LatestPackages(this.packages());
                } else if (message2 instanceof AddPackage) {
                    AvailablePackage availablePackage;
                    AddPackage addPackage = (AddPackage)message2;
                    AvailablePackage pack$1 = availablePackage = addPackage.pack();
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"adding new package: ").append((Object)pack$1).toString());
                    List packsMinus = this.packages().available().filter((Function1)new $anonfun$10(this, pack$1));
                    AvailablePackage availablePackage2 = pack$1;
                    List newPacks = packsMinus.$colon$colon((Object)availablePackage2);
                    this.packages_$eq(new AvailableList((List<AvailablePackage>)newPacks));
                    this.savePackages();
                    message = new OK();
                } else if (message2 instanceof RemovePackage) {
                    PackageSpec packageSpec;
                    RemovePackage removePackage = (RemovePackage)message2;
                    PackageSpec spec$1 = packageSpec = removePackage.spec();
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"removing package: ").append((Object)spec$1).toString());
                    List packsMinus = this.packages().available().filter((Function1)new $anonfun$11(this, spec$1));
                    this.packages_$eq(new AvailableList((List<AvailablePackage>)packsMinus));
                    this.savePackages();
                    message = new OK();
                } else if (message2 instanceof KeyCreate) {
                    String string;
                    KeyCreate keyCreate = (KeyCreate)message2;
                    MessagePattern messagePattern = keyCreate.messages();
                    String description = string = keyCreate.description();
                    MessagePattern messages = messagePattern;
                    String data = KeyUtil$.MODULE$.genKeyData();
                    Key key = new Key(messages, description, data);
                    this.keyring().addKey(key);
                    this.saveKeyring();
                    message = new KeyCreated(key);
                } else if (message2 instanceof KeyRevoke) {
                    this.keyring().removeKey(((KeyRevoke)message2).key());
                    this.saveKeyring();
                    message = new OK();
                } else {
                    SendKeyList$ sendKeyList$ = SendKeyList$.MODULE$;
                    Message message3 = message2;
                    message = !(sendKeyList$ != null ? !sendKeyList$.equals(message3) : message3 != null) ? new KeyList(this.keyring().keys()) : new NotOK(new StringBuilder().append((Object)"unhandled message type.  full message: ").append((Object)req$1).toString());
                }
            } else {
                message = new NotOK("Permission denied");
            }
            return message;
        }
    }

    public String responseForGET() {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            StringWriter out$1 = new StringWriter();
            out$1.write("This is a Scala Bazaar.  The bazaar descriptor is:\n");
            out$1.write(this.universe().toXML().toString());
            out$1.write("\n\n");
            out$1.write("The packages included are:\n");
            this.packages().sortedSpecs().foreach((Function1)new $anonfun$responseForGET$1(this, out$1));
            return out$1.toString();
        }
    }

    public List<MessagePattern> keylessRequests() {
        return this.keylessRequests;
    }

    public boolean saveKeyring() {
        return this.saveXML(this.keyring().toXML(), "keyring");
    }

    public KeyRing keyring() {
        return this.keyring;
    }

    public boolean savePackages() {
        return this.saveXML((Node)this.packages().toXML(), "packages");
    }

    public void packages_$eq(AvailableList x$1) {
        this.packages = x$1;
    }

    public AvailableList packages() {
        return this.packages;
    }

    public SimpleUniverse universe() {
        return this.universe;
    }

    private boolean saveXML(Node xml, String filename) {
        File tmpFile = new File(this.directory, new StringBuilder().append((Object)filename).append((Object)".tmp").toString());
        FileWriter str = new FileWriter(tmpFile);
        str.write(xml.toString());
        str.close();
        return this.renameFile(tmpFile, new File(this.directory, filename));
    }

    private boolean renameFile(File from, File to) {
        to.delete();
        return from.renameTo(to);
    }

    public <A> A loadXML(String baseName, Function1<Node, A> loader, Function0<A> ifmissing) {
        Object object;
        File file = new File(this.directory, baseName);
        if (file.exists()) {
            Elem xml = XML$.MODULE$.load(file.getAbsolutePath());
            object = loader.apply((Object)xml);
        } else {
            object = ifmissing.apply();
        }
        return (A)object;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

