/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.scalatest.tools.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaTestTask
extends Task {
    private String includes;
    private String excludes;
    private boolean concurrent;
    private ArrayList<String> runpath = new ArrayList();
    private ArrayList<String> suites = new ArrayList();
    private ArrayList<String> membersonlys = new ArrayList();
    private ArrayList<String> wildcards = new ArrayList();
    private ArrayList<String> testNGSuites = new ArrayList();
    private ArrayList<ReporterElement> reporters = new ArrayList();
    private ArrayList<NameValuePair> properties = new ArrayList();

    public void execute() throws BuildException {
        ArrayList<String> args = new ArrayList<String>();
        this.addSuiteArgs(args);
        this.addReporterArgs(args);
        this.addPropertyArgs(args);
        this.addIncludesArgs(args);
        this.addExcludesArgs(args);
        this.addRunpathArgs(args);
        this.addTestNGSuiteArgs(args);
        this.addConcurrentArg(args);
        String[] argsArray = args.toArray(new String[args.size()]);
        Runner.main(argsArray);
    }

    private void addRunpathArgs(ArrayList<String> args) {
        if (this.runpath.size() > 0) {
            args.add("-p");
            args.add(this.getSpacedOutPathStr(this.runpath));
        }
    }

    private void addTestNGSuiteArgs(ArrayList<String> args) {
        if (this.testNGSuites.size() > 0) {
            args.add("-t");
            args.add(this.getSpacedOutPathStr(this.testNGSuites));
        }
    }

    private void addConcurrentArg(ArrayList<String> args) {
        if (this.concurrent) {
            args.add("-c");
        }
    }

    private void addIncludesArgs(ArrayList<String> args) {
        if (this.includes != null) {
            args.add("-n");
            args.add(this.singleSpace(this.includes));
        }
    }

    private void addExcludesArgs(ArrayList<String> args) {
        if (this.excludes != null) {
            args.add("-x");
            args.add(this.singleSpace(this.excludes));
        }
    }

    private void addPropertyArgs(ArrayList<String> args) {
        for (NameValuePair pair : this.properties) {
            args.add("-D" + pair.getName() + "=" + pair.getValue());
        }
    }

    private void addSuiteArgs(ArrayList<String> args) throws BuildException {
        for (String suite : this.suites) {
            if (suite == null) {
                throw new BuildException("missing classname attribute for <suite> element");
            }
            args.add("-s");
            args.add(suite);
        }
        for (String packageName : this.membersonlys) {
            if (packageName == null) {
                throw new BuildException("missing package attribute for <membersonly> element");
            }
            args.add("-m");
            args.add(packageName);
        }
        for (String packageName : this.wildcards) {
            if (packageName == null) {
                throw new BuildException("missing package attribute for <wildcard> element");
            }
            args.add("-w");
            args.add(packageName);
        }
    }

    private void addReporterArgs(ArrayList<String> args) throws BuildException {
        if (this.reporters.size() == 0) {
            args.add("-o");
        }
        for (ReporterElement reporter : this.reporters) {
            String type = reporter.getType();
            if (type == null) {
                throw new BuildException("missing type attribute for <reporter> element");
            }
            if (type.equals("stdout")) {
                this.addReporterOption(args, reporter, "-o");
                continue;
            }
            if (type.equals("stderr")) {
                this.addReporterOption(args, reporter, "-e");
                continue;
            }
            if (type.equals("graphic")) {
                this.addReporterOption(args, reporter, "-g");
                continue;
            }
            if (type.equals("file")) {
                this.addFileReporter(args, reporter);
                continue;
            }
            if (type.equals("reporterclass")) {
                this.addReporterClass(args, reporter);
                continue;
            }
            throw new BuildException("unknown reporter type [" + type + "]");
        }
    }

    private void addReporterOption(ArrayList<String> args, ReporterElement reporter, String option) {
        String config = reporter.getConfig();
        if (config == null) {
            args.add(option);
        } else {
            args.add(option + config);
        }
    }

    private void addFileReporter(ArrayList<String> args, ReporterElement reporter) throws BuildException {
        this.addReporterOption(args, reporter, "-f");
        if (reporter.getFilename() == null) {
            throw new BuildException("reporter type 'file' requires 'filename' attribute");
        }
        args.add(reporter.getFilename());
    }

    private void addReporterClass(ArrayList<String> args, ReporterElement reporter) throws BuildException {
        this.addReporterOption(args, reporter, "-r");
        if (reporter.getClassName() == null) {
            throw new BuildException("reporter type 'reporterclass' requires 'classname' attribute");
        }
        args.add(reporter.getClassName());
    }

    public void setRunpath(Path runpath) {
        for (String element : runpath.list()) {
            this.runpath.add(element);
        }
    }

    public void setTestNGSuites(Path testNGSuitePath) {
        for (String element : testNGSuitePath.list()) {
            this.testNGSuites.add(element);
        }
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public void addConfiguredRunpath(Path runpath) {
        for (String element : runpath.list()) {
            this.runpath.add(element);
        }
    }

    public void addConfiguredTestNGSuites(Path testNGSuitePath) {
        for (String element : testNGSuitePath.list()) {
            this.testNGSuites.add(element);
        }
    }

    public void addConfiguredRunpathUrl(RunpathUrl runpathurl) {
        this.runpath.add(runpathurl.getUrl());
    }

    public void addConfiguredProperty(NameValuePair property) {
        this.properties.add(property);
    }

    public void setSuite(String suite) {
        this.suites.add(suite);
    }

    public void setMembersonly(String packageName) {
        this.membersonlys.add(packageName);
    }

    public void setWildcard(String packageName) {
        this.wildcards.add(packageName);
    }

    public void addConfiguredSuite(SuiteElement suite) {
        this.suites.add(suite.getClassName());
    }

    public void addConfiguredMembersOnly(PackageElement membersonly) {
        this.membersonlys.add(membersonly.getPackage());
    }

    public void addConfiguredWildcard(PackageElement wildcard) {
        this.wildcards.add(wildcard.getPackage());
    }

    public void addConfiguredReporter(ReporterElement reporter) {
        this.reporters.add(reporter);
    }

    public void addConfiguredIncludes(TextElement includes) {
        this.includes = includes.getText();
    }

    public void addConfiguredExcludes(TextElement excludes) {
        this.excludes = excludes.getText();
    }

    private String getSpacedOutPathStr(ArrayList<String> path) {
        StringBuffer buf = new StringBuffer();
        String prefix = "";
        for (String elem : path) {
            buf.append(prefix);
            buf.append(elem);
            prefix = " ";
        }
        return buf.toString();
    }

    private String singleSpace(String str) {
        return str.trim().replaceAll("\\s+", " ");
    }

    public static class RunpathUrl {
        private String url;

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class NameValuePair {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ReporterElement {
        private String type;
        private String config;
        private String filename;
        private String classname;

        public void setType(String type) {
            this.type = type;
        }

        public void setConfig(String config) {
            this.config = config;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public void setClassName(String classname) {
            this.classname = classname;
        }

        public String getType() {
            return this.type;
        }

        public String getConfig() {
            return this.config;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getClassName() {
            return this.classname;
        }
    }

    public static class TextElement {
        private String text;

        public void addText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class SuiteElement {
        private String className;

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }

    public static class PackageElement {
        private String packageName;

        public void setPackage(String packageName) {
            this.packageName = packageName;
        }

        public String getPackage() {
            return this.packageName;
        }
    }
}

