/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import net.n3.nanoxml.XMLElement;

public class XMLWriter {
    private PrintWriter writer;

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public XMLWriter(OutputStream stream) {
        this.writer = new PrintWriter(stream);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void write(XMLElement xml) throws IOException {
        this.write(xml, true, 0);
    }

    public void write(XMLElement xml, boolean prettyPrint) throws IOException {
        this.write(xml, prettyPrint, 0);
    }

    public void write(XMLElement xml, boolean prettyPrint, int indent) throws IOException {
        if (prettyPrint) {
            for (int i = 0; i < indent; ++i) {
                this.writer.print(' ');
            }
        }
        if (xml.getName() == null) {
            if (xml.getContent() != null) {
                if (prettyPrint) {
                    this.writeEncoded(xml.getContent().trim());
                    this.writer.println();
                } else {
                    this.writeEncoded(xml.getContent());
                }
            }
        } else {
            this.writer.print('<');
            this.writer.print(xml.getName());
            Enumeration enumeration = xml.enumerateAttributeNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = xml.getAttribute(key);
                this.writer.print(" " + key + "=\"");
                this.writeEncoded(value);
                this.writer.print('\"');
            }
            if (xml.getContent() != null && xml.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncoded(xml.getContent());
                this.writer.print("</" + xml.getName() + '>');
                if (prettyPrint) {
                    this.writer.println();
                }
            } else if (xml.hasChildren()) {
                this.writer.print('>');
                if (prettyPrint) {
                    this.writer.println();
                }
                enumeration = xml.enumerateChildren();
                while (enumeration.hasMoreElements()) {
                    XMLElement child = (XMLElement)enumeration.nextElement();
                    this.write(child, prettyPrint, indent + 4);
                }
                if (prettyPrint) {
                    for (int i = 0; i < indent; ++i) {
                        this.writer.print(' ');
                    }
                }
                this.writer.print("</" + xml.getName() + ">");
                if (prettyPrint) {
                    this.writer.println();
                }
            } else {
                this.writer.print("/>");
                if (prettyPrint) {
                    this.writer.println();
                }
            }
        }
        this.writer.flush();
    }

    private void writeEncoded(String str) {
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    this.writer.print(c);
                    continue block8;
                }
                case '<': {
                    this.writer.print("&lt;");
                    continue block8;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block8;
                }
                case '&': {
                    this.writer.print("&amp;");
                    continue block8;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    continue block8;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        continue block8;
                    }
                    this.writer.print(c);
                }
            }
        }
    }
}

