/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.rmi.RemoteException;
import scala.Collection;
import scala.Collection$class;
import scala.Function1;
import scala.Function1$class;
import scala.Function2;
import scala.Function3;
import scala.Iterable;
import scala.Iterable$class;
import scala.Iterator;
import scala.List;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$class;
import scala.Predef$;
import scala.RandomAccessSeq;
import scala.RandomAccessSeq$class;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.Seq$class;
import scala.Stream;
import scala.StringBuilder;
import scala.Tuple2;
import scala.collection.immutable.Page;
import scala.collection.immutable.PagedSeq$;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedSeq<T>
implements RandomAccessSeq<T>,
ScalaObject {
    private Page current;
    private final int end;
    private final int start;
    private final Page first;
    private final Function3 more;

    public PagedSeq(Function3<T[], int, int, int> more, Page<T> first, int start2, int end) {
        this.more = more;
        this.first = first;
        this.start = start2;
        this.end = end;
        this.current = first;
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        Iterable$class.$init$(this);
        Collection$class.$init$(this);
        Seq$class.$init$(this);
        RandomAccessSeq$class.$init$(this);
    }

    @Override
    public String toString() {
        StringBuilder buf$1 = new StringBuilder();
        this.elements().foreach(new $anonfun$toString$1(this, buf$1));
        return buf$1.toString();
    }

    @Override
    public PagedSeq<T> slice(int start2) {
        return this.slice(start2, PagedSeq$.MODULE$.UndeterminedEnd());
    }

    @Override
    public PagedSeq<T> slice(int _start, int _end) {
        this.page(this.start);
        int s = this.start + _start;
        int e = _end == PagedSeq$.MODULE$.UndeterminedEnd() ? _end : this.start + _end;
        Page f = this.first;
        while (f.end() <= s && !f.isLast()) {
            f = f.next();
        }
        return new PagedSeq(this.more, f, s, e);
    }

    @Override
    public boolean isDefinedAt(int index2) {
        Page p;
        return index2 >= 0 && index2 < this.end - this.start && index2 + this.start < (p = this.page(index2 + this.start)).end();
    }

    @Override
    public T apply(int index2) {
        if (this.isDefinedAt(index2)) {
            return this.page(index2 + this.start).apply(index2 + this.start);
        }
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(index2)).toString());
    }

    @Override
    public int length() {
        while (!this.latest().isLast()) {
            this.addMore();
        }
        return Predef$.MODULE$.intWrapper(this.latest().end()).min(this.end) - this.start;
    }

    private Page page(int absindex) {
        Page page;
        if (absindex < this.current().start()) {
            this.current_$eq(this.first);
        }
        while (absindex >= this.current().end() && (page = this.current().next()) != null && !page.equals(null)) {
            this.current_$eq(this.current().next());
        }
        while (absindex >= this.current().end() && !this.current().isLast()) {
            this.current_$eq(this.addMore());
        }
        return this.current();
    }

    private Page addMore() {
        return this.latest().addMore(this.more);
    }

    private Page latest() {
        return this.first.latest();
    }

    private void current_$eq(Page x$1) {
        this.current = x$1;
    }

    private Page current() {
        return this.current;
    }

    public PagedSeq(Function3<T[], int, int, int> more) {
        this(more, new Page(0), 0, PagedSeq$.MODULE$.UndeterminedEnd());
    }

    @Override
    public int $tag() throws RemoteException {
        return ScalaObject$class.$tag(this);
    }

    @Override
    public Function1 compose(Function1 x$1) {
        return Function1$class.compose(this, x$1);
    }

    @Override
    public PartialFunction andThen(Function1 x$1) {
        return PartialFunction$class.andThen(this, x$1);
    }

    @Override
    public PartialFunction orElse(PartialFunction x$1) {
        return PartialFunction$class.orElse(this, x$1);
    }

    @Override
    public boolean hasDefiniteSize() {
        return Iterable$class.hasDefiniteSize(this);
    }

    public void copyToArray(BoxedArray x$1, int x$2) {
        Iterable$class.copyToArray(this, x$1, x$2);
    }

    @Override
    public StringBuilder addString(StringBuilder x$1) {
        return Iterable$class.addString(this, x$1);
    }

    @Override
    public StringBuilder addString(StringBuilder x$1, String x$2) {
        return Iterable$class.addString(this, x$1, x$2);
    }

    @Override
    public StringBuilder addString(StringBuilder x$1, String x$2, String x$3, String x$4) {
        return Iterable$class.addString(this, x$1, x$2, x$3, x$4);
    }

    @Override
    public String mkString() {
        return Iterable$class.mkString(this);
    }

    @Override
    public String mkString(String x$1) {
        return Iterable$class.mkString(this, x$1);
    }

    @Override
    public String mkString(String x$1, String x$2, String x$3) {
        return Iterable$class.mkString(this, x$1, x$2, x$3);
    }

    @Override
    public List toList() {
        return Iterable$class.toList(this);
    }

    @Override
    public boolean sameElements(Iterable x$1) {
        return Iterable$class.sameElements(this, x$1);
    }

    @Override
    public void copyToBuffer(Buffer x$1) {
        Iterable$class.copyToBuffer(this, x$1);
    }

    @Override
    public Object reduceRight(Function2 x$1) {
        return Iterable$class.reduceRight(this, x$1);
    }

    @Override
    public Object reduceLeft(Function2 x$1) {
        return Iterable$class.reduceLeft(this, x$1);
    }

    @Override
    public Object $colon$bslash(Object x$1, Function2 x$2) {
        return Iterable$class.$colon$bslash(this, x$1, x$2);
    }

    @Override
    public Object $div$colon(Object x$1, Function2 x$2) {
        return Iterable$class.$div$colon(this, x$1, x$2);
    }

    @Override
    public Object foldRight(Object x$1, Function2 x$2) {
        return Iterable$class.foldRight(this, x$1, x$2);
    }

    @Override
    public Object foldLeft(Object x$1, Function2 x$2) {
        return Iterable$class.foldLeft(this, x$1, x$2);
    }

    @Override
    public Option find(Function1 x$1) {
        return Iterable$class.find(this, x$1);
    }

    @Override
    public boolean exists(Function1 x$1) {
        return Iterable$class.exists(this, x$1);
    }

    @Override
    public boolean forall(Function1 x$1) {
        return Iterable$class.forall(this, x$1);
    }

    @Override
    public void foreach(Function1 x$1) {
        Iterable$class.foreach(this, x$1);
    }

    @Override
    public String stringPrefix() {
        return Collection$class.stringPrefix(this);
    }

    @Override
    public boolean containsSlice(Seq x$1) {
        return Seq$class.containsSlice(this, x$1);
    }

    @Override
    public int indexOf(Seq x$1) {
        return Seq$class.indexOf((Seq)this, x$1);
    }

    @Override
    public boolean endsWith(Seq x$1) {
        return Seq$class.endsWith(this, x$1);
    }

    @Override
    public boolean startsWith(Seq x$1) {
        return Seq$class.startsWith(this, x$1);
    }

    @Override
    public boolean equalsWith(Seq x$1, Function2 x$2) {
        return Seq$class.equalsWith(this, x$1, x$2);
    }

    @Override
    public Seq toSeq() {
        return Seq$class.toSeq(this);
    }

    public BoxedArray toArray() {
        return Seq$class.toArray(this);
    }

    @Override
    public Seq subseq(int x$1, int x$2) {
        return Seq$class.subseq(this, x$1, x$2);
    }

    @Override
    public boolean contains(Object x$1) {
        return Seq$class.contains(this, x$1);
    }

    @Override
    public Seq dropWhile(Function1 x$1) {
        return Seq$class.dropWhile(this, x$1);
    }

    @Override
    public Seq takeWhile(Function1 x$1) {
        return Seq$class.takeWhile(this, x$1);
    }

    @Override
    public Seq filter(Function1 x$1) {
        return Seq$class.filter(this, x$1);
    }

    @Override
    public Seq flatMap(Function1 x$1) {
        return Seq$class.flatMap(this, x$1);
    }

    @Override
    public Seq map(Function1 x$1) {
        return Seq$class.map(this, x$1);
    }

    @Override
    public int indexOf(Object x$1) {
        return Seq$class.indexOf((Seq)this, x$1);
    }

    @Override
    public int findIndexOf(Function1 x$1) {
        return Seq$class.findIndexOf(this, x$1);
    }

    @Override
    public int lastIndexOf(Object x$1) {
        return Seq$class.lastIndexOf(this, x$1);
    }

    @Override
    public Option headOption() {
        return Seq$class.headOption(this);
    }

    @Override
    public Option firstOption() {
        return Seq$class.firstOption(this);
    }

    @Override
    public Object first() {
        return Seq$class.first(this);
    }

    @Override
    public Option lastOption() {
        return Seq$class.lastOption(this);
    }

    @Override
    public Object last() {
        return Seq$class.last(this);
    }

    @Override
    public Seq concat(Iterable x$1) {
        return Seq$class.concat(this, x$1);
    }

    @Override
    public boolean isEmpty() {
        return Seq$class.isEmpty(this);
    }

    @Override
    public int size() {
        return Seq$class.size(this);
    }

    @Override
    public int lengthCompare(int x$1) {
        return Seq$class.lengthCompare(this, x$1);
    }

    @Override
    public final Collection scala$Seq$$super$dropWhile(Function1 x$1) {
        return Iterable$class.dropWhile(this, x$1);
    }

    @Override
    public final Iterable scala$Seq$$super$takeWhile(Function1 x$1) {
        return Iterable$class.takeWhile(this, x$1);
    }

    @Override
    public final Iterable scala$Seq$$super$filter(Function1 x$1) {
        return Iterable$class.filter(this, x$1);
    }

    @Override
    public final boolean safeIs(int x$1, Object x$2) {
        return RandomAccessSeq$class.safeIs(this, x$1, x$2);
    }

    @Override
    public Stream toStream() {
        return RandomAccessSeq$class.toStream(this);
    }

    @Override
    public RandomAccessSeq $plus$plus(Iterable x$1) {
        return RandomAccessSeq$class.$plus$plus(this, x$1);
    }

    @Override
    public RandomAccessSeq.Projection patch(int x$1, RandomAccessSeq x$2, int x$3) {
        return RandomAccessSeq$class.patch(this, x$1, x$2, x$3);
    }

    @Override
    public Tuple2 partition(Function1 x$1) {
        return RandomAccessSeq$class.partition(this, x$1);
    }

    @Override
    public Seq reverse() {
        return RandomAccessSeq$class.reverse(this);
    }

    @Override
    public RandomAccessSeq take(int x$1) {
        return RandomAccessSeq$class.take(this, x$1);
    }

    @Override
    public RandomAccessSeq drop(int x$1) {
        return RandomAccessSeq$class.drop(this, x$1);
    }

    @Override
    public Iterator elements() {
        return RandomAccessSeq$class.elements(this);
    }

    @Override
    public RandomAccessSeq.Projection projection() {
        return RandomAccessSeq$class.projection(this);
    }
}

