/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.ScalaObject;
import scala.StringBuilder;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesRunTime;

public abstract class ExactNumeric
extends Numeric
implements ScalaObject {
    private final int nativeTypeId;

    public ExactNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }

    public String sqlString() {
        String string;
        int tp1 = this.precisionRadix();
        int tp2 = this.precision();
        int tp3 = this.scale();
        block0 : switch (tp1) {
            default: {
                throw new UnsupportedFeature("SQL-99 does not support the precision of an exact numeric type to be defined in a radix other than 2 or 10");
            }
            case 2: {
                switch (tp2) {
                    default: {
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    case 16: {
                        if (tp3 == 0) {
                            string = "SMALLINT";
                            break block0;
                        }
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    case 32: {
                        if (tp3 == 0) {
                            string = "INTEGER";
                            break block0;
                        }
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    case 64: {
                        if (tp3 == 0) {
                            string = "BIGINT";
                            break block0;
                        }
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    case 0x7FFFFFFF: 
                }
                if (tp3 == 0) {
                    string = "BIGINT";
                    break;
                }
                throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
            }
            case 10: {
                string = tp3 == 0 ? new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger((int)tp2)).toString()).append((Object)")").toString() : new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger((int)tp2)).toString()).append((Object)", ").append((Object)((Object)BoxesRunTime.boxToInteger((int)tp3)).toString()).append((Object)")").toString();
            }
        }
        return string;
    }

    public abstract int scale();

    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.scale() <= dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.scale() == dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

