/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple2;
import scala.concurrent.ops$;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.tools.nsc.GenericRunnerSettings;
import scala.tools.nsc.Interpreter;
import scala.tools.nsc.InterpreterCommand;
import scala.tools.nsc.InterpreterLoop$;
import scala.tools.nsc.InterpreterResults;
import scala.tools.nsc.InterpreterResults$Error$;
import scala.tools.nsc.InterpreterResults$Incomplete$;
import scala.tools.nsc.InterpreterResults$Success$;
import scala.tools.nsc.InterpreterSettings;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.InteractiveReader;
import scala.tools.nsc.interpreter.InteractiveReader$;
import scala.tools.nsc.interpreter.SimpleReader;

public class InterpreterLoop
implements ScalaObject {
    private final String prompt;
    private ClassLoader uglinessxxx;
    private List replayCommandsRev;
    private Interpreter interpreter;
    private Settings settings;
    private final ClassLoader originalClassLoader;
    private InteractiveReader in;
    public final PrintWriter scala$tools$nsc$InterpreterLoop$$out;
    private final Option in0;

    public InterpreterLoop(Option in0, PrintWriter out) {
        this.in0 = in0;
        this.scala$tools$nsc$InterpreterLoop$$out = out;
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.interpreter = null;
        this.replayCommandsRev = Nil$.MODULE$;
        this.prompt = Properties$.MODULE$.shellPromptString();
    }

    public final void error1$1(String msg) {
        this.scala$tools$nsc$InterpreterLoop$$out.println(new StringBuilder().append((Object)"scala: ").append((Object)msg).toString());
    }

    private final void withFile$1(String command2, Function1 action) {
        int spaceIdx = command2.indexOf(32);
        if (spaceIdx <= 0) {
            this.scala$tools$nsc$InterpreterLoop$$out.println("That command requires a filename to be specified.");
            return;
        }
        String filename = command2.substring(spaceIdx).trim();
        if (new File(filename).exists()) {
            action.apply(filename);
            return;
        }
        this.scala$tools$nsc$InterpreterLoop$$out.println("That file does not exist");
    }

    public void main(String[] args) {
        InterpreterCommand command2 = new InterpreterCommand(List$.MODULE$.fromArray(new BoxedObjectArray(args)), new $anonfun$2(this));
        if (command2.ok() && !command2.settings().help().value() && !command2.settings().Xhelp().value()) {
            this.main(command2.settings());
        } else {
            if (command2.settings().help().value()) {
                this.scala$tools$nsc$InterpreterLoop$$out.println(command2.usageMsg());
            }
            if (command2.settings().Xhelp().value()) {
                this.scala$tools$nsc$InterpreterLoop$$out.println(command2.xusageMsg());
            }
            this.scala$tools$nsc$InterpreterLoop$$out.flush();
        }
    }

    public void main(Settings settings) {
        Option option;
        block8: {
            InteractiveReader interactiveReader;
            block7: {
                block6: {
                    this.settings_$eq(settings);
                    option = this.in0;
                    if (!(option instanceof Some)) break block6;
                    interactiveReader = new SimpleReader((BufferedReader)((Some)option).x(), this.scala$tools$nsc$InterpreterLoop$$out, true);
                    break block7;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                String string = System.getProperty("env.emacs", "");
                String string2 = "";
                boolean emacsShell = string != null ? !string.equals(string2) : string2 != null;
                interactiveReader = settings.Xnojline().value() || emacsShell ? new SimpleReader() : InteractiveReader$.MODULE$.createDefault();
            }
            this.in_$eq(interactiveReader);
            this.uglinessxxx_$eq(InterpreterLoop.class.getClassLoader());
            this.createInterpreter();
            this.loadFiles(settings);
            try {
                if (this.interpreter().reporter().hasErrors()) {
                    this.closeInterpreter();
                    return;
                }
                this.printWelcome();
                this.repl();
                this.closeInterpreter();
                return;
            }
            catch (Throwable throwable) {
                this.closeInterpreter();
                throw throwable;
            }
        }
        throw new MatchError(option);
    }

    public void loadFiles(Settings settings) {
        Settings settings2 = settings;
        if (settings2 instanceof GenericRunnerSettings) {
            ((GenericRunnerSettings)settings2).loadfiles().value().foreach(new $anonfun$loadFiles$1(this));
        }
    }

    public Option interpretStartingWith(String code) {
        InterpreterResults.Result result;
        block8: {
            Option option;
            block6: {
                block7: {
                    block5: {
                        result = this.interpreter().interpret(code);
                        InterpreterResults$Success$ interpreterResults$Success$ = InterpreterResults$Success$.MODULE$;
                        InterpreterResults.Result result2 = result;
                        if (interpreterResults$Success$ != null ? !interpreterResults$Success$.equals(result2) : result2 != null) break block5;
                        option = new Some(code);
                        break block6;
                    }
                    InterpreterResults$Error$ interpreterResults$Error$ = InterpreterResults$Error$.MODULE$;
                    InterpreterResults.Result result3 = result;
                    if (interpreterResults$Error$ != null ? !interpreterResults$Error$.equals(result3) : result3 != null) break block7;
                    option = None$.MODULE$;
                    break block6;
                }
                InterpreterResults$Incomplete$ interpreterResults$Incomplete$ = InterpreterResults$Incomplete$.MODULE$;
                InterpreterResults.Result result4 = result;
                if (interpreterResults$Incomplete$ != null ? !interpreterResults$Incomplete$.equals(result4) : result4 != null) break block8;
                if (this.in().interactive() && code.endsWith("\n\n")) {
                    this.scala$tools$nsc$InterpreterLoop$$out.println("You typed two blank lines.  Starting a new command.");
                    option = None$.MODULE$;
                } else {
                    String nextLine = this.in().readLine("     | ");
                    String string = nextLine;
                    option = string == null || string.equals(null) ? None$.MODULE$ : this.interpretStartingWith(new StringBuilder().append((Object)code).append((Object)"\n").append((Object)nextLine).toString());
                }
            }
            return option;
        }
        throw new MatchError(result);
    }

    public Tuple2 command(String line$1) {
        String helpRegexp = ":h(e(l(p)?)?)?";
        String quitRegexp = ":q(u(i(t)?)?)?";
        String loadRegexp = ":l(o(a(d)?)?)?.*";
        String replayRegexp = ":r(e(p(l(a(y)?)?)?)?)?.*";
        ObjectRef shouldReplay$1 = new ObjectRef(None$.MODULE$);
        if (line$1.matches(helpRegexp)) {
            this.printHelp();
        } else {
            if (line$1.matches(quitRegexp)) {
                return new Tuple2(BoxesRunTime.boxToBoolean(false), None$.MODULE$);
            }
            if (line$1.matches(loadRegexp)) {
                this.withFile$1(line$1, new $anonfun$command$1(this, line$1, shouldReplay$1));
            } else if (line$1.matches(replayRegexp)) {
                this.replay();
            } else if (line$1.startsWith(":")) {
                this.scala$tools$nsc$InterpreterLoop$$out.println("Unknown command.  Type :help for help.");
            } else {
                shouldReplay$1.elem = this.interpretStartingWith(line$1);
            }
        }
        return new Tuple2(BoxesRunTime.boxToBoolean(true), (Option)shouldReplay$1.elem);
    }

    public void replay() {
        this.closeInterpreter();
        this.createInterpreter();
        this.replayCommands().foreach(new $anonfun$replay$1(this));
    }

    public void interpretAllFrom(String filename) {
        List oldReplay;
        InteractiveReader oldIn;
        FileReader fileIn;
        FileReader exceptionResult1 = null;
        try {
            fileIn = exceptionResult1 = new FileReader(filename);
            oldIn = this.in();
            oldReplay = this.replayCommandsRev();
        }
        catch (IOException iOException) {
            this.scala$tools$nsc$InterpreterLoop$$out.println(new StringBuilder().append((Object)"Error opening file: ").append((Object)filename).toString());
            return;
        }
        try {
            BufferedReader inFile = new BufferedReader(fileIn);
            this.in_$eq(new SimpleReader(inFile, this.scala$tools$nsc$InterpreterLoop$$out, false));
            this.scala$tools$nsc$InterpreterLoop$$out.println(new StringBuilder().append((Object)"Loading ").append((Object)filename).append((Object)"...").toString());
            this.scala$tools$nsc$InterpreterLoop$$out.flush();
            this.repl();
            this.in_$eq(oldIn);
            this.replayCommandsRev_$eq(oldReplay);
            fileIn.close();
            return;
        }
        catch (Throwable throwable) {
            this.in_$eq(oldIn);
            this.replayCommandsRev_$eq(oldReplay);
            fileIn.close();
            throw throwable;
        }
    }

    public void repl() {
        block6: {
            Option option;
            boolean first = true;
            while (true) {
                String line;
                String string;
                this.scala$tools$nsc$InterpreterLoop$$out.flush();
                if (first) {
                    Function0 futLine = ops$.MODULE$.future(new $anonfun$1(this));
                    this.bindSettings();
                    first = false;
                    string = (String)futLine.apply();
                } else {
                    string = line = this.in().readLine(this.prompt());
                }
                if (line == null) {
                    return;
                }
                Tuple2 tuple2 = this.command(line);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                boolean keepGoing = BoxesRunTime.unboxToBoolean(tuple22._1());
                Option finalLineMaybe = (Option)tuple22._2();
                if (!keepGoing) break block6;
                option = finalLineMaybe;
                if (option instanceof Some) {
                    this.addReplay((String)((Some)option).x());
                    continue;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ == null ? option2 != null : !none$.equals(option2)) break;
            }
            throw new MatchError(option);
        }
    }

    public String prompt() {
        return this.prompt;
    }

    public void printWelcome() {
        this.scala$tools$nsc$InterpreterLoop$$out.println(new StringBuilder().append((Object)"Welcome to Scala ").append((Object)Properties$.MODULE$.versionString()).append((Object)" (").append((Object)System.getProperty("java.vm.name")).append((Object)", Java ").append((Object)System.getProperty("java.version")).append((Object)").").toString());
        this.scala$tools$nsc$InterpreterLoop$$out.println("Type in expressions to have them evaluated.");
        this.scala$tools$nsc$InterpreterLoop$$out.println("Type :help for more information.");
        this.scala$tools$nsc$InterpreterLoop$$out.flush();
    }

    public void printHelp() {
        this.printWelcome();
        this.scala$tools$nsc$InterpreterLoop$$out.println("Type :load followed by a filename to load a Scala file.");
        this.scala$tools$nsc$InterpreterLoop$$out.println("Type :replay to reset execution and replay all previous commands.");
        this.scala$tools$nsc$InterpreterLoop$$out.println("Type :quit to exit the interpreter.");
    }

    public void bindSettings() {
        this.interpreter().beQuietDuring(new $anonfun$bindSettings$1(this));
    }

    public void createInterpreter() {
        this.interpreter_$eq(new $anon$1(this));
        this.interpreter().setContextClassLoader();
    }

    public ClassLoader parentClassLoader0() {
        return this.uglinessxxx();
    }

    public void uglinessxxx_$eq(ClassLoader x$1) {
        this.uglinessxxx = x$1;
    }

    public ClassLoader uglinessxxx() {
        return this.uglinessxxx;
    }

    public void closeInterpreter() {
        if (this.interpreter() != null) {
            this.interpreter().close();
            this.interpreter_$eq(null);
            Thread.currentThread().setContextClassLoader(this.originalClassLoader());
        }
    }

    public void addReplay(String cmd) {
        String string = cmd;
        this.replayCommandsRev_$eq(this.replayCommandsRev().$colon$colon(string));
    }

    public List replayCommands() {
        return this.replayCommandsRev().reverse();
    }

    public void replayCommandsRev_$eq(List x$1) {
        this.replayCommandsRev = x$1;
    }

    public List replayCommandsRev() {
        return this.replayCommandsRev;
    }

    public InterpreterSettings isettings() {
        return this.interpreter().isettings();
    }

    public void interpreter_$eq(Interpreter x$1) {
        this.interpreter = x$1;
    }

    public Interpreter interpreter() {
        return this.interpreter;
    }

    public void settings_$eq(Settings x$1) {
        this.settings = x$1;
    }

    public Settings settings() {
        return this.settings;
    }

    public ClassLoader originalClassLoader() {
        return this.originalClassLoader;
    }

    public void in_$eq(InteractiveReader x$1) {
        this.in = x$1;
    }

    public InteractiveReader in() {
        return this.in;
    }

    public InterpreterLoop() {
        this(None$.MODULE$, new PrintWriter(Console$.MODULE$.out()));
    }

    public InterpreterLoop(BufferedReader in0, PrintWriter out) {
        this(new Some(in0), out);
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

