/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Iterator;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxedAnyArray;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;

public abstract class HashTable$class {
    public static void $init$(HashTable $this) {
        $this.initialThreshold_$eq(HashTable$class.newThreshold($this, $this.initialSize()));
        $this.table_$eq((BoxedArray)($this.initialSize() == 0 ? null : new BoxedAnyArray($this.initialSize())));
        $this.tableSize_$eq(0);
        $this.threshold_$eq($this.initialThreshold());
    }

    public static final int index(HashTable $this, int hcode) {
        return $this.improve(hcode) & $this.table().length() - 1;
    }

    public static final int improve(HashTable $this, int hcode) {
        int h = hcode + ~(hcode << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public static int elemHashCode(HashTable $this, Object key) {
        return key.hashCode();
    }

    public static boolean elemEquals(HashTable $this, Object key1, Object key2) {
        return BoxesRunTime.equals(key1, key2);
    }

    private static void resize(HashTable $this, int newSize) {
        BoxedArray oldTable = $this.table();
        $this.table_$eq(new BoxedAnyArray(newSize));
        block0: for (int i = oldTable.length() - 1; i >= 0; --i) {
            HashEntry e = (HashEntry)oldTable.apply(i);
            while (true) {
                HashEntry hashEntry;
                if ((hashEntry = e) == null || hashEntry.equals(null)) {
                    continue block0;
                }
                int h = $this.index($this.elemHashCode(e.key()));
                HashEntry e1 = (HashEntry)e.next();
                e.next_$eq($this.table().apply(h));
                $this.table().update(h, e);
                e = e1;
            }
        }
        $this.threshold_$eq(HashTable$class.newThreshold($this, newSize));
    }

    private static int newThreshold(HashTable $this, int size2) {
        return (int)((long)size2 * (long)$this.loadFactor() / 1000L);
    }

    public static void clear(HashTable $this) {
        for (int i = $this.table().length() - 1; i >= 0; --i) {
            $this.table().update(i, null);
        }
        $this.tableSize_$eq(0);
    }

    public static Iterator entries(HashTable $this) {
        return new HashTable$.anon.1($this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Option removeEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = (HashEntry)$this.table().apply(h);
        HashEntry hashEntry = e;
        if (hashEntry == null || hashEntry.equals(null)) return None$.MODULE$;
        if ($this.elemEquals(e.key(), key)) {
            $this.table().update(h, e.next());
            $this.tableSize_$eq($this.tableSize() - 1);
            return new Some(e);
        }
        HashEntry e1 = (HashEntry)e.next();
        while (true) {
            HashEntry hashEntry2;
            if ((hashEntry2 = e1) == null || hashEntry2.equals(null) || $this.elemEquals(e1.key(), key)) {
                HashEntry hashEntry3 = e1;
                if (hashEntry3 == null || hashEntry3.equals(null)) {
                    return None$.MODULE$;
                }
                e.next_$eq(e1.next());
                $this.tableSize_$eq($this.tableSize() - 1);
                return new Some(e1);
            }
            e = e1;
            e1 = (HashEntry)e1.next();
        }
    }

    public static void addEntry(HashTable $this, HashEntry e) {
        int h = $this.index($this.elemHashCode(e.key()));
        e.next_$eq($this.table().apply(h));
        $this.table().update(h, e);
        $this.tableSize_$eq($this.tableSize() + 1);
        if ($this.tableSize() > $this.threshold()) {
            HashTable$class.resize($this, 2 * $this.table().length());
        }
    }

    public static HashEntry findEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = (HashEntry)$this.table().apply(h);
        HashEntry hashEntry;
        while ((hashEntry = e) != null && !hashEntry.equals(null) && !$this.elemEquals(e.key(), key)) {
            e = (HashEntry)e.next();
        }
        return e;
    }

    public static int size(HashTable $this) {
        return $this.tableSize();
    }

    public static int initialSize(HashTable $this) {
        return 16;
    }

    public static int loadFactor(HashTable $this) {
        return 750;
    }
}

