/*
 * Decompiled with CFR 0.152.
 */
package scala;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import scala.Function1;
import scala.Function1$class;
import scala.Math$;
import scala.Proxy;
import scala.Proxy$class;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.StringBuilder$;
import scala.compat.Platform$;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StringBuilder
implements Function1,
Proxy,
ScalaObject {
    public static final long serialVersionUID = -8525408645367278351L;
    private int count;
    private char[] value;
    private final String initValue;

    public StringBuilder(int initCapacity, String initValue) {
        this.initValue = initValue;
        Function1$class.$init$(this);
        Proxy$class.$init$(this);
        if (initCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initValue == null) {
            throw new NullPointerException();
        }
        this.value = new char[initCapacity + initValue.length()];
        this.count = 0;
        this.append(initValue);
    }

    private void readObject(ObjectInputStream s) throws IOException {
        s.defaultReadObject();
        this.count_$eq(s.readInt());
        Object object = s.readObject();
        this.value_$eq((char[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Character.TYPE) : object));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.count());
        s.writeObject(this.value());
    }

    public String toString() {
        return new String(this.value(), 0, this.count());
    }

    public StringBuilder reverse() {
        boolean hasSurrogate = false;
        int n = this.count() - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.value()[j];
            char temp2 = this.value()[n - j];
            if (!hasSurrogate) {
                hasSurrogate = temp >= StringBuilder$.MODULE$.scala$StringBuilder$$MIN_SURROGATE() && temp <= StringBuilder$.MODULE$.scala$StringBuilder$$MAX_SURROGATE() || temp2 >= StringBuilder$.MODULE$.scala$StringBuilder$$MIN_SURROGATE() && temp2 <= StringBuilder$.MODULE$.scala$StringBuilder$$MAX_SURROGATE();
            }
            this.value()[j] = temp2;
            this.value()[n - j] = temp;
        }
        if (hasSurrogate) {
            for (int i = 0; i < this.count() - 1; ++i) {
                char c1;
                char c2 = this.value()[i];
                if (!StringBuilder$.MODULE$.scala$StringBuilder$$isLowSurrogate(c2) || !StringBuilder$.MODULE$.scala$StringBuilder$$isHighSurrogate(c1 = this.value()[i + 1])) continue;
                this.value()[i] = c1;
                this.value()[++i] = c2;
            }
        }
        return this;
    }

    public int lastIndexOf(String str, int fromIndex) {
        return StringBuilder$.MODULE$.scala$StringBuilder$$lastIndexOf(this.value(), 0, this.count(), str.toCharArray(), 0, str.length(), fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count());
    }

    public int indexOf(String str, int fromIndex) {
        return StringBuilder$.MODULE$.scala$StringBuilder$$indexOf(this.value(), 0, this.count(), str.toCharArray(), 0, str.length(), fromIndex);
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public StringBuilder insert(int at, double x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, float x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, long x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, int x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, short x) {
        return this.insert(at, String.valueOf(BoxesRunTime.boxToShort(x)));
    }

    public StringBuilder insert(int at, char x) {
        if (at < 0 || at > this.count()) {
            throw new StringIndexOutOfBoundsException(at);
        }
        int newCount = this.count() + 1;
        if (newCount > this.value().length) {
            this.expandCapacity(newCount);
        }
        Platform$.MODULE$.arraycopy(this.value(), at, this.value(), at + 1, this.count() - at);
        this.value()[at] = x;
        this.count_$eq(newCount);
        return this;
    }

    public StringBuilder insert(int at, byte x) {
        return this.insert(at, String.valueOf(BoxesRunTime.boxToByte(x)));
    }

    public StringBuilder insert(int at, boolean x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int at, char[] x) {
        if (at < 0 || at > this.count()) {
            throw new StringIndexOutOfBoundsException(at);
        }
        int len = x.length;
        int newCount = this.count() + len;
        if (newCount > this.value().length) {
            this.expandCapacity(newCount);
        }
        Platform$.MODULE$.arraycopy(this.value(), at, this.value(), at + len, this.count() - at);
        Platform$.MODULE$.arraycopy(x, 0, this.value(), at, len);
        this.count_$eq(newCount);
        return this;
    }

    public StringBuilder insert(int at, Seq x) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(x.toArray(), Character.TYPE);
        return this.insert(at, (char[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Character.TYPE) : object));
    }

    public StringBuilder insert(int at, String x) {
        if (at < 0 || at > this.count()) {
            throw new StringIndexOutOfBoundsException(at);
        }
        String string2 = x;
        String str = string2 == null || string2.equals(null) ? "null" : x;
        int len = str.length();
        int newCount = this.count() + len;
        if (newCount > this.value().length) {
            this.expandCapacity(newCount);
        }
        Platform$.MODULE$.arraycopy(this.value(), at, this.value(), at + len, this.count() - at);
        Platform$.MODULE$.arraycopy(str.toCharArray(), 0, this.value(), at, len);
        this.count_$eq(newCount);
        return this;
    }

    public StringBuilder insert(int at, Object x) {
        return this.insert(at, String.valueOf(x));
    }

    public StringBuilder insert(int index2, char[] str, int offset, int len) {
        if (index2 < 0 || index2 > this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        if (offset < 0 || len < 0 || offset > str.length - len) {
            throw new StringIndexOutOfBoundsException(new StringBuilder().append((Object)"offset ").append(BoxesRunTime.boxToInteger(offset)).append((Object)", len ").append(BoxesRunTime.boxToInteger(len)).append((Object)", str.length ").append(BoxesRunTime.boxToInteger(str.length)).toString());
        }
        int newCount = this.count() + len;
        if (newCount > this.value().length) {
            this.expandCapacity(newCount);
        }
        Platform$.MODULE$.arraycopy(this.value(), index2, this.value(), index2 + len, this.count() - index2);
        Platform$.MODULE$.arraycopy(str, offset, this.value(), index2, len);
        this.count_$eq(newCount);
        return this;
    }

    public void replace(int start, int end, String str) {
        if (start < 0 || start > this.count() || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int end0 = end > this.count() ? this.count() : end;
        int len = str.length();
        int newCount = this.count() + len - (end0 - start);
        if (newCount > this.value().length) {
            this.expandCapacity(newCount);
        }
        Platform$.MODULE$.arraycopy(this.value(), end, this.value(), start + len, this.count() - end);
        Platform$.MODULE$.arraycopy(str.toCharArray(), 0, this.value(), start, len);
        this.count_$eq(newCount);
    }

    public StringBuilder delete(int start, int end) {
        if (start < 0 || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int end0 = end > this.count() ? this.count() : end;
        int len = end0 - start;
        if (len > 0) {
            Platform$.MODULE$.arraycopy(this.value(), start + len, this.value(), start, this.count() - end0);
            this.count_$eq(this.count() - len);
        }
        return this;
    }

    public StringBuilder append(double x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(float x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(long x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(int x) {
        return this.append(String.valueOf(x));
    }

    public StringBuilder append(short x) {
        return this.append(String.valueOf(BoxesRunTime.boxToShort(x)));
    }

    public StringBuilder append(char x) {
        int newCount = this.count() + 1;
        if (newCount > this.value().length) {
            this.expandCapacity(newCount);
        }
        this.value()[this.count()] = x;
        this.count_$eq(this.count() + 1);
        return this;
    }

    public StringBuilder append(byte x) {
        return this.append(String.valueOf(BoxesRunTime.boxToByte(x)));
    }

    public StringBuilder append(boolean x) {
        if (x) {
            int newCount = this.count() + 4;
            if (newCount > this.value().length) {
                this.expandCapacity(newCount);
            }
            this.value()[this.count()] = 116;
            this.count_$eq(this.count() + 1);
            this.value()[this.count()] = 114;
            this.count_$eq(this.count() + 1);
            this.value()[this.count()] = 117;
            this.count_$eq(this.count() + 1);
            this.value()[this.count()] = 101;
            this.count_$eq(this.count() + 1);
        } else {
            int newCount = this.count() + 5;
            if (newCount > this.value().length) {
                this.expandCapacity(newCount);
            }
            this.value()[this.count()] = 102;
            this.count_$eq(this.count() + 1);
            this.value()[this.count()] = 97;
            this.count_$eq(this.count() + 1);
            this.value()[this.count()] = 108;
            this.count_$eq(this.count() + 1);
            this.value()[this.count()] = 115;
            this.count_$eq(this.count() + 1);
            this.value()[this.count()] = 101;
            this.count_$eq(this.count() + 1);
        }
        return this;
    }

    public StringBuilder append(char[] x, int offset, int len) {
        int newCount = this.count() + len;
        if (newCount > this.value().length) {
            this.expandCapacity(newCount);
        }
        Platform$.MODULE$.arraycopy(x, offset, this.value(), this.count(), len);
        this.count_$eq(newCount);
        return this;
    }

    public StringBuilder append(char[] x) {
        return this.append(x, 0, x.length);
    }

    public StringBuilder append(Seq x) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(x.toArray(), Character.TYPE);
        return this.append((char[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Character.TYPE) : object), 0, x.length());
    }

    public StringBuilder append(StringBuilder sb) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = sb;
        if (stringBuilder2 == null || ((Object)stringBuilder2).equals(null)) {
            stringBuilder = this.append("null");
        } else {
            int len = sb.length();
            int newCount = this.count() + len;
            if (newCount > this.value().length) {
                this.expandCapacity(newCount);
            }
            Platform$.MODULE$.arraycopy(sb.toArray(), 0, this.value(), this.count(), len);
            this.count_$eq(newCount);
            stringBuilder = this;
        }
        return stringBuilder;
    }

    public StringBuilder append(String s) {
        String string2 = s;
        String str = string2 == null || string2.equals(null) ? "null" : s;
        int len = str.length();
        if (len > 0) {
            int newCount = this.count() + len;
            if (newCount > this.value().length) {
                this.expandCapacity(newCount);
            }
            Platform$.MODULE$.arraycopy(str.toCharArray(), 0, this.value(), this.count(), len);
            this.count_$eq(newCount);
        }
        return this;
    }

    public StringBuilder append(Object x) {
        return this.append(String.valueOf(x));
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count()) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.value(), start, end - start);
    }

    public String substring(int start) {
        return this.substring(start, this.count());
    }

    public void update(int i, char c) {
        this.setCharAt(i, c);
    }

    public void setCharAt(int index2, char ch) {
        if (index2 < 0 || index2 >= this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        this.value()[index2] = ch;
    }

    public StringBuilder deleteCharAt(int index2) {
        if (index2 < 0 || index2 >= this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        Platform$.MODULE$.arraycopy(this.value(), index2 + 1, this.value(), index2, this.count() - index2 - 1);
        this.count_$eq(this.count() - 1);
        return this;
    }

    public char apply(int i) {
        return this.charAt(i);
    }

    public char charAt(int index2) {
        if (index2 < 0 || index2 >= this.count()) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        return this.value()[index2];
    }

    private void expandCapacity(int n) {
        int newCapacity = (this.value().length + 1) * 2;
        this.value_$eq(StringBuilder$.MODULE$.scala$StringBuilder$$copyOf(this.value(), newCapacity < 0 ? Math$.MODULE$.MAX_INT() : (n > newCapacity ? n : newCapacity)));
    }

    public void ensureCapacity(int n) {
        if (n > this.value().length) {
            this.expandCapacity(n);
        }
    }

    public void capacity_$eq(int n) {
        this.ensureCapacity(n);
    }

    public int capacity() {
        return this.value().length;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.value().length) {
            this.expandCapacity(n);
        }
        if (this.count() < n) {
            while (this.count() < n) {
                this.value()[this.count()] = '\u0000';
                this.count_$eq(this.count() + 1);
            }
        } else {
            this.count_$eq(n);
        }
    }

    public void length_$eq(int n) {
        this.setLength(n);
    }

    public int length() {
        return this.count();
    }

    public char[] toArray() {
        return this.value();
    }

    public StringBuilder self() {
        return this;
    }

    public StringBuilder(String str) {
        this(16, str);
    }

    public StringBuilder(int capacity) {
        this(capacity, "");
    }

    public StringBuilder() {
        this(16, "");
    }

    private void count_$eq(int x$1) {
        this.count = x$1;
    }

    private int count() {
        return this.count;
    }

    private void value_$eq(char[] x$1) {
        this.value = x$1;
    }

    private char[] value() {
        return this.value;
    }

    private String initValue() {
        return this.initValue;
    }

    public int $tag() throws RemoteException {
        return ScalaObject$class.$tag(this);
    }

    public Function1 andThen(Function1 x$1) {
        return Function1$class.andThen(this, x$1);
    }

    public Function1 compose(Function1 x$1) {
        return Function1$class.compose(this, x$1);
    }

    public boolean equals(Object x$1) {
        return Proxy$class.equals(this, x$1);
    }

    public int hashCode() {
        return Proxy$class.hashCode(this);
    }
}

