/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import java.io.File;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.StringBuilder;
import scala.tools.nsc.Settings;
import scala.tools.partest.nest.FileManager;

public class TestFile
implements ScalaObject {
    private final String fileBase;
    private final String dirpath;
    private final File dir;
    private final FileManager fileManager;
    private final File file;
    private final String kind;

    public TestFile(String kind, File file, FileManager fileManager) {
        this.kind = kind;
        this.file = file;
        this.fileManager = fileManager;
        this.dir = file.getParentFile();
        this.dirpath = this.dir().getAbsolutePath();
        this.fileBase = this.basename(file.getName());
    }

    public String toString() {
        return new StringBuilder().append((Object)this.kind).append((Object)" ").append(this.file()).toString();
    }

    private String basename(String name) {
        int inx = name.lastIndexOf(".");
        return inx < 0 ? name : name.substring(0, inx);
    }

    public void defineSettings(Settings settings) {
        this.baseSettings(settings);
    }

    public void baseSettings(Settings settings) {
        settings.classpath().value_$eq(this.dirpath());
        Settings.StringSetting stringSetting = settings.outdir();
        File outDir = new File(this.dir(), new StringBuilder().append((Object)this.fileBase()).append((Object)"-").append((Object)this.kind).append((Object)".obj").toString());
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        stringSetting.value_$eq(outDir.toString());
    }

    public String fileBase() {
        return this.fileBase;
    }

    public String dirpath() {
        return this.dirpath;
    }

    public File dir() {
        return this.dir;
    }

    public FileManager fileManager() {
        return this.fileManager;
    }

    public File file() {
        return this.file;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

