/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import java.io.File;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.StringBuilder;
import scala.tools.partest.nest.DirectCompiler;
import scala.tools.partest.nest.FileManager;
import scala.tools.partest.nest.NestUI$;
import scala.tools.partest.nest.SimpleCompiler;

public class CompileManager
implements ScalaObject {
    private int numSeparateCompilers;
    private SimpleCompiler compiler;
    private final FileManager fileManager;

    public CompileManager(FileManager fileManager) {
        this.fileManager = fileManager;
        this.compiler = new DirectCompiler(fileManager);
        this.numSeparateCompilers = 1;
    }

    public boolean shouldFailCompile(File file, String kind, File log) {
        this.createSeparateCompiler();
        boolean exceptionResult4 = false;
        try {
            exceptionResult4 = !this.compiler().compile(file, kind, log);
        }
        catch (Throwable throwable) {
            NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"while invoking compiler (").append(file).append((Object)"):").toString());
            NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"caught ").append(throwable).toString());
            throwable.printStackTrace();
            throwable.getCause().printStackTrace();
            exceptionResult4 = false;
        }
        return exceptionResult4;
    }

    public boolean shouldCompile(File file, String kind, File log) {
        this.createSeparateCompiler();
        boolean exceptionResult3 = false;
        try {
            exceptionResult3 = this.compiler().compile(file, kind, log);
        }
        catch (Throwable throwable) {
            NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"while invoking compiler (").append(file).append((Object)"):").toString());
            NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"caught ").append(throwable).toString());
            throwable.printStackTrace();
            throwable.getCause().printStackTrace();
            exceptionResult3 = false;
        }
        return exceptionResult3;
    }

    public void createSeparateCompiler() {
        this.numSeparateCompilers_$eq(this.numSeparateCompilers() + 1);
        this.compiler_$eq(new DirectCompiler(this.fileManager()));
    }

    public void numSeparateCompilers_$eq(int x$1) {
        this.numSeparateCompilers = x$1;
    }

    public int numSeparateCompilers() {
        return this.numSeparateCompilers;
    }

    public void compiler_$eq(SimpleCompiler x$1) {
        this.compiler = x$1;
    }

    public SimpleCompiler compiler() {
        return this.compiler;
    }

    public FileManager fileManager() {
        return this.fileManager;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

