/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.actors.Debug$;
import scala.actors.remote.JavaSerializer;
import scala.actors.remote.NetKernel;
import scala.actors.remote.Node;
import scala.actors.remote.Serializer;
import scala.actors.remote.Service;
import scala.actors.remote.Service$class;
import scala.actors.remote.TcpService$;
import scala.actors.remote.TcpServiceWorker;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TcpService
extends Thread
implements Service,
ScalaObject {
    private final NetKernel kernel;
    private final HashMap connections;
    private boolean shouldTerminate;
    private final HashMap pendingSends;
    private final Node internalNode;
    private final JavaSerializer serializer;
    private final int port;

    public TcpService(int port) {
        this.port = port;
        Service$class.$init$(this);
        this.serializer = new JavaSerializer(this);
        this.internalNode = new Node(InetAddress.getLocalHost().getHostAddress(), port);
        this.pendingSends = new HashMap();
        this.shouldTerminate = false;
        this.connections = new HashMap();
    }

    private final void liftedTry1$1(Node node, byte[] byArray) {
        block5: {
            try {
                TcpServiceWorker newWorker$1 = this.connect(node);
                newWorker$1.transmit(byArray);
                Option option = this.pendingSends().get(node);
                if (None$.MODULE$ == option) break block5;
                if (option instanceof Some) {
                    ((List)((Some)option).x()).foreach(new $anonfun$liftedTry1$1$1(this, newWorker$1));
                    this.pendingSends().$minus$eq(node);
                    break block5;
                }
                throw new MatchError(option);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                this.bufferMsg$1(iOException, node, byArray);
            }
            catch (UnknownHostException unknownHostException) {
                this.bufferMsg$1(unknownHostException, node, byArray);
            }
        }
    }

    private final void bufferMsg$1(Throwable t, Node node, byte[] byArray) {
        Option option;
        block4: {
            block5: {
                block3: {
                    block2: {
                        option = this.pendingSends().get(node);
                        if (None$.MODULE$ != option) break block2;
                        byte[] byArray2 = byArray;
                        this.pendingSends().$plus$eq(node).$minus$greater(Nil$.MODULE$.$colon$colon(byArray2));
                        break block3;
                    }
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    List list2 = (List)some.x();
                    List msgs = list2;
                    if (!this.gd1$1(msgs)) break block5;
                    byte[] byArray3 = byArray;
                    this.pendingSends().$plus$eq(node).$minus$greater(list2.$colon$colon(byArray3));
                }
                return;
            }
            throw new MatchError(option);
        }
        throw new MatchError(option);
    }

    private final /* synthetic */ boolean gd1$1(List x$1) {
        return x$1.length() < TcpService$.MODULE$.BufSize();
    }

    public Serializer serializer() {
        return this.serializer();
    }

    public void nodeDown(Node mnode) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$minus$eq(mnode);
            return;
        }
    }

    public boolean isReachable(Node node) {
        boolean bl;
        if (this.isConnected(node)) {
            bl = true;
        } else {
            try {
                this.connect(node);
                return true;
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
            catch (UnknownHostException unknownHostException) {
                bl = false;
            }
        }
        return bl;
    }

    public void disconnectNode(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option option;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        option = this.connections().get(n);
                        if (None$.MODULE$ != option) break block5;
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!(option instanceof Some)) break block7;
                    this.connections().$minus$eq(n);
                    ((TcpServiceWorker)((Some)option).x()).halt();
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public TcpServiceWorker connect(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Socket sock = new Socket(n.address(), n.port());
            TcpServiceWorker worker = new TcpServiceWorker(this, sock);
            worker.sendNode(n);
            worker.start();
            this.addConnection(n, worker);
            return worker;
        }
    }

    public boolean isConnected(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return BoxesRunTime.unboxToBoolean(BoxesRunTime.boxToBoolean(!this.connections().get(n).isEmpty()));
        }
    }

    public Option getConnection(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return this.connections().get(n);
        }
    }

    public void addConnection(Node node, TcpServiceWorker worker) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$plus$eq(node).$minus$greater(worker);
            return;
        }
    }

    private HashMap connections() {
        return this.connections;
    }

    public void run() {
        try {
            try {
                ServerSocket socket = new ServerSocket(this.port);
                while (true) {
                    if (this.shouldTerminate()) {
                        Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
                        ObjectRef workers$1 = new ObjectRef(Nil$.MODULE$);
                        this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
                        ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
                        break;
                    }
                    Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": waiting for new connection..."));
                    Socket nextClient = socket.accept();
                    if (this.shouldTerminate()) {
                        nextClient.close();
                        continue;
                    }
                    TcpServiceWorker worker = new TcpServiceWorker(this, nextClient);
                    Debug$.MODULE$.info("Started new " + worker);
                    worker.readNode();
                    worker.start();
                }
            }
            catch (Exception exception) {
                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": caught ") + exception);
                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
                ObjectRef workers$1 = new ObjectRef(Nil$.MODULE$);
                this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
                ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
            }
            catch (SecurityException securityException) {
                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": caught ") + securityException);
                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
                ObjectRef workers$1 = new ObjectRef(Nil$.MODULE$);
                this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
                ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
            }
            catch (IOException iOException) {
                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": caught ") + iOException);
                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
                ObjectRef workers$1 = new ObjectRef(Nil$.MODULE$);
                this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
                ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
            }
            return;
        }
        catch (Throwable throwable) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
            ObjectRef workers$1 = new ObjectRef(Nil$.MODULE$);
            this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
            ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
            throw throwable;
        }
    }

    private void shouldTerminate_$eq(boolean x$1) {
        this.shouldTerminate = x$1;
    }

    private boolean shouldTerminate() {
        return this.shouldTerminate;
    }

    public void terminate() {
        this.shouldTerminate_$eq(true);
        new Socket(this.internalNode().address(), this.internalNode().port());
    }

    public void send(Node node$1, byte[] data$1) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option option;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        option = this.getConnection(node$1);
                        if (None$.MODULE$ != option) break block5;
                        this.liftedTry1$1(node$1, data$1);
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!(option instanceof Some)) break block7;
                    ((TcpServiceWorker)((Some)option).x()).transmit(data$1);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    private HashMap pendingSends() {
        return this.pendingSends;
    }

    public Node node() {
        return this.internalNode();
    }

    private Node internalNode() {
        return this.internalNode;
    }

    public JavaSerializer serializer() {
        return this.serializer;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }

    public final void kernel_$eq(NetKernel x$1) {
        this.kernel = x$1;
    }

    public final NetKernel kernel() {
        return this.kernel;
    }
}

