/*
 * Decompiled with CFR 0.152.
 */
package sbaz.clui.commands;

import java.io.File;
import sbaz.AvailablePackage;
import sbaz.DependencyError;
import sbaz.FormatError;
import sbaz.PackageSpec;
import sbaz.UserPackageSpecifier;
import sbaz.UserPackageSpecifierUtil$;
import sbaz.clui.Command;
import sbaz.clui.Settings;
import sbaz.clui.commands.Install$;
import scala.;
import scala.Console$;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;

public final class Install$
extends Command
implements ScalaObject {
    public static final Install$ MODULE$;
    private final String fullHelp;
    private final String oneLineHelp;
    private final String name;

    static {
        new Install$();
    }

    public Install$() {
        this.name = "install";
        this.oneLineHelp = "install a package";
        MODULE$ = this;
        this.fullHelp = Predef$.MODULE$.stringWrapper("install package\n    |\n    |Install a package, including any of its necessary dependencies.\n    |The package to install is specified in one of the following ways:\n    |\n    |    name         - Install the newest package with the specified name\n    |    name/version - Install a package with a specified name and version\n    |    -f filename  - Install the package located in the specified file\n    |").stripMargin();
    }

    public void run(List args, Settings settings$1) {
        block11: {
            block14: {
                List list;
                String string;
                block12: {
                    Option option;
                    block13: {
                        List removals;
                        Seq packages2;
                        block10: {
                            List list2 = args;
                            if (!(list2 instanceof .colon.colon)) break block11;
                            .colon.colon colon2 = (.colon.colon)list2;
                            string = (String)colon2.hd$1();
                            list = colon2.tl$1();
                            if (Nil$.MODULE$ != list) break block12;
                            String arg = string;
                            try {
                                UserPackageSpecifier userSpec = UserPackageSpecifierUtil$.MODULE$.fromString(arg);
                                option = userSpec.chooseFrom(settings$1.dir().available());
                                if (None$.MODULE$ != option) break block10;
                                throw new Error("No available package matches " + arg + "!");
                            }
                            catch (FormatError formatError) {
                                boolean isFile = new File(arg).isFile();
                                Console$.MODULE$.println((Object)(isFile ? "Use option '-f filename' to specify file names" : formatError.getMessage()));
                                Predef$.MODULE$.exit(2);
                                return;
                            }
                        }
                        if (!(option instanceof Some)) break block13;
                        PackageSpec spec = ((AvailablePackage)((Some)option).x()).spec();
                        try {
                            packages2 = settings$1.dir().available().choosePackagesFor(spec, settings$1.dir().installed().packageNames());
                        }
                        catch (DependencyError dependencyError) {
                            Console$.MODULE$.println((Object)"Dependency error.");
                            Predef$.MODULE$.exit(2);
                            return;
                        }
                        packages2.foreach((Function1)new anonfun.run.1());
                        List additions = packages2.toList().map((Function1)new anonfun.1());
                        List list3 = removals = packages2.toList().flatMap((Function1)new anonfun.2(settings$1));
                        List changes = additions.$colon$colon$colon(list3);
                        if (!settings$1.dryrun()) {
                            Console$.MODULE$.println((Object)"Installing...");
                            settings$1.dir().makeChanges((Seq)changes);
                        }
                        break block14;
                    }
                    throw new MatchError((Object)option);
                }
                if (!(list instanceof .colon.colon)) break block11;
                .colon.colon colon3 = (.colon.colon)list;
                String string2 = (String)colon3.hd$1();
                if (Nil$.MODULE$ != colon3.tl$1()) break block11;
                String string3 = string;
                String string4 = "-f";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block11;
                String filename = string2;
                Console$.MODULE$.println((Object)("Installing " + filename + "..."));
                if (!settings$1.dryrun()) {
                    settings$1.dir().install(new File(filename));
                }
            }
            return;
        }
        this.usageExit();
    }

    public String fullHelp() {
        return this.fullHelp;
    }

    public String oneLineHelp() {
        return this.oneLineHelp;
    }

    public String name() {
        return this.name;
    }
}

