/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import scala.Console$;
import scala.Function0;
import scala.List;
import scala.List$;
import scala.Nil$;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.collection.mutable.Stack;
import scala.compat.StringBuilder;
import scala.runtime.BoxedObjectArray;
import scala.runtime.ObjectRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.parsing.FactoryAdapter$;

public abstract class FactoryAdapter
extends DefaultHandler
implements ScalaObject {
    private Node rootElem = null;
    private final boolean normalizeWhitespace;
    private boolean capture = false;
    private String curTag = null;
    private Stack scopeStack;
    private final Stack tagStack;
    private final Stack hStack;
    private final Stack attribStack;
    private final StringBuilder buffer = new StringBuilder();

    public FactoryAdapter() {
        this.attribStack = new Stack();
        this.hStack = new Stack();
        this.tagStack = new Stack();
        this.scopeStack = new Stack();
        this.normalizeWhitespace = false;
    }

    public Node load(String sysID) {
        return this.loadXML(new InputSource(sysID));
    }

    public Node load(Reader reader) {
        return this.loadXML(new InputSource(reader));
    }

    public Node load(InputStream is) {
        return this.loadXML(new InputSource(is));
    }

    public Node loadFile(String fileName) {
        return this.loadXML(new InputSource(new FileInputStream(fileName)));
    }

    public Node loadFile(FileDescriptor fileDesc) {
        return this.loadXML(new InputSource(new FileInputStream(fileDesc)));
    }

    public Node loadFile(File file) {
        return this.loadXML(new InputSource(new FileInputStream(file)));
    }

    public Node loadXML(InputSource source) {
        SAXParser parser;
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(false);
            parser = f.newSAXParser();
        }
        catch (Exception exception) {
            Console$.MODULE$.err().println("error: Unable to instantiate parser");
            Predef$.MODULE$.exit(1);
            return null;
        }
        this.scopeStack().push(new BoxedObjectArray(new NamespaceBinding[]{TopScope$.MODULE$}));
        parser.parse(source, (DefaultHandler)this);
        this.scopeStack().pop();
        return this.rootElem();
    }

    public void rootElem_$eq(Node x$1) {
        this.rootElem = x$1;
    }

    public Node rootElem() {
        return this.rootElem;
    }

    public void printError(String errtype$1, SAXParseException ex$1) {
        Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new $anonfun$printError$1(this, errtype$1, ex$1));
    }

    public void fatalError(SAXParseException ex) {
        this.printError("Fatal Error", ex);
    }

    public void error(SAXParseException ex) {
        this.printError("Error", ex);
    }

    public void warning(SAXParseException ex) {
    }

    public void processingInstruction(String target, String data2) {
        this.createProcInstr(target, data2).foreach(new $anonfun$processingInstruction$1(this));
    }

    public void endElement(String uri, String _localName, String qname) {
        this.captureText();
        MetaData metaData = (MetaData)this.attribStack().pop();
        List v = Nil$.MODULE$;
        Node child = (Node)this.hStack().pop();
        while (true) {
            if (child == null) {
                int colon2 = qname.indexOf(58);
                String localName = -1 == colon2 ? qname : qname.substring(colon2 + 1, qname.length());
                NamespaceBinding scp = (NamespaceBinding)this.scopeStack().pop();
                String pre = -1 == colon2 ? null : qname.substring(0, colon2);
                this.rootElem_$eq(this.createNode(pre, localName, metaData, scp, v));
                this.hStack().push(new BoxedObjectArray(new Node[]{this.rootElem()}));
                this.curTag_$eq((String)this.tagStack().pop());
                this.capture_$eq(this.curTag() == null ? false : this.nodeContainsText(this.curTag()));
                return;
            }
            Node node = child;
            v = v.$colon$colon(node);
            child = (Node)this.hStack().pop();
        }
    }

    public void captureText() {
        String text;
        if (this.capture() && (text = this.buffer().toString()).length() > 0 && !text.equals(" ")) {
            this.hStack().push(new BoxedObjectArray(new Node[]{this.createText(text)}));
        }
        this.buffer().setLength(0);
    }

    public void startElement(String uri, String _localName, String qname, Attributes attributes$1) {
        this.captureText();
        this.tagStack().push(new BoxedObjectArray(new String[]{this.curTag()}));
        this.curTag_$eq(qname);
        int colon2 = qname.indexOf(58);
        String localName = -1 == colon2 ? qname : qname.substring(colon2 + 1, qname.length());
        this.capture_$eq(this.nodeContainsText(localName));
        Node[] nodeArray = new Node[1];
        nodeArray[0] = null;
        this.hStack().push(new BoxedObjectArray(nodeArray));
        ObjectRef m$1 = new ObjectRef(Null$.MODULE$);
        ObjectRef scpe$1 = new ObjectRef((NamespaceBinding)this.scopeStack().top());
        List$.MODULE$.range(0, attributes$1.getLength()).foreach(new $anonfun$startElement$1(this, attributes$1, m$1, scpe$1));
        this.scopeStack().push(new BoxedObjectArray(new NamespaceBinding[]{(NamespaceBinding)scpe$1.elem}));
        this.attribStack().push(new BoxedObjectArray(new MetaData[]{(MetaData)m$1.elem}));
    }

    public void characters(char[] ch, int offset, int length2) {
        if (this.capture()) {
            if (this.normalizeWhitespace()) {
                boolean ws = false;
                for (int i = offset; i < offset + length2; ++i) {
                    if (Predef$.MODULE$.charWrapper(ch[i]).isWhitespace()) {
                        if (ws) continue;
                        this.buffer().append(' ');
                        ws = true;
                        continue;
                    }
                    this.buffer().append(ch[i]);
                    ws = false;
                }
            } else {
                this.buffer().append(ch, offset, length2);
            }
        }
    }

    public boolean normalizeWhitespace() {
        return this.normalizeWhitespace;
    }

    public abstract Seq createProcInstr(String var1, String var2);

    public abstract Text createText(String var1);

    public abstract Node createNode(String var1, String var2, MetaData var3, NamespaceBinding var4, List var5);

    public abstract boolean nodeContainsText(String var1);

    public void capture_$eq(boolean x$1) {
        this.capture = x$1;
    }

    public boolean capture() {
        return this.capture;
    }

    public void curTag_$eq(String x$1) {
        this.curTag = x$1;
    }

    public String curTag() {
        return this.curTag;
    }

    public void scopeStack_$eq(Stack x$1) {
        this.scopeStack = x$1;
    }

    public Stack scopeStack() {
        return this.scopeStack;
    }

    public Stack tagStack() {
        return this.tagStack;
    }

    public Stack hStack() {
        return this.hStack;
    }

    public Stack attribStack() {
        return this.attribStack;
    }

    public StringBuilder buffer() {
        return this.buffer;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

