/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$Pair$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.actors.Actor;
import scala.actors.Actor$;
import scala.actors.Debug$;
import scala.actors.remote.FreshNameCreator$;
import scala.actors.remote.NamedSend;
import scala.actors.remote.NetKernel$;
import scala.actors.remote.Node;
import scala.actors.remote.Proxy;
import scala.actors.remote.Reply;
import scala.actors.remote.ReplyTo;
import scala.actors.remote.SendTo;
import scala.actors.remote.Service;
import scala.actors.remote.SyncSend;
import scala.actors.remote.SyncSendTo;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;

public class NetKernel
implements ScalaObject {
    private final HashMap proxies;
    private final HashMap names;
    private final HashMap actors;
    private final Service service;

    public NetKernel(Service service) {
        this.service = service;
        this.actors = new HashMap();
        this.names = new HashMap();
        this.proxies = new HashMap();
    }

    private final void liftedTry1$1(Node node, Symbol symbol, byte[] byArray, Actor actor) {
        try {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": receiver is ") + actor);
            Object msg = this.service.serializer().deserialize(byArray);
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": deserialized msg is ") + msg);
            Actor senderProxy = this.getOrCreateProxy(node, symbol);
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": created ") + senderProxy);
            senderProxy.send(new SendTo(actor, msg), null);
        }
        catch (Exception exception) {
            Debug$.MODULE$.error(Predef$.MODULE$.any2stringadd(this).$plus(": caught ") + exception);
        }
    }

    public void terminate() {
        this.proxies().values().foreach(new $anonfun$terminate$1(this));
        this.service.terminate();
    }

    public void processMsg(Node senderNode$1, Object msg) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            Object object;
            block12: {
                Option option;
                block14: {
                    block7: {
                        BoxedUnit boxedUnit;
                        block13: {
                            byte[] byArray;
                            block9: {
                                Option option2;
                                block11: {
                                    block10: {
                                        byte[] byArray2;
                                        block5: {
                                            Option option3;
                                            block8: {
                                                block6: {
                                                    Actor actor;
                                                    byte[] byArray3;
                                                    object = msg;
                                                    if (!(object instanceof NamedSend)) break block5;
                                                    NamedSend namedSend = (NamedSend)object;
                                                    Symbol symbol = namedSend.senderName();
                                                    Symbol symbol2 = namedSend.receiver();
                                                    byte[] data$4 = byArray3 = namedSend.data();
                                                    Symbol receiver = symbol2;
                                                    Symbol senderName$4 = symbol;
                                                    Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": processing ") + namedSend);
                                                    option3 = this.actors().get(receiver);
                                                    if (!(option3 instanceof Some)) break block6;
                                                    Some some = (Some)option3;
                                                    Actor a$4 = actor = (Actor)some.x();
                                                    this.liftedTry1$1(senderNode$1, senderName$4, data$4, a$4);
                                                    boxedUnit = BoxedUnit.UNIT;
                                                    break block7;
                                                }
                                                if (None$.MODULE$ != option3) break block8;
                                                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": lost message"));
                                                boxedUnit = BoxedUnit.UNIT;
                                                break block7;
                                            }
                                            throw new MatchError(option3);
                                        }
                                        if (!(object instanceof SyncSend)) break block9;
                                        SyncSend syncSend = (SyncSend)object;
                                        Symbol symbol = syncSend.senderName();
                                        Symbol symbol3 = syncSend.receiver();
                                        byte[] data2 = byArray2 = syncSend.data();
                                        Symbol receiver = symbol3;
                                        Symbol senderName = symbol;
                                        Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": processing ") + syncSend);
                                        option2 = this.actors().get(receiver);
                                        if (!(option2 instanceof Some)) break block10;
                                        Object msg2 = this.service.serializer().deserialize(data2);
                                        Actor senderProxy = this.getOrCreateProxy(senderNode$1, senderName);
                                        senderProxy.send(new SyncSendTo((Actor)((Some)option2).x(), msg2, receiver), null);
                                        boxedUnit = BoxedUnit.UNIT;
                                        break block7;
                                    }
                                    if (None$.MODULE$ != option2) break block11;
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block7;
                                }
                                throw new MatchError(option2);
                            }
                            if (!(object instanceof Reply)) break block12;
                            Reply reply = (Reply)object;
                            Symbol symbol = reply.senderName();
                            Symbol symbol4 = reply.receiver();
                            byte[] data3 = byArray = reply.data();
                            Symbol receiver = symbol4;
                            Symbol senderName = symbol;
                            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": processing ") + reply);
                            option = this.actors().get(receiver);
                            if (!(option instanceof Some)) break block13;
                            Object msg3 = this.service.serializer().deserialize(data3);
                            Actor senderProxy = this.getOrCreateProxy(senderNode$1, senderName);
                            senderProxy.send(new ReplyTo((Actor)((Some)option).x(), msg3), null);
                            boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (None$.MODULE$ != option) break block14;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            throw new MatchError(object);
        }
    }

    public Actor getOrCreateProxy(Node senderNode, Symbol senderName) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            Option option;
            block6: {
                Object object;
                option = this.proxies().get(new Tuple2(senderNode, senderName));
                if (option instanceof Some) {
                    object = ((Some)option).x();
                } else {
                    if (None$.MODULE$ != option) break block6;
                    object = this.createProxy(senderNode, senderName);
                }
                return (Actor)object;
            }
            throw new MatchError(option);
        }
    }

    public HashMap proxies() {
        return this.proxies;
    }

    /*
     * WARNING - void declaration
     */
    public Actor createProxy(Node node, Symbol sym) {
        void var3_3;
        Proxy p = new Proxy(node, sym, this);
        this.proxies().$plus$eq((Object)Predef$Pair$.MODULE$.apply(node, sym)).$minus$greater(p);
        return var3_3;
    }

    public void syncSend(Node node, Symbol name, Object msg) {
        Symbol senderName = this.selfName();
        this.namedSyncSend(node, senderName, name, msg);
    }

    public void send(Node node, Symbol name, Object msg) {
        Symbol senderName = this.selfName();
        this.namedSend(node, senderName, name, msg);
    }

    /*
     * WARNING - void declaration
     */
    public Symbol selfName() {
        Option option;
        block4: {
            Symbol symbol;
            block3: {
                block2: {
                    void var2_2;
                    option = this.names().get(Actor$.MODULE$.self());
                    if (None$.MODULE$ != option) break block2;
                    Symbol freshName = FreshNameCreator$.MODULE$.newName("remotesender");
                    this.register(freshName, Actor$.MODULE$.self());
                    symbol = var2_2;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                symbol = (Symbol)((Some)option).x();
            }
            return symbol;
        }
        throw new MatchError(option);
    }

    public void register(Symbol name, Actor a) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            this.actors().$plus$eq(name).$minus$greater(a);
            this.names().$plus$eq(a).$minus$greater(name);
            return;
        }
    }

    private HashMap names() {
        return this.names;
    }

    private HashMap actors() {
        return this.actors;
    }

    public void sendReply(Node node, Symbol sender, Symbol receiver, Object msg) {
        byte[] bytes = this.service.serializer().serialize(msg);
        Reply toSend = new Reply(sender, receiver, bytes);
        this.sendToNode(node, toSend);
    }

    public void namedSyncSend(Node node, Symbol sender, Symbol receiver, Object msg) {
        byte[] bytes = this.service.serializer().serialize(msg);
        SyncSend toSend = new SyncSend(sender, receiver, bytes);
        this.sendToNode(node, toSend);
    }

    public void namedSend(Node node, Symbol sender, Symbol receiver, Object msg) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.sendToNode(node, new NamedSend(sender, receiver, bytes));
    }

    public void sendToNode(Node node, Object msg) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.service.send(node, bytes);
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

