/*
 * Decompiled with CFR 0.152.
 */
package sbaz.clui.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sbaz.AvailablePackage;
import sbaz.Package;
import sbaz.PackageUtil$;
import sbaz.Version;
import sbaz.VersionUtil$;
import sbaz.clui.Command;
import sbaz.clui.Settings;
import sbaz.clui.commands.Pack;
import sbaz.clui.commands.Pack$;
import scala.;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.ListSet;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class Pack$
extends Command
implements ScalaObject {
    public static final Pack$ MODULE$;
    private String fullHelp = "pack name directory [options]\n\nOptions (defaults):\n  --version version (0.0)\n  --description description (no description)\n  --descfile description-file (no description)\n  --depends dependencies seperated by a comma (none)\n  --outdir directory (current directory)\n  --linkbase url (none)\n\nCreate an sbaz package and, if a link base is specified, an\nadvertisement file.  The package file is named name-version.sbp.\nThe advertisement file is named name-version.advert.  The URL\nin the advertisement file is the URL base with the package\nfilename appended.\n";
    private String oneLineHelp = "create an sbaz package";
    private String name = "pack";

    static {
        Pack$ pack$ = new Pack$();
    }

    public Pack$() {
        MODULE$ = this;
    }

    public final void lp$0(File file, String path$0, Function2 function2) {
        function2.apply((Object)file, (Object)path$0);
        if (file.isDirectory()) {
            new BoxedObjectArray((Object[])file.listFiles()).toList().foreach((Function1)new anonfun.0(function2, path$0));
        }
    }

    public void run(List args, Settings sbazSettings) {
        Option option;
        block8: {
            Option option2;
            block11: {
                Pack.Settings packSettings;
                block10: {
                    block9: {
                        block7: {
                            block6: {
                                packSettings = this.parseArguments(args);
                                option = PackageUtil$.MODULE$.checkName(packSettings.name());
                                if (!(option instanceof Some)) break block6;
                                Console$.MODULE$.println((Object)("Warning: " + ((Some)option).x()));
                                break block7;
                            }
                            if (None$.MODULE$ != option) break block8;
                        }
                        option2 = VersionUtil$.MODULE$.check(packSettings.version().toString());
                        if (!(option2 instanceof Some)) break block9;
                        Console$.MODULE$.println((Object)("Warning: " + ((Some)option2).x()));
                        break block10;
                    }
                    if (None$.MODULE$ != option2) break block11;
                }
                try {
                    this.writeSBP(sbazSettings, packSettings);
                    if (!packSettings.linkBase().isEmpty()) {
                        this.writeAdvert(sbazSettings, packSettings);
                    }
                    return;
                }
                catch (IOException iOException) {
                    Console$.MODULE$.println((Object)iOException);
                    Predef$.MODULE$.exit(2);
                    return;
                }
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public void writeAdvert(Settings sbazSettings, Pack.Settings packSettings) {
        String link = (String)packSettings.linkBase().get() + packSettings.name() + "-" + packSettings.version() + ".sbp";
        File advertFile = new File(packSettings.name() + "-" + packSettings.version() + ".advert");
        if (sbazSettings.verbose()) {
            Console$.MODULE$.println((Object)("writing " + advertFile + "..."));
        }
        AvailablePackage advert = new AvailablePackage(this.packageFor(packSettings), new URL(link));
        FileWriter out = new FileWriter(advertFile);
        out.write(advert.toXML().toString());
        out.close();
    }

    public void writeSBP(Settings sbazSettings$0, Pack.Settings packSettings) {
        String sbpName = packSettings.name() + "-" + packSettings.version() + ".sbp";
        File sbpFile = new File(packSettings.outdir(), sbpName);
        if (sbazSettings$0.verbose()) {
            Console$.MODULE$.println((Object)("Writing " + sbpFile + "..."));
        }
        ZipOutputStream zip$0 = new ZipOutputStream(new FileOutputStream(sbpFile));
        this.withDirTree(packSettings.packdir(), new anonfun.1(sbazSettings$0, zip$0));
        if (sbazSettings$0.verbose()) {
            Console$.MODULE$.println((Object)"Writing meta/description");
        }
        zip$0.putNextEntry(new ZipEntry("meta/description"));
        zip$0.write(this.packageFor(packSettings).toXML().toString().getBytes());
        zip$0.closeEntry();
        zip$0.close();
        if (sbazSettings$0.verbose()) {
            Console$.MODULE$.println((Object)("Finished with " + sbpFile + "."));
        }
    }

    public Package packageFor(Pack.Settings settings) {
        return new Package(settings.name(), settings.version(), new ListSet().incl((Iterable)settings.depends()), settings.description());
    }

    public void copyFile(File file, OutputStream out) {
        FileInputStream in = new FileInputStream(file);
        byte[] buf = new byte[1024];
        int n = 0;
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
        }
        return;
    }

    public void withDirTree(File root, Function2 handler$0) {
        this.lp$0(root, "", handler$0);
    }

    /*
     * Loose catch block
     */
    public Pack.Settings parseArguments(List args) {
        String df;
        List argsLeft = args;
        ObjectRef nameArg$0 = new ObjectRef(null);
        ObjectRef packdirArg$0 = new ObjectRef(null);
        ObjectRef outdirArg$0 = new ObjectRef(null);
        ObjectRef linkBaseArg$0 = new ObjectRef((Object)None$.MODULE$);
        ObjectRef versionArg$0 = new ObjectRef((Object)new Version("0.0"));
        ObjectRef descriptionArg$0 = new ObjectRef((Object)"(no description)");
        ObjectRef dependsArg$0 = new ObjectRef((Object)Nil$.MODULE$);
        List list = args;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String string = (String)colon2.hd();
            List list2 = colon2.tl$0();
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                nameArg$0.elem = string;
                packdirArg$0.elem = new File((String)colon3.hd());
                argsLeft = colon3.tl$0();
                while (true) {
                    List list3 = argsLeft;
                    Object object = Nil$.MODULE$;
                    if (!(list3 != null ? !list3.equals(object) : object != null)) {
                        return new anon.0(nameArg$0, packdirArg$0, outdirArg$0, linkBaseArg$0, versionArg$0, descriptionArg$0, dependsArg$0);
                    }
                    List list4 = argsLeft;
                    if (!(list4 instanceof .colon.colon)) break;
                    .colon.colon colon4 = (.colon.colon)list4;
                    String string2 = (String)colon4.hd();
                    List list5 = colon4.tl$0();
                    String string3 = string2;
                    object = "--version";
                    if (!(string3 != null ? !string3.equals(object) : object != null)) {
                        if (!(list5 instanceof .colon.colon)) break;
                        .colon.colon colon5 = (.colon.colon)list5;
                        versionArg$0.elem = new Version((String)colon5.hd());
                        argsLeft = colon5.tl$0();
                        continue;
                    }
                    String string4 = string2;
                    object = "--description";
                    if (!(string4 != null ? !string4.equals(object) : object != null)) {
                        if (!(list5 instanceof .colon.colon)) break;
                        .colon.colon colon6 = (.colon.colon)list5;
                        descriptionArg$0.elem = (String)colon6.hd();
                        argsLeft = colon6.tl$0();
                        continue;
                    }
                    String string5 = string2;
                    object = "--descfile";
                    if (!(string5 != null ? !string5.equals(object) : object != null)) {
                        String string6;
                        if (!(list5 instanceof .colon.colon)) break;
                        .colon.colon colon7 = (.colon.colon)list5;
                        df = string6 = (String)colon7.hd();
                        descriptionArg$0.elem = this.readFile(df);
                        BoxedUnit str = BoxedUnit.UNIT;
                        argsLeft = colon7.tl$0();
                        continue;
                    }
                    String string7 = string2;
                    object = "--depends";
                    if (!(string7 != null ? !string7.equals(object) : object != null)) {
                        if (!(list5 instanceof .colon.colon)) break;
                        .colon.colon colon8 = (.colon.colon)list5;
                        dependsArg$0.elem = new BoxedObjectArray((Object[])((String)colon8.hd()).split(",")).toList();
                        argsLeft = colon8.tl$0();
                        continue;
                    }
                    String string8 = string2;
                    object = "--outdir";
                    if (!(string8 != null ? !string8.equals(object) : object != null)) {
                        if (!(list5 instanceof .colon.colon)) break;
                        .colon.colon colon9 = (.colon.colon)list5;
                        outdirArg$0.elem = new File((String)colon9.hd());
                        argsLeft = colon9.tl$0();
                        continue;
                    }
                    String string9 = string2;
                    object = "--linkbase";
                    if ((string9 != null ? !string9.equals(object) : object != null) || !(list5 instanceof .colon.colon)) break;
                    .colon.colon colon10 = (.colon.colon)list5;
                    linkBaseArg$0.elem = new Some(colon10.hd());
                    argsLeft = colon10.tl$0();
                }
                this.usageExit();
                return null;
            }
        }
        this.usageExit();
        return null;
        catch (IOException iOException) {
            Console$.MODULE$.println((Object)("Error reading " + df + ": " + iOException));
            Predef$.MODULE$.exit(1);
            return null;
        }
    }

    public String readFile(String filename) {
        FileReader reader = new FileReader(filename);
        char[] rbuf = new char[1024];
        StringBuffer wbuf = new StringBuffer();
        int n = 0;
        while (true) {
            if ((n = reader.read(rbuf)) < 0) {
                reader.close();
                return wbuf.toString();
            }
            wbuf.append(rbuf, 0, n);
        }
    }

    public String fullHelp() {
        return this.fullHelp;
    }

    public String oneLineHelp() {
        return this.oneLineHelp;
    }

    public String name() {
        return this.name;
    }
}

