/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.Message;
import sbaz.PackageSpec;
import sbaz.ServletRequestHandler$;
import sbaz.SimpleUniverse;
import sbaz.Universe;
import sbaz.keys.Key;
import sbaz.keys.KeyRing;
import sbaz.keys.KeyUtil$;
import sbaz.keys.MessagePattern;
import sbaz.messages.AddPackage;
import sbaz.messages.KeyCreate;
import sbaz.messages.KeyCreated;
import sbaz.messages.KeyList;
import sbaz.messages.KeyRevoke;
import sbaz.messages.LatestPackages;
import sbaz.messages.NotOK;
import sbaz.messages.OK;
import sbaz.messages.RemovePackage;
import sbaz.messages.SendKeyList$;
import sbaz.messages.SendPackageList;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.Predef$;
import scala.ScalaObject;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public class ServletRequestHandler
implements ScalaObject {
    private List keylessRequests;
    private KeyRing keyring;
    private AvailableList packages;
    private SimpleUniverse universe;
    private File directory;

    public ServletRequestHandler(File directory) {
        this.directory = directory;
        Universe universe = (Universe)this.loadXML("universe", new $anonfun$1(this), new $anonfun$0(this));
        if (universe instanceof SimpleUniverse) {
            this.universe = (SimpleUniverse)universe;
            this.packages = (AvailableList)this.loadXML("packages", new $anonfun$3(this), new $anonfun$2(this));
            this.keyring = (KeyRing)this.loadXML("keyring", new $anonfun$5(this), new $anonfun$4(this));
            this.keylessRequests = (List)this.loadXML("keylessRequests", new $anonfun$9(this), new $anonfun$8(this));
            Predef$.MODULE$.println((Object)("requests needing no key are: " + this.keylessRequests()));
            return;
        }
        throw new Error("this universe is not a simple universe");
    }

    public final List fromXML$0(Node xml) {
        return xml.child().toList().filter((Function1)new $anonfun$6(this)).map((Function1)new $anonfun$7(this));
    }

    public Message handleRequest(Message req0) {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            Message message;
            Message req$0 = req0.sansKeys();
            List keys = req0.authKeys().filter((Function1)new $anonfun$11(this));
            if (this.keylessRequests().exists((Function1)new $anonfun$12(this, req$0)) || keys.exists((Function1)new $anonfun$13(this, req$0))) {
                Message message2 = req$0;
                if (message2 instanceof SendPackageList) {
                    message = new LatestPackages(this.packages());
                } else if (message2 instanceof AddPackage) {
                    AvailablePackage availablePackage;
                    AddPackage addPackage = (AddPackage)message2;
                    AvailablePackage pack$0 = availablePackage = addPackage.pack();
                    Predef$.MODULE$.println((Object)("adding new package: " + pack$0));
                    List packsMinus = this.packages().available().filter((Function1)new $anonfun$14(this, pack$0));
                    AvailablePackage availablePackage2 = pack$0;
                    List newPacks = packsMinus.$colon$colon((Object)availablePackage2);
                    this.packages_$eq(new AvailableList(newPacks));
                    this.savePackages();
                    message = new OK();
                } else if (message2 instanceof RemovePackage) {
                    PackageSpec packageSpec;
                    RemovePackage removePackage = (RemovePackage)message2;
                    PackageSpec spec$0 = packageSpec = removePackage.spec();
                    Predef$.MODULE$.println((Object)("removing package: " + spec$0));
                    List packsMinus = this.packages().available().filter((Function1)new $anonfun$15(this, spec$0));
                    this.packages_$eq(new AvailableList(packsMinus));
                    this.savePackages();
                    message = new OK();
                } else if (message2 instanceof KeyCreate) {
                    String string;
                    KeyCreate keyCreate = (KeyCreate)message2;
                    MessagePattern messagePattern = keyCreate.messages();
                    String description = string = keyCreate.description();
                    MessagePattern messages = messagePattern;
                    String data = KeyUtil$.MODULE$.genKeyData();
                    Key key = new Key(messages, description, data);
                    this.keyring().addKey(key);
                    this.saveKeyring();
                    message = new KeyCreated(key);
                } else if (message2 instanceof KeyRevoke) {
                    this.keyring().removeKey(((KeyRevoke)message2).key());
                    this.saveKeyring();
                    message = new OK();
                } else {
                    message = SendKeyList$.MODULE$ == message2 ? new KeyList(this.keyring().keys()) : new NotOK("unhandled message type.  full message: " + req$0);
                }
            } else {
                message = new NotOK("Permission denied");
            }
            return message;
        }
    }

    public String responseForGET() {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            StringWriter out$0 = new StringWriter();
            out$0.write("This is a Scala Bazaar.  The bazaar descriptor is:\n");
            out$0.write(this.universe().toXML().toString());
            out$0.write("\n\n");
            out$0.write("The packages included are:\n");
            this.packages().sortedSpecs().foreach((Function1)new $anonfun$10(this, out$0));
            return out$0.toString();
        }
    }

    public List keylessRequests() {
        return this.keylessRequests;
    }

    public boolean saveKeyring() {
        return this.saveXML(this.keyring().toXML(), "keyring");
    }

    public KeyRing keyring() {
        return this.keyring;
    }

    public boolean savePackages() {
        return this.saveXML((Node)this.packages().toXML(), "packages");
    }

    public void packages_$eq(AvailableList x$1) {
        this.packages = x$1;
    }

    public AvailableList packages() {
        return this.packages;
    }

    public SimpleUniverse universe() {
        return this.universe;
    }

    private boolean saveXML(Node xml, String filename) {
        File tmpFile = new File(this.directory, filename + ".tmp");
        FileWriter str = new FileWriter(tmpFile);
        str.write(xml.toString());
        str.close();
        return this.renameFile(tmpFile, new File(this.directory, filename));
    }

    private boolean renameFile(File from, File to) {
        to.delete();
        return from.renameTo(to);
    }

    public Object loadXML(String baseName, Function1 loader, Function0 ifmissing) {
        Object object;
        File file = new File(this.directory, baseName);
        if (file.exists()) {
            Elem xml = XML$.MODULE$.load(file.getAbsolutePath());
            object = loader.apply((Object)xml);
        } else {
            object = ifmissing.apply();
        }
        return object;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

