/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ProcessPanelWorker;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.n3.nanoxml.XMLElement;

public class ProcessPanel
extends IzPanel
implements AbstractUIProcessHandler {
    private static final long serialVersionUID = 3258417209583155251L;
    protected JLabel processLabel;
    protected JProgressBar overallProgressBar;
    private boolean validated = false;
    private ProcessPanelWorker worker;
    private int noOfJobs;
    private int currentJob;
    private JTextArea outputPane;
    private JScrollPane outputScrollPane;

    public ProcessPanel(InstallerFrame parent, InstallData idata) throws IOException {
        super(parent, idata);
        this.worker = new ProcessPanelWorker(idata, this);
        JLabel heading = new JLabel();
        Font font = heading.getFont();
        font = font.deriveFont(1, (float)font.getSize() * 2.0f);
        heading.setFont(font);
        heading.setHorizontalAlignment(0);
        heading.setText(parent.langpack.getString("ProcessPanel.heading"));
        heading.setVerticalAlignment(1);
        this.setLayout(new BorderLayout());
        this.add((Component)heading, "North");
        JPanel subpanel = new JPanel();
        subpanel.setAlignmentX(0.5f);
        subpanel.setLayout(new BoxLayout(subpanel, 1));
        this.processLabel = new JLabel();
        this.processLabel.setAlignmentX(0.5f);
        this.processLabel.setText(" ");
        subpanel.add(this.processLabel);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setAlignmentX(0.5f);
        this.overallProgressBar.setStringPainted(true);
        subpanel.add(this.overallProgressBar);
        this.outputPane = new JTextArea();
        this.outputPane.setEditable(false);
        this.outputScrollPane = new JScrollPane(this.outputPane);
        subpanel.add(this.outputScrollPane);
        this.add((Component)subpanel, "Center");
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void startProcessing(int no_of_jobs) {
        this.noOfJobs = no_of_jobs;
        this.overallProgressBar.setMaximum(this.noOfJobs);
        this.parent.lockPrevButton();
    }

    public void finishProcessing() {
        this.overallProgressBar.setValue(this.noOfJobs);
        String no_of_jobs = Integer.toString(this.noOfJobs);
        this.overallProgressBar.setString(no_of_jobs + " / " + no_of_jobs);
        this.overallProgressBar.setEnabled(false);
        this.processLabel.setText(" ");
        this.processLabel.setEnabled(false);
        this.validated = true;
        this.idata.installSuccess = true;
        if (this.idata.panels.indexOf(this) != this.idata.panels.size() - 1) {
            this.parent.unlockNextButton();
        }
    }

    public void logOutput(String message, boolean stderr) {
        this.outputPane.append(message + '\n');
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProcessPanel.this.outputPane.setCaretPosition(ProcessPanel.this.outputPane.getText().length());
            }
        });
    }

    public void startProcess(String jobName) {
        this.processLabel.setText(jobName);
        ++this.currentJob;
        this.overallProgressBar.setValue(this.currentJob);
        this.overallProgressBar.setString(Integer.toString(this.currentJob) + " / " + Integer.toString(this.noOfJobs));
    }

    public void finishProcess() {
    }

    public void panelActivate() {
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
        this.worker.startThread();
    }

    public void makeXMLData(XMLElement panelRoot) {
    }
}

