/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.Console$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.io.SourceReader$;
import scala.tools.nsc.io.ZipArchive;

public class SourceReader
implements ScalaObject {
    private CharBuffer chars;
    private ByteBuffer bytes;
    private CharsetDecoder decoder;

    public SourceReader(CharsetDecoder decoder) {
        this.decoder = decoder;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result = new char[chars.length()];
        chars.get(result);
        this.chars_$eq(chars);
        return var2_2;
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes = this.bytes();
        bytes.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes) < 0;
            bytes.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(AbstractFile file) {
        block4: {
            char[] cArray;
            block3: {
                ZipArchive.FileEntry fileEntry;
                AbstractFile abstractFile;
                block2: {
                    abstractFile = file;
                    if (!(abstractFile instanceof PlainFile)) break block2;
                    cArray = this.read(((PlainFile)abstractFile).file());
                    break block3;
                }
                if (!(abstractFile instanceof ZipArchive.FileEntry)) break block4;
                ZipArchive.FileEntry z = fileEntry = (ZipArchive.FileEntry)abstractFile;
                ReadableByteChannel c = Channels.newChannel(z.getArchive().getInputStream(z.entry()));
                cArray = this.read(c);
            }
            return cArray;
        }
        throw new IOException(file.toString() + " is neither plain file nor ZipArchive#FileEntry");
    }

    public char[] read(File file) {
        char[] cArray;
        FileChannel c = new FileInputStream(file).getChannel();
        try {
            cArray = this.read(c);
            c.close();
        }
        catch (Throwable throwable) {
            c.close();
            throw throwable;
        }
        catch (Exception exception) {
            this.reportEncodingError(file.toString());
            cArray = new char[]{};
            c.close();
        }
        return cArray;
    }

    public char[] read(String filename) {
        return this.read(new File(filename));
    }

    private void reportEncodingError(String filename) {
        Console$.MODULE$.println("IO error while decoding " + filename + " with " + this.decoder.charset());
        Console$.MODULE$.println("Please try specifying another one using the -encoding option");
    }

    private void chars_$eq(CharBuffer x$1) {
        this.chars = x$1;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

