/*
 * Decompiled with CFR 0.152.
 */
package sbaz.clui.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sbaz.AvailablePackage;
import sbaz.Package;
import sbaz.PackageUtil$;
import sbaz.Version;
import sbaz.VersionUtil$;
import sbaz.clui.Command;
import sbaz.clui.Settings;
import sbaz.clui.commands.Pack;
import sbaz.clui.commands.Pack$;
import scala.;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.ListSet;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.Comparator;
import scala.runtime.ObjectRef;

public final class Pack$
extends Command
implements ScalaObject {
    public static final Pack$ MODULE$;
    private String fullHelp = "pack name directory [options]\n\nOptions (defaults):\n  --version version (0.0)\n  --description description (no description)\n  --descfile description-file (no description)\n  --depends dependencies seperated by a comma (none)\n  --outdir directory (current directory)\n  --linkbase url (none)\n\nCreate an sbaz package and, if a link base is specified, an\nadvertisement file.  The package file is named name-version.sbp.\nThe advertisement file is named name-version.advert.  The URL\nin the advertisement file is the URL base with the package\nfilename appended.\n";
    private String oneLineHelp = "create an sbaz package";
    private String name = "pack";

    static {
        Pack$ pack$ = new Pack$();
    }

    public Pack$() {
        MODULE$ = this;
    }

    public final void lp$0(File file, String path$0, Function2 function2) {
        function2.apply((Object)file, (Object)path$0);
        if (file.isDirectory()) {
            new BoxedObjectArray((Object[])file.listFiles()).toList().foreach((Function1)new anonfun.0(function2, path$0));
        }
    }

    public void run(List args, Settings sbazSettings) {
        Option option;
        Pack.Settings packSettings = this.parseArguments(args);
        Option option2 = PackageUtil$.MODULE$.checkName(packSettings.name());
        if (!(option2 instanceof Some)) {
            if (None$.MODULE$ != option2) {
                throw new MatchError((Object)option2);
            }
        } else {
            String string;
            Some some = (Some)option2;
            String problem = string = (String)some.x();
            Console$.MODULE$.println((Object)("Warning: " + problem));
        }
        if (!((option = VersionUtil$.MODULE$.check(packSettings.version().toString())) instanceof Some)) {
            if (None$.MODULE$ != option) {
                throw new MatchError((Object)option);
            }
        } else {
            String string;
            Some some = (Some)option;
            String problem = string = (String)some.x();
            Console$.MODULE$.println((Object)("Warning: " + problem));
        }
        try {
            this.writeSBP(sbazSettings, packSettings);
            if (!packSettings.linkBase().isEmpty()) {
                this.writeAdvert(sbazSettings, packSettings);
            }
            return;
        }
        catch (IOException iOException) {
            Console$.MODULE$.println((Object)iOException);
            Predef$.MODULE$.exit(2);
            return;
        }
    }

    public void writeAdvert(Settings sbazSettings, Pack.Settings packSettings) {
        String link = (String)packSettings.linkBase().get() + packSettings.name() + "-" + packSettings.version() + ".sbp";
        File advertFile = new File(packSettings.name() + "-" + packSettings.version() + ".advert");
        if (sbazSettings.verbose()) {
            Console$.MODULE$.println((Object)("writing " + advertFile + "..."));
        }
        AvailablePackage advert = new AvailablePackage(this.packageFor(packSettings), new URL(link));
        FileWriter out = new FileWriter(advertFile);
        out.write(advert.toXML().toString());
        out.close();
    }

    public void writeSBP(Settings sbazSettings$0, Pack.Settings packSettings) {
        String sbpName = packSettings.name() + "-" + packSettings.version() + ".sbp";
        File sbpFile = new File(packSettings.outdir(), sbpName);
        if (sbazSettings$0.verbose()) {
            Console$.MODULE$.println((Object)("Writing " + sbpFile + "..."));
        }
        ZipOutputStream zip$0 = new ZipOutputStream(new FileOutputStream(sbpFile));
        this.withDirTree(packSettings.packdir(), new anonfun.1(sbazSettings$0, zip$0));
        if (sbazSettings$0.verbose()) {
            Console$.MODULE$.println((Object)"Writing meta/description");
        }
        zip$0.putNextEntry(new ZipEntry("meta/description"));
        zip$0.write(this.packageFor(packSettings).toXML().toString().getBytes());
        zip$0.closeEntry();
        zip$0.close();
        if (sbazSettings$0.verbose()) {
            Console$.MODULE$.println((Object)("Finished with " + sbpFile + "."));
        }
    }

    public Package packageFor(Pack.Settings settings) {
        return new Package(settings.name(), settings.version(), new ListSet().incl((Iterable)settings.depends()), settings.description());
    }

    public void copyFile(File file, OutputStream out) {
        FileInputStream in = new FileInputStream(file);
        byte[] buf = new byte[1024];
        int n = 0;
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
        }
    }

    public void withDirTree(File root, Function2 handler$0) {
        this.lp$0(root, "", handler$0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pack.Settings parseArguments(List args) {
        .colon.colon colon2;
        ObjectRef dependsArg$0;
        ObjectRef descriptionArg$0;
        ObjectRef versionArg$0;
        ObjectRef linkBaseArg$0;
        ObjectRef outdirArg$0;
        ObjectRef packdirArg$0;
        ObjectRef nameArg$0;
        List argsLeft;
        block8: {
            block7: {
                argsLeft = args;
                nameArg$0 = new ObjectRef(null);
                packdirArg$0 = new ObjectRef(null);
                outdirArg$0 = new ObjectRef(null);
                linkBaseArg$0 = new ObjectRef((Object)None$.MODULE$);
                versionArg$0 = new ObjectRef((Object)new Version("0.0"));
                descriptionArg$0 = new ObjectRef((Object)"(no description)");
                dependsArg$0 = new ObjectRef((Object)Nil$.MODULE$);
                List list = args;
                if (!(list instanceof .colon.colon)) break block7;
                colon2 = (.colon.colon)list;
                if (colon2.tl$0() instanceof .colon.colon) break block8;
            }
            this.usageExit();
            return null;
        }
        .colon.colon colon3 = (.colon.colon)colon2.tl$0();
        nameArg$0.elem = (String)colon2.hd();
        packdirArg$0.elem = new File((String)colon3.hd());
        argsLeft = colon3.tl$0();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        while (true) {
            BoxedUnit boxedUnit2;
            .colon.colon colon4;
            block10: {
                block11: {
                    block12: {
                        block13: {
                            block14: {
                                block15: {
                                    block9: {
                                        List list = argsLeft;
                                        Nil$ nil$ = Nil$.MODULE$;
                                        if (!(list != null ? !list.equals(nil$) : nil$ != null)) break;
                                        List list2 = argsLeft;
                                        if (!(list2 instanceof .colon.colon)) break block9;
                                        colon4 = (.colon.colon)list2;
                                        if (Comparator.equals((Object)colon4.hd(), (Object)"--version") && colon4.tl$0() instanceof .colon.colon) break block10;
                                        if (Comparator.equals((Object)colon4.hd(), (Object)"--description") && colon4.tl$0() instanceof .colon.colon) break block11;
                                        if (Comparator.equals((Object)colon4.hd(), (Object)"--descfile") && colon4.tl$0() instanceof .colon.colon) break block12;
                                        if (Comparator.equals((Object)colon4.hd(), (Object)"--depends") && colon4.tl$0() instanceof .colon.colon) break block13;
                                        if (Comparator.equals((Object)colon4.hd(), (Object)"--outdir") && colon4.tl$0() instanceof .colon.colon) break block14;
                                        if (!Comparator.equals((Object)colon4.hd(), (Object)"--linkbase")) break block9;
                                        if (colon4.tl$0() instanceof .colon.colon) break block15;
                                    }
                                    this.usageExit();
                                    return null;
                                }
                                .colon.colon colon5 = (.colon.colon)colon4.tl$0();
                                linkBaseArg$0.elem = new Some(colon5.hd());
                                argsLeft = colon5.tl$0();
                                boxedUnit2 = BoxedUnit.UNIT;
                                continue;
                            }
                            .colon.colon colon6 = (.colon.colon)colon4.tl$0();
                            outdirArg$0.elem = new File((String)colon6.hd());
                            argsLeft = colon6.tl$0();
                            boxedUnit2 = BoxedUnit.UNIT;
                            continue;
                        }
                        .colon.colon colon7 = (.colon.colon)colon4.tl$0();
                        dependsArg$0.elem = new BoxedObjectArray((Object[])((String)colon7.hd()).split(",")).toList();
                        argsLeft = colon7.tl$0();
                        boxedUnit2 = BoxedUnit.UNIT;
                        continue;
                    }
                    .colon.colon colon8 = (.colon.colon)colon4.tl$0();
                    String df = (String)colon8.hd();
                    try {
                        descriptionArg$0.elem = this.readFile(df);
                        BoxedUnit str = BoxedUnit.UNIT;
                    }
                    catch (IOException iOException) {
                        Console$.MODULE$.println((Object)("Error reading " + df + ": " + iOException));
                        Predef$.MODULE$.exit(1);
                        return null;
                    }
                    argsLeft = colon8.tl$0();
                    boxedUnit2 = BoxedUnit.UNIT;
                    continue;
                }
                .colon.colon colon9 = (.colon.colon)colon4.tl$0();
                descriptionArg$0.elem = (String)colon9.hd();
                argsLeft = colon9.tl$0();
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            .colon.colon colon10 = (.colon.colon)colon4.tl$0();
            versionArg$0.elem = new Version((String)colon10.hd());
            argsLeft = colon10.tl$0();
            boxedUnit2 = BoxedUnit.UNIT;
        }
        return new anon.0(nameArg$0, packdirArg$0, outdirArg$0, linkBaseArg$0, versionArg$0, descriptionArg$0, dependsArg$0);
    }

    public String readFile(String filename) {
        FileReader reader = new FileReader(filename);
        char[] rbuf = new char[1024];
        StringBuffer wbuf = new StringBuffer();
        int n = 0;
        while ((n = reader.read(rbuf)) >= 0) {
            wbuf.append(rbuf, 0, n);
        }
        reader.close();
        return wbuf.toString();
    }

    public String fullHelp() {
        return this.fullHelp;
    }

    public String oneLineHelp() {
        return this.oneLineHelp;
    }

    public String name() {
        return this.name;
    }
}

